/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.bamboo;

import com.atlassian.bamboo.setup.BambooHomeLocator;
import com.atlassian.config.HomeLocator;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.sal.api.component.ComponentLocator;
import de.resolution.usersync.api.SharedHomeProvider;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BambooComponent
public class BambooSharedHomeProvider
implements SharedHomeProvider {
    private static final Logger logger = LoggerFactory.getLogger(BambooSharedHomeProvider.class);
    private File sharedHome;

    public BambooSharedHomeProvider() {
        BambooHomeLocator bambooHomeLocator = null;
        try {
            bambooHomeLocator = (BambooHomeLocator)ComponentLocator.getComponent(BambooHomeLocator.class);
        }
        catch (Exception e) {
            this.sharedHome = this.getLocalHome();
        }
        if (bambooHomeLocator == null) {
            this.sharedHome = this.getLocalHome();
        } else {
            String sharedHomePath = bambooHomeLocator.getSharedHomePath();
            if (sharedHomePath == null) {
                this.sharedHome = this.getLocalHome();
            } else {
                logger.debug("Path to shared home is {}", (Object)sharedHomePath);
                this.sharedHome = new File(sharedHomePath);
            }
        }
    }

    private File getLocalHome() {
        HomeLocator fallbackLocator = (HomeLocator)ComponentLocator.getComponent(HomeLocator.class);
        File localHome = new File(fallbackLocator.getHomePath());
        logger.debug("Locating Shared Home failed, using local home {}", (Object)localHome.getAbsolutePath());
        return localHome;
    }

    @Override
    public File getSharedHome() {
        return this.sharedHome;
    }
}

