/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.license.LicenseStatus;
import de.resolution.reconfigure.Utils;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.frontend.AttributeMappingTemplateMap;
import de.resolution.retransform.frontend.AttributeMappingUtils;
import de.resolution.retransform.frontend.TargetTypeMap;
import de.resolution.usersync.api.ConfluenceReadOnlyModeDetector;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.LabelValue;
import de.resolution.usersync.api.LinchpinEventSender;
import de.resolution.usersync.api.SyncFunctionFactory;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.api.UserSyncService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.api.exception.SyncAlreadyRunningException;
import de.resolution.usersync.impl.SyncJobRunner;
import de.resolution.usersync.impl.SyncStatusAoProxy;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ProfilePictureCapableConnectorConfiguration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService(value={UserSyncService.class})
public class UserSyncServiceImpl
implements UserSyncService {
    private static final Logger logger = LoggerFactory.getLogger(UserSyncServiceImpl.class);
    private static final Logger startStopLogger = LoggerFactory.getLogger((String)"de.resolution.usersync.startstop");
    private final ConnectorService connectorService;
    private final SyncFunctionFactory syncFunctionFactory;
    private final SyncStatusRepository syncStatusRepository;
    private final DirectoryAdapter directoryAdapter;
    private final LicenseChecker licenseChecker;
    private final SchedulerService schedulerService;
    private final ConfluenceReadOnlyModeDetector confluenceReadOnlyModeDetector;
    private final LinchpinEventSender linchpinEventSender;

    @Inject
    public UserSyncServiceImpl(ConnectorService connectorService, SyncStatusRepository syncStatusRepository, SyncFunctionFactory syncFunctionFactory, DirectoryAdapter directoryAdapter, LicenseChecker licenseChecker, ConfluenceReadOnlyModeDetector confluenceReadOnlyModeDetector, @ComponentImport SchedulerService schedulerService, LinchpinEventSender linchpinEventSender) {
        this.connectorService = connectorService;
        this.syncFunctionFactory = syncFunctionFactory;
        this.syncStatusRepository = syncStatusRepository;
        this.directoryAdapter = directoryAdapter;
        this.licenseChecker = licenseChecker;
        this.confluenceReadOnlyModeDetector = confluenceReadOnlyModeDetector;
        this.schedulerService = schedulerService;
        this.linchpinEventSender = linchpinEventSender;
    }

    @Override
    public SyncStatus sync(@Nonnull String connectorUID) {
        SyncStatusAoProxy syncStatus = this.syncStatusRepository.create(connectorUID);
        try {
            ConnectorAndValidationResult connectorAndValidationResult = this.connectorService.getConnectorByUniqueId(connectorUID);
            if (!connectorAndValidationResult.getValidationResult().isValid()) {
                syncStatus.facade().fail("Connector is not valid, cannot start sync", logger);
                return syncStatus;
            }
        }
        catch (Exception e) {
            syncStatus.facade().fail("Loading connector failed", e, logger);
            return syncStatus;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("CONNECTOR_UID", connectorUID);
        parameters.put("SYNCSTATUS_ID", syncStatus.getId());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)SyncJobRunner.JOB_RUNNER_KEY).withSchedule(Schedule.runOnce((Date)new Date())).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters(parameters);
        try {
            JobId jobId = this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
            syncStatus.addMessage("Scheduled with jobid " + jobId);
        }
        catch (SchedulerServiceException e) {
            logger.error("Scheduling job for immediate sync failed!", (Throwable)e);
        }
        return syncStatus;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void sync(@Nonnull String connectorUID, int syncStatusId) throws SyncAlreadyRunningException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public SyncSingleUserResult syncSingleUser(@Nonnull String identifier, @Nullable MapStructuredData additionalData, @Nullable Map<String, Set<String>> attributesToOverride, @Nonnull String connectorUID) throws ConfigurationFailedException, ConnectorFactoryNotAvailableException, ConnectorNotFoundException {
        return this.syncSingleUser(identifier, additionalData, attributesToOverride, null, connectorUID);
    }

    @Override
    public SyncSingleUserResult syncSingleUser(@Nonnull String identifier, @Nullable MapStructuredData additionalData, @Nullable Map<String, Set<String>> attributesToOverride, @Nullable String overridingPrimaryAttribute, @Nonnull String connectorUID) throws ConfigurationFailedException, ConnectorFactoryNotAvailableException, ConnectorNotFoundException {
        ConnectorAndValidationResult connectorAndValidationResult = this.connectorService.getConnectorByUniqueId(connectorUID);
        Object connector = connectorAndValidationResult.getConnector();
        Object configuration = connector.getConfiguration();
        LicenseStatus licenseStatus = this.licenseChecker.checkLicense();
        if (!licenseStatus.isLicensed()) {
            return SyncSingleUserResult.createFailure(licenseStatus.getMessage());
        }
        if (connector.isCanSyncSingleUser()) {
            if (!this.directoryAdapter.exists(configuration.getDirectoryId())) {
                return SyncSingleUserResult.createFailure(String.format("Directory %d does not exist", configuration.getDirectoryId()));
            }
            if (!this.directoryAdapter.isActive(configuration.getDirectoryId())) {
                return SyncSingleUserResult.createFailure(String.format("Directory %d is inactive.", configuration.getDirectoryId()));
            }
            if (!this.directoryAdapter.isWritable(configuration.getDirectoryId())) {
                return SyncSingleUserResult.createFailure(String.format("Directory %d is not writable", configuration.getDirectoryId()));
            }
            if (logger.isInfoEnabled() && this.confluenceReadOnlyModeDetector.isReadOnlyMode()) {
                logger.info("Readonly mode is active, but we behave like an LDAP-directory and update the user.");
            }
            if (connectorAndValidationResult.getValidationResult().isValid()) {
                try {
                    SyncSingleUserResult syncSingleUserResult = connector.syncSingleUser(identifier, additionalData, attributesToOverride, overridingPrimaryAttribute);
                    this.linchpinEventSender.sendUserUpdatedEvent(syncSingleUserResult.getUpdateUserResult(), (Connector<?>)connector);
                    return syncSingleUserResult;
                }
                catch (Exception e) {
                    return SyncSingleUserResult.createFailure(e);
                }
            }
            return SyncSingleUserResult.createFailure("Connector is invalid");
        }
        return SyncSingleUserResult.createFailure("Single User Sync is not supported by this connector");
    }

    @Override
    public List<LabelValue<String, String>> getAvailableConnectorNamesAndUniqueIds() {
        return this.connectorService.getAvailableConnectorNamesAndUniqueIds();
    }

    @Override
    @Nullable
    public String getConnectorUIDforLegacyId(int connectorId) {
        return this.connectorService.getConnectorUIDforLegacyId(connectorId);
    }

    @Override
    public boolean isUserSyncInitialized() {
        return this.connectorService.isInitialized();
    }

    @Override
    public void initUserSync() {
        this.connectorService.initUserSyncConnectors();
    }

    @Override
    public Map<String, Object> getAnalyticsData(int consentLevel) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> connectorData = new ArrayList<HashMap<String, Object>>();
        data.put("len", this.connectorService.getConnectors().size());
        for (ConnectorAndValidationResult connectorAndValidationResult : this.connectorService.getConnectors()) {
            HashMap<String, Object> currentData = new HashMap<String, Object>();
            Object connector = connectorAndValidationResult.getConnector();
            String type = connector.getClass().getSimpleName();
            currentData.put("type", type);
            TargetTypeMap targetTypeMap = connector.getAttributeMappingTemplates();
            AttributeMappingTemplateMap attributeMappingTemplateMap = new AttributeMappingTemplateMap();
            attributeMappingTemplateMap.put(type, targetTypeMap);
            Map<String, Object> attributes = AttributeMappingUtils.getMatchingPresetsForAnalytics(connector.getConfiguration().getAttributeTransformationConfigs(), type, attributeMappingTemplateMap);
            Utils.flattenAndIntegrateWithPrefix(currentData, "attributes", attributes);
            currentData.put("usesToLowerCaseTransformation", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().isToLowerCase()));
            currentData.put("usesSplitTransformation", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().getSplitAttribute().isEnabled()));
            currentData.put("usesAddConstantTransformation", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().getAddConstant().isEnabled()));
            currentData.put("usesRegexAndReplacementTransformation", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().getRegexAndReplacement().isEnabled()));
            currentData.put("isGroovySourceType", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getSource().getType().equals((Object)Source.Type.GROOVY)));
            currentData.put("isFirstSourceType", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getSource().getType().equals((Object)Source.Type.FIRST)));
            currentData.put("isFieldcombinerSourceType", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getSource().getType().equals((Object)Source.Type.FIELD_COMBINER)));
            currentData.put("customFindByAttributeName", !connector.getConfiguration().getFindByAttributeName().equals(connector.getConfiguration().getDefaultFindByAttributeName()));
            currentData.put("groupsToKeepContainWildcard", connector.getConfiguration().getGroupsToKeep().stream().anyMatch(s -> s.equals(".*")));
            currentData.put("isScheduled", connector.getConfiguration().isScheduled());
            currentData.put("cleanupBehaviour", (Object)connector.getConfiguration().getCleanupBehaviour());
            currentData.put("isRemoveAllGroupAssignmentsOnCleanup", connector.getConfiguration().isRemoveAllGroupAssignmentsOnCleanup());
            if (connector.getConfiguration() instanceof ProfilePictureCapableConnectorConfiguration) {
                ProfilePictureCapableConnectorConfiguration conf = (ProfilePictureCapableConnectorConfiguration)connector.getConfiguration();
                currentData.put("isFetchProfilePicture", conf.isFetchProfilePicture());
            }
            connectorData.add(currentData);
        }
        data.put("connectors", connectorData);
        return data;
    }

    private static /* synthetic */ RuntimeException lambda$sync$0(int syncStatusId) {
        return new RuntimeException("SyncStatus " + syncStatusId + " was not found!");
    }
}

