/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ResourceConflictException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterType;
import de.resolution.atlasuser.api.CancelHandle;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.DirectoryNotFoundException;
import de.resolution.atlasuser.api.exception.InvalidSearchFilterException;
import de.resolution.atlasuser.api.group.AtlasGroup;
import de.resolution.atlasuser.api.group.AtlasGroupAdapter;
import de.resolution.atlasuser.api.group.AtlasGroupReference;
import de.resolution.atlasuser.api.group.AtlasGroupResult;
import de.resolution.atlasuser.api.group.GroupSearchResult;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.api.user.AttributeFilter;
import de.resolution.atlasuser.api.user.SearchFilter;
import de.resolution.atlasuser.api.user.SortBy;
import de.resolution.atlasuser.api.user.UserSearchResult;
import de.resolution.atlasuser.impl.SimpleCancelHandle;
import de.resolution.atlasuser.impl.group.AtlasGroupBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.SearchFilterBuilder;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.MapUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.TransformationResults;
import de.resolution.usersync.api.cleanup.UserCleanup;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.builtin.scim.ScimConnectorConfiguration;
import de.resolution.usersync.builtin.scim.UserOrGroupRef;
import de.resolution.usersync.builtin.scim.exception.GroupNotFoundException;
import de.resolution.usersync.builtin.scim.exception.UserNotFoundException;
import de.resolution.usersync.builtin.scim.group.ScimCoreGroup;
import de.resolution.usersync.builtin.scim.rest.ListResponse;
import de.resolution.usersync.builtin.scim.user.ScimCoreUser;
import de.resolution.usersync.spi.AbstractConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public class ScimConnector
extends AbstractConnector<ScimConnectorConfiguration> {
    public static final String ATTRIBUTE_SCIM_EXTERNAL_ID = "SCIM_EXTERNAL_ID";
    protected static final String VALUE = "value";
    private static final Logger logger = LoggerFactory.getLogger(ScimConnector.class);
    private final AtlasGroupAdapter atlasGroupAdapter;

    protected ScimConnector(@Nonnull ConnectorService connectorService, AtlasUserAdapter atlasUserAdapter, AtlasGroupAdapter atlasGroupAdapter, @Nonnull ScimConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/ScimConnector.json");
        this.atlasGroupAdapter = atlasGroupAdapter;
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        syncStatusFacade.fail("Sync is not supported in this connector", logger);
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        return FindUserResult.failed("Single User Update is not supported in this connector");
    }

    @Override
    @Nullable
    public String getAuthorizationCodeUrl() {
        return this.getScimBaseUrl();
    }

    @Nonnull
    public String getScimBaseUrl() {
        return String.format("%s%s/usersync/connector/%s/scim/v2", this.connectorService.getBaseUrl(), "/rest/samlsso-admin/1.0", this.getUniqueId());
    }

    @Override
    @Nonnull
    public Class<ScimConnectorConfiguration> getConfigurationClass() {
        return ScimConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "SCIM 2.0";
    }

    @Override
    @Nonnull
    public List<String> getConnectorAttributes() {
        return ScimCoreUser.getFlatAttributes();
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    @Override
    public boolean isCanSync() {
        return false;
    }

    @Override
    public boolean isCanSyncSingleUser() {
        return false;
    }

    @Override
    public boolean isCanBeScheduled() {
        return false;
    }

    @Override
    public boolean isAllowGroupConfiguration() {
        return false;
    }

    @Override
    public boolean isCanHaveRequiredGroups() {
        return false;
    }

    @Nonnull
    public AtlasUser buildAtlasUser(@Nullable String userId, @Nonnull StructuredData data) throws ScimException {
        AtlasUserReference ref;
        TransformationResults transformationResults;
        AtlasUserResult result;
        Optional optionalResultingUser;
        Map existingAttributes = null;
        if (userId != null && !userId.isEmpty() && (optionalResultingUser = (result = this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create((String)"ATTR_ID", (Object)userId, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()))).getResultingUser()).isPresent()) {
            existingAttributes = ((AtlasUser)optionalResultingUser.get()).getAttributes();
        }
        try {
            transformationResults = this.applyTransformations((Map<String, ?>)data.asMap(), null, existingAttributes);
        }
        catch (TransformationFailedException e) {
            throw new ServerErrorException("Could not create AtlasUser because of failing transformation: " + e.getMessage(), null, (Throwable)e);
        }
        HashMap<String, Collection<String>> transformedAttributes = new HashMap<String, Collection<String>>(transformationResults.getTransformedAttributes());
        if (userId != null && !userId.isEmpty()) {
            ref = AtlasUserReference.create((String)"ATTR_ID", (Object)userId, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        } else {
            AttributeTransformationResult lookupAttributeTransformationResult;
            String findByAttributeName = ((ScimConnectorConfiguration)this.configuration).getFindByAttributeName();
            try {
                lookupAttributeTransformationResult = this.transformLookupAttribute((Map<String, ?>)data.asMap(), null, findByAttributeName);
            }
            catch (TransformationFailedException e) {
                throw new BadRequestException("Transformation for lookup attribute failed.", "invalidValue");
            }
            String findByAttributeValue = lookupAttributeTransformationResult.getFirstValue();
            if (findByAttributeValue == null || findByAttributeValue.isEmpty()) {
                throw new BadRequestException("Transformation for " + findByAttributeName + " returned no value", "invalidValue");
            }
            if (lookupAttributeTransformationResult.isDrop()) {
                throw new BadRequestException("Lookup attribute must not be dropped during transformation", "invalidValue");
            }
            if (lookupAttributeTransformationResult.isDropAll()) {
                throw new BadRequestException("Lookup attribute transformation returned dropAll", "invalidValue");
            }
            ref = AtlasUserReference.create((String)findByAttributeName, (Object)findByAttributeValue, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        }
        AtlasUserBuilder atlasUserBuilder = AtlasUser.builder();
        atlasUserBuilder.findBy(ref).in(((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        transformedAttributes.forEach((arg_0, arg_1) -> ((AtlasUserBuilder)atlasUserBuilder).with(arg_0, arg_1));
        atlasUserBuilder.with("ATTR_IS_ANONYMIZED", Collections.emptySet());
        return atlasUserBuilder.build();
    }

    @Nonnull
    private AtlasGroup buildAtlasGroup(@Nullable String groupName, @Nonnull StructuredData data) {
        if (groupName == null) {
            groupName = data.findOrEmpty("displayName").asString();
        }
        AtlasGroupReference ref = AtlasGroupReference.create((String)groupName, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        AtlasGroupBuilder atlasGroupBuilder = AtlasGroup.builder();
        atlasGroupBuilder.findBy(ref).with("ATTR_GROUPNAME", new String[]{groupName}).with(ATTRIBUTE_SCIM_EXTERNAL_ID, new String[]{data.findString("externalId")});
        ArrayList<String> memberIds = new ArrayList<String>();
        StructuredData members = data.find("members");
        if (members != null && members.isList()) {
            for (StructuredData member : members.asList()) {
                String memberId = member.findString(VALUE);
                if (memberId != null) {
                    memberIds.add(memberId);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("SCIM group does not contain a member value: {}", (Object)JSONUtil.asJson((Object)member));
            }
            atlasGroupBuilder.with("ATTR_MEMBERS", memberIds);
        }
        return atlasGroupBuilder.build();
    }

    @Nonnull
    public ScimCoreUser buildScimUser(@Nonnull AtlasUser atlasUser, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        ScimCoreUser.ScimCoreUserBuilder builder = ScimCoreUser.builder().with("id", atlasUser.get("ATTR_ID").orElse(null)).with("userName", atlasUser.get("ATTR_NAME").orElse(null)).with("externalId", atlasUser.get(ATTRIBUTE_SCIM_EXTERNAL_ID).orElse(null)).with("displayName", atlasUser.get("ATTR_FULLNAME").orElse(null)).with("name.formatted", atlasUser.get("ATTR_FULLNAME").orElse(null)).active(atlasUser.isActive()).with("emails[0].value", atlasUser.get("ATTR_EMAIL").orElse(null)).with("emails[0].type", "work");
        ArrayList groups = new ArrayList();
        if (atlasUser.get("ATTR_GROUPS").isPresent()) {
            Set groupNames = atlasUser.getAttributeValues("ATTR_GROUPS");
            for (String groupName : groupNames) {
                HashMap<String, String> group = new HashMap<String, String>();
                group.put(VALUE, groupName);
                group.put("display", groupName);
                this.createRefPath(UserOrGroupRef.createGroupRef(groupName)).ifPresent(refPath -> group.put("#ref", (String)refPath));
                groups.add(group);
            }
        }
        builder.with("groups", groups);
        excludedAttributes.forEach(builder::without);
        return builder.build();
    }

    @Nonnull
    public ScimCoreGroup buildScimGroup(@Nonnull AtlasGroup group, @Nullable Collection<UserOrGroupRef> memberRefs, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        ScimCoreGroup.ScimCoreGroupBuilder builder = ScimCoreGroup.builder();
        builder.with("id", group.getGroupName());
        builder.with("displayName", group.getGroupName());
        group.get(ATTRIBUTE_SCIM_EXTERNAL_ID).ifPresent(externalId -> builder.with("externalId", externalId));
        if (memberRefs != null) {
            ArrayList members = new ArrayList();
            for (UserOrGroupRef memberRef : memberRefs) {
                String id = memberRef.getId();
                HashMap<String, String> member = new HashMap<String, String>();
                member.put(VALUE, id);
                member.put("type", memberRef.getType().getValue());
                this.createRefPath(memberRef).ifPresent(refPath -> member.put("#ref", (String)refPath));
                members.add(member);
            }
            builder.with("members", members);
        }
        excludedAttributes.forEach(builder::without);
        return builder.build();
    }

    @Nonnull
    private Optional<String> createRefPath(@Nonnull UserOrGroupRef ref) {
        if (ref.getType() == UserOrGroupRef.Type.USER) {
            return Optional.of(this.getScimBaseUrl() + "/Users/" + ref.getId());
        }
        if (ref.getType() == UserOrGroupRef.Type.GROUP) {
            return Optional.of(this.getScimBaseUrl() + "/Groups/" + ref.getId());
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<String> getUserIdForUserWithExternalId(@Nonnull String attributeName, @Nonnull String attributeValue) {
        AtlasUserReference ref = AtlasUserReference.create((String)attributeName, (Object)attributeValue, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        AtlasUserResult foundUserResult = this.atlasUserAdapter.readFirstUniqueUser(ref, this.attributeTransformerMap.keySet());
        Optional optionalResultingUser = foundUserResult.getResultingUser();
        if (!optionalResultingUser.isPresent()) {
            return Optional.empty();
        }
        AtlasUser resultingUser = (AtlasUser)optionalResultingUser.get();
        return resultingUser.get("ATTR_ID");
    }

    @Nonnull
    public ListResponse getUsers(int startIndex, int count, @Nullable Filter filter, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        UserSearchResult searchResult;
        if (filter != null) {
            if (filter.getFilterType() == FilterType.EQUAL && !filter.isCombiningFilter() && "userName".equalsIgnoreCase(filter.getAttributePath().toString())) {
                String username = filter.getComparisonValue().textValue();
                Optional<String> userid = this.getUserIdForUserWithExternalId("ATTR_NAME", username);
                if (!userid.isPresent()) {
                    return ListResponse.createEmptyListResponse(startIndex);
                }
                try {
                    ScimCoreUser user = this.getUser(userid.get(), attributes, excludedAttributes);
                    return ListResponse.createSingleResourceListResponse(startIndex, user);
                }
                catch (ResourceNotFoundException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    return ListResponse.createEmptyListResponse(startIndex);
                }
            }
            if (filter.getFilterType() == FilterType.EQUAL && !filter.isCombiningFilter() && "externalId".equalsIgnoreCase(filter.getAttributePath().toString())) {
                String externalId = filter.getComparisonValue().textValue();
                Optional<String> userid = this.getUserIdForUserWithExternalId(ATTRIBUTE_SCIM_EXTERNAL_ID, externalId);
                if (!userid.isPresent()) {
                    return ListResponse.createEmptyListResponse(startIndex);
                }
                try {
                    ScimCoreUser user = this.getUser(userid.get(), attributes, excludedAttributes);
                    return ListResponse.createSingleResourceListResponse(startIndex, user);
                }
                catch (ResourceNotFoundException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                    return ListResponse.createEmptyListResponse(startIndex);
                }
            }
            if (logger.isErrorEnabled()) {
                logger.error("Unsupported user filter: {}", (Object)JSONUtil.asJson((Object)filter));
            }
            throw new BadRequestException("Unsupported filter", "invalidFilter");
        }
        SearchFilterBuilder searchFilterBuilder = SearchFilter.builder().directoryId(((ScimConnectorConfiguration)this.configuration).getDirectoryId()).attributeFilters(new AttributeFilter[]{AttributeFilter.notPresent((String[])new String[]{"ATTR_IS_ANONYMIZED"})});
        try {
            searchResult = this.atlasUserAdapter.search(searchFilterBuilder.build(), SortBy.name(), (CancelHandle)new SimpleCancelHandle());
        }
        catch (AtlasUserOperationFailedException | DirectoryNotFoundException | InvalidSearchFilterException e) {
            throw new ServerErrorException(e.getMessage(), null, e);
        }
        ListResponse.ListResponseBuilder builder = ListResponse.builder().totalResults(searchResult.size()).startIndex(startIndex + 1);
        if (count > 0) {
            List atlasUsers;
            try {
                atlasUsers = searchResult.retrievePage(startIndex, count);
            }
            catch (AtlasUserOperationFailedException e) {
                throw new ServerErrorException(e.getMessage(), null, (Throwable)e);
            }
            builder.itemsPerPage(count);
            for (Optional optionalAtlasUser : atlasUsers) {
                if (optionalAtlasUser.isPresent()) {
                    ScimCoreUser scimCoreUser = this.buildScimUser((AtlasUser)optionalAtlasUser.get(), attributes, excludedAttributes);
                    builder.resource(scimCoreUser);
                    continue;
                }
                if (!logger.isErrorEnabled()) continue;
                logger.error("Resulting User not present during while loading users");
            }
        } else {
            builder.itemsPerPage(searchResult.size());
            for (Optional optionalAtlasUser : searchResult) {
                if (optionalAtlasUser.isPresent()) {
                    ScimCoreUser scimCoreUser = this.buildScimUser((AtlasUser)optionalAtlasUser.get(), attributes, excludedAttributes);
                    builder.resource(scimCoreUser);
                    continue;
                }
                if (!logger.isErrorEnabled()) continue;
                logger.error("Resulting User not present during while loading users");
            }
        }
        return builder.build();
    }

    @Nonnull
    public ScimCoreUser getUser(@Nonnull String userId, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        AtlasUserReference userRef = AtlasUserReference.create((String)"ATTR_ID", (Object)userId, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        AtlasUserResult readResult = this.atlasUserAdapter.readFirstUniqueUser(userRef, this.attributeTransformerMap.keySet());
        Optional optionalResultingUser = readResult.getResultingUser();
        if (readResult.isSuccess() && optionalResultingUser.isPresent()) {
            AtlasUser resultingUser = (AtlasUser)optionalResultingUser.get();
            return this.buildScimUser(resultingUser, attributes, excludedAttributes);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Get user failed: {}", (Object)JSONUtil.asJson((Object)readResult));
        }
        throw new UserNotFoundException(userId);
    }

    @Nonnull
    public ScimCoreUser createOrUpdateUser(@Nonnull StructuredData data, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        AtlasUser atlasUserToCreate = this.buildAtlasUser(null, data);
        AtlasUserResult createOrUpdateResult = this.atlasUserAdapter.createOrUpdate(atlasUserToCreate, ((ScimConnectorConfiguration)this.configuration).getCopyBehaviour(), this.attributeTransformerMap.keySet());
        Optional optionalResultingUser = createOrUpdateResult.getResultingUser();
        if (createOrUpdateResult.isSuccess() && optionalResultingUser.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} user: {}", (Object)createOrUpdateResult.getOperation(), (Object)JSONUtil.asJson((Object)createOrUpdateResult));
            }
            AtlasUser resultingUser = (AtlasUser)optionalResultingUser.get();
            return this.buildScimUser(resultingUser, attributes, excludedAttributes);
        }
        if (logger.isErrorEnabled()) {
            logger.error("Creating or updating user failed: {}", (Object)JSONUtil.asJson((Object)createOrUpdateResult));
        }
        throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)createOrUpdateResult.getMessages().orElse(Collections.singletonList("Creating user failed"))));
    }

    @Nonnull
    public ScimCoreUser updateUser(@Nonnull String userId, @Nonnull StructuredData data, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        AtlasUser atlasUserToUpdate = this.buildAtlasUser(userId, data);
        AtlasUserResult updateResult = this.atlasUserAdapter.update(atlasUserToUpdate, this.attributeTransformerMap.keySet());
        Optional optionalResultingUser = updateResult.getResultingUser();
        if (updateResult.isSuccess() && optionalResultingUser.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Updated user: {}", (Object)JSONUtil.asJson((Object)updateResult));
            }
            AtlasUser resultingUser = (AtlasUser)optionalResultingUser.get();
            return this.buildScimUser(resultingUser, attributes, excludedAttributes);
        }
        if (logger.isErrorEnabled()) {
            logger.error("Updating user failed: {}", (Object)JSONUtil.asJson((Object)updateResult));
        }
        throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)updateResult.getMessages().orElse(Collections.singletonList("Updating user failed"))));
    }

    @Nonnull
    public ScimCoreUser patchUser(@Nonnull String userId, @Nonnull StructuredData data, @Nonnull Set<StructuredData> groupsToAdd, @Nonnull Set<StructuredData> groupsToRemove, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        AtlasUser atlasUserToUpdate = this.buildAtlasUser(userId, data);
        if (!CollectionUtil.isNullOrEmpty(groupsToAdd) || !CollectionUtil.isNullOrEmpty(groupsToRemove)) {
            Set transformedGroupsToAdd;
            Set transformedGroupsToRemove;
            atlasUserToUpdate = AtlasUser.builder().from(atlasUserToUpdate).without("ATTR_GROUPS").build();
            try {
                transformedGroupsToRemove = this.applyTransformations(MapUtil.of((Object)"groups", groupsToRemove), null, null).getTransformedAttributes().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                transformedGroupsToAdd = this.applyTransformations(MapUtil.of((Object)"groups", groupsToAdd), null, null).getTransformedAttributes().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            }
            catch (TransformationFailedException e) {
                throw new ServerErrorException("Transforming incoming attributes failed", null, (Throwable)e);
            }
            transformedGroupsToRemove.removeAll(transformedGroupsToAdd);
            for (String transformedGroup : transformedGroupsToRemove) {
                this.removeMemberFromGroup(Collections.singleton(UserOrGroupRef.createUserRef(userId)), transformedGroup);
            }
            for (String transformedGroup : transformedGroupsToAdd) {
                this.addMemberIdsToGroup(Collections.singletonList(userId), transformedGroup);
            }
        }
        AtlasUserResult updateResult = this.atlasUserAdapter.update(atlasUserToUpdate, this.attributeTransformerMap.keySet());
        Optional optionalResultingUser = updateResult.getResultingUser();
        if (updateResult.isSuccess() && optionalResultingUser.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Updated user: {}", (Object)JSONUtil.asJson((Object)updateResult));
            }
            AtlasUser resultingUser = (AtlasUser)optionalResultingUser.get();
            return this.buildScimUser(resultingUser, attributes, excludedAttributes);
        }
        if (logger.isErrorEnabled()) {
            logger.error("Updating user failed: {}", (Object)JSONUtil.asJson((Object)updateResult));
        }
        throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)updateResult.getMessages().orElse(Collections.singletonList("Updating user failed"))));
    }

    public void deleteUser(@Nonnull String userId) throws ResourceNotFoundException, ServerErrorException {
        AtlasUserReference ref = AtlasUserReference.create((String)"ATTR_ID", (Object)userId, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(ref, this.attributeTransformerMap.keySet());
        Optional optionalAtlasUser = atlasUserResult.getResultingUser();
        if (!atlasUserResult.isSuccess() || !optionalAtlasUser.isPresent()) {
            throw new UserNotFoundException(userId);
        }
        UserCleanup userCleanup = new UserCleanup(((ScimConnectorConfiguration)this.configuration).getCleanupBehaviour(), this.atlasUserAdapter, this.attributeTransformerMap.keySet(), ((ScimConnectorConfiguration)this.configuration).isRemoveAllGroupAssignmentsOnCleanup(), ((ScimConnectorConfiguration)this.configuration).getGroupsOrRegexNotBeRemoved());
        AtlasUserResult cleanupResult = userCleanup.cleanupUser((AtlasUser)optionalAtlasUser.get());
        if (cleanupResult.isSuccess()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cleaned up user: {}", (Object)JSONUtil.asJson((Object)cleanupResult));
            }
        } else {
            if (logger.isErrorEnabled()) {
                logger.error("Cleaning up user failed: {}", (Object)JSONUtil.asJson((Object)cleanupResult));
            }
            throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)cleanupResult.getMessages().orElse(Collections.singletonList("Cleaning up user failed"))));
        }
    }

    @Nonnull
    public ListResponse getDirectoryGroups(int startIndex, int count, @Nullable Filter filter, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        GroupSearchResult groupSearchResult;
        if (filter != null) {
            if (filter.getFilterType() == FilterType.EQUAL && !filter.isCombiningFilter() && "displayName".equalsIgnoreCase(filter.getAttributePath().toString())) {
                String groupName = filter.getComparisonValue().textValue();
                if (logger.isDebugEnabled()) {
                    logger.debug("Filter by groupName {}", (Object)groupName);
                }
                try {
                    ScimCoreGroup group = this.getDirectoryGroup(groupName, attributes, excludedAttributes);
                    return ListResponse.createSingleResourceListResponse(startIndex, group);
                }
                catch (ResourceNotFoundException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Group with name {} was not found", (Object)groupName, (Object)e);
                    }
                    return ListResponse.createEmptyListResponse(startIndex);
                }
            }
            if (logger.isErrorEnabled()) {
                logger.error("Unsupported group filter: {}", (Object)JSONUtil.asJson((Object)filter));
            }
            throw new BadRequestException("Unsupported filter", "invalidFilter");
        }
        try {
            groupSearchResult = this.atlasGroupAdapter.search(startIndex, count, ((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        }
        catch (AtlasUserOperationFailedException e) {
            throw new ServerErrorException(e.getMessage(), null, (Throwable)e);
        }
        ListResponse.ListResponseBuilder builder = ListResponse.builder().totalResults(groupSearchResult.getTotalGroupCount()).itemsPerPage(count).startIndex(startIndex + 1);
        for (AtlasGroup group : groupSearchResult.getGroups()) {
            Collection<UserOrGroupRef> memberIds = this.getGroupMembers(group.getReference().getGroupName());
            ScimCoreGroup scimCoreGroup = this.buildScimGroup(group, memberIds, attributes, excludedAttributes);
            builder.resource(scimCoreGroup);
        }
        return builder.build();
    }

    @Nonnull
    public ScimCoreGroup getDirectoryGroup(@Nonnull String groupName, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        AtlasGroupResult readResult = this.atlasGroupAdapter.read(AtlasGroupReference.create((String)groupName, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
        Optional optionalResultingGroup = readResult.getResultingGroup();
        if (readResult.isSuccess() && optionalResultingGroup.isPresent()) {
            AtlasGroup group = (AtlasGroup)optionalResultingGroup.get();
            Collection<UserOrGroupRef> memberIds = this.getGroupMembers(group.getReference().getGroupName());
            return this.buildScimGroup(group, memberIds, attributes, excludedAttributes);
        }
        if (logger.isDebugEnabled()) {
            logger.error("Group not found: {}", (Object)JSONUtil.asJson((Object)readResult));
        }
        throw new GroupNotFoundException(groupName);
    }

    @Nonnull
    public ScimCoreGroup createDirectoryGroup(@Nonnull StructuredData data, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        AtlasGroup createdGroup;
        String groupName;
        AtlasGroup atlasGroupToCreate = this.buildAtlasGroup(null, data);
        AtlasGroupResult findByGroupNameResult = this.atlasGroupAdapter.read(atlasGroupToCreate.getReference());
        if (findByGroupNameResult.isSuccess() && findByGroupNameResult.getResultingGroup().isPresent()) {
            throw new ResourceConflictException("Group with name " + atlasGroupToCreate.getGroupName() + " already exists", "uniqueness", null);
        }
        AtlasGroupResult createResult = this.atlasGroupAdapter.create(atlasGroupToCreate);
        Optional optionalResultingGroup = createResult.getResultingGroup();
        if (!createResult.isSuccess() || !optionalResultingGroup.isPresent()) {
            if (logger.isErrorEnabled()) {
                logger.error("Creating group failed: {}", (Object)JSONUtil.asJson((Object)createResult));
            }
            throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)createResult.getMessages().orElse(Collections.singletonList("Creating group failed"))));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created group: {}", (Object)JSONUtil.asJson((Object)createResult));
        }
        if ((groupName = (createdGroup = (AtlasGroup)optionalResultingGroup.get()).getGroupName()) == null) {
            throw new ServerErrorException("Group contains no groupName after creation");
        }
        this.setMemberIdsForGroup(atlasGroupToCreate.getAttributeValues("ATTR_MEMBERS"), groupName);
        return this.getDirectoryGroup(createdGroup.getGroupName(), attributes, excludedAttributes);
    }

    @Nonnull
    public ScimCoreGroup updateDirectoryGroup(@Nonnull String groupName, @Nonnull StructuredData data, @Nonnull Set<String> attributes, @Nonnull Set<String> excludedAttributes) throws ScimException {
        AtlasGroup atlasGroupToUpdate = this.buildAtlasGroup(groupName, data);
        this.setMemberIdsForGroup(atlasGroupToUpdate.getAttributeValues("ATTR_MEMBERS"), groupName);
        return this.getDirectoryGroup(groupName, attributes, excludedAttributes);
    }

    public void deleteDirectoryGroup(@Nonnull String groupName) throws ScimException {
        AtlasGroupReference ref = AtlasGroupReference.create((String)groupName, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId());
        AtlasGroupResult deleteResult = this.atlasGroupAdapter.delete(ref);
        if (deleteResult.isSuccess()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Deleted group: {}", (Object)JSONUtil.asJson((Object)deleteResult));
            }
        } else {
            if (logger.isErrorEnabled()) {
                logger.error("Deleting group failed: {}", (Object)JSONUtil.asJson((Object)deleteResult));
            }
            throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)deleteResult.getMessages().orElse(Collections.singletonList("Deleting group failed"))));
        }
    }

    @Nonnull
    public Collection<UserOrGroupRef> getGroupMembers(@Nonnull String groupName) throws ScimException {
        ArrayList<UserOrGroupRef> members = new ArrayList<UserOrGroupRef>();
        try {
            UserSearchResult directMemberships = this.atlasGroupAdapter.getDirectMemberships(AtlasGroupReference.create((String)groupName, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
            Iterator userWithAttributesIterator = directMemberships.coreAttributesIterator();
            while (userWithAttributesIterator.hasNext()) {
                Map coreAttributes = (Map)userWithAttributesIterator.next();
                String id = (String)coreAttributes.get("ATTR_ID");
                if (StringUtil.isNullOrEmpty((String)id)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("User has no externalId: {}", (Object)JSONUtil.asJson((Object)coreAttributes));
                    continue;
                }
                members.add(UserOrGroupRef.createUserRef(id));
            }
            GroupSearchResult groupSearchResult = this.atlasGroupAdapter.getSubGroupsOf(AtlasGroupReference.create((String)groupName, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
            if (!groupSearchResult.isSuccess()) {
                throw new ServerErrorException(groupSearchResult.getException().getMessage(), null, (Throwable)groupSearchResult.getException());
            }
            for (AtlasGroup subgroup : groupSearchResult.getGroups()) {
                members.add(UserOrGroupRef.createGroupRef(subgroup.getReference().getGroupName()));
            }
        }
        catch (AtlasUserOperationFailedException | DirectoryNotFoundException | InvalidSearchFilterException e) {
            throw new ServerErrorException(e.getMessage(), null, e);
        }
        return members;
    }

    public void setMemberIdsForGroup(@Nullable Collection<String> memberIds, @Nonnull String groupName) throws ScimException {
        if (memberIds == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("List of memberIds is empty, no members to assign");
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Submitted memberIds: {}", (Object)JSONUtil.asJson(memberIds));
        }
        Collection<UserOrGroupRef> memberRefs = this.getGroupMembers(groupName);
        if (logger.isTraceEnabled()) {
            logger.trace("Current memberIds: {}", (Object)JSONUtil.asJson(memberRefs));
        }
        HashSet<String> memberIdsToAdd = new HashSet<String>(memberIds);
        HashSet<UserOrGroupRef> memberIdsToRemove = new HashSet<UserOrGroupRef>();
        for (UserOrGroupRef memberRef : memberRefs) {
            String memberId = memberRef.getId();
            if (!memberIds.contains(memberId)) {
                memberIdsToRemove.add(memberRef);
                continue;
            }
            memberIdsToAdd.remove(memberId);
        }
        this.removeMemberFromGroup(memberIdsToRemove, groupName);
        this.addMemberIdsToGroup(memberIdsToAdd, groupName);
    }

    public void addMemberIdsToGroup(@Nonnull Collection<String> membersValues, @Nonnull String groupName) throws ServerErrorException, ResourceNotFoundException {
        HashSet<UserOrGroupRef> membersToAdd = new HashSet<UserOrGroupRef>();
        for (String memberId : membersValues) {
            AtlasGroupResult atlasGroupResult;
            UserOrGroupRef ref = null;
            AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create((String)"ATTR_ID", (Object)memberId, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
            if (atlasUserResult.isSuccess() && atlasUserResult.getResultingUser().isPresent()) {
                ref = UserOrGroupRef.createUserRef(memberId);
            }
            if (ref == null && (atlasGroupResult = this.atlasGroupAdapter.read(AtlasGroupReference.create((String)memberId, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()))).isSuccess() && atlasGroupResult.getResultingGroup().isPresent()) {
                ref = UserOrGroupRef.createGroupRef(memberId);
            }
            if (ref == null) {
                throw new ResourceNotFoundException("Resource with id " + memberId + " could not be found.");
            }
            membersToAdd.add(ref);
        }
        this.addMembersToGroup(membersToAdd, groupName);
    }

    private void addMembersToGroup(@Nonnull Collection<UserOrGroupRef> memberRefs, @Nonnull String groupName) throws ServerErrorException {
        if (logger.isDebugEnabled()) {
            logger.debug("Assign members {} to group {}", (Object)JSONUtil.asJson(memberRefs), (Object)StringUtil.sanitize((String)groupName));
        }
        for (UserOrGroupRef memberRef : memberRefs) {
            AtlasGroupResult assignResult = memberRef.getType() == UserOrGroupRef.Type.GROUP ? this.atlasGroupAdapter.addGroupToGroup(AtlasGroupReference.create((String)memberRef.getId(), (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()), AtlasGroupReference.create((String)groupName, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId())) : this.atlasGroupAdapter.addUserToGroup(AtlasUserReference.create((String)"ATTR_ID", (Object)memberRef.getId(), (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()), AtlasGroupReference.create((String)groupName, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
            if (assignResult.isSuccess()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Added user with id {} to group {}: {}", new Object[]{JSONUtil.asJson((Object)memberRef), StringUtil.sanitize((String)groupName), JSONUtil.asJson((Object)assignResult)});
                continue;
            }
            if (logger.isErrorEnabled()) {
                logger.error("Adding user with id {} to group {} failed: {}", new Object[]{JSONUtil.asJson((Object)memberRef), StringUtil.sanitize((String)groupName), JSONUtil.asJson((Object)assignResult)});
            }
            throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)assignResult.getMessages().orElse(Collections.singletonList("Assigning users failed"))));
        }
    }

    public void removeMemberIdsFromGroup(@Nonnull Collection<String> membersValues, @Nonnull String groupName) throws ServerErrorException, ResourceNotFoundException {
        HashSet<UserOrGroupRef> membersToRemove = new HashSet<UserOrGroupRef>();
        for (String memberId : membersValues) {
            AtlasGroupResult atlasGroupResult;
            UserOrGroupRef ref = null;
            AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create((String)"ATTR_ID", (Object)memberId, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
            if (atlasUserResult.isSuccess() && atlasUserResult.getResultingUser().isPresent()) {
                ref = UserOrGroupRef.createUserRef(memberId);
            }
            if (ref == null && (atlasGroupResult = this.atlasGroupAdapter.read(AtlasGroupReference.create((String)memberId, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()))).isSuccess() && atlasGroupResult.getResultingGroup().isPresent()) {
                ref = UserOrGroupRef.createGroupRef(memberId);
            }
            if (ref == null) {
                throw new ResourceNotFoundException("Resource with id " + memberId + " could not be found.");
            }
            membersToRemove.add(ref);
        }
        this.removeMemberFromGroup(membersToRemove, groupName);
    }

    private void removeMemberFromGroup(@Nonnull Collection<UserOrGroupRef> memberRefs, @Nonnull String groupName) throws ServerErrorException {
        if (logger.isDebugEnabled()) {
            logger.debug("Unassign members {} from group {}", (Object)JSONUtil.asJson(memberRefs), (Object)StringUtil.sanitize((String)groupName));
        }
        for (UserOrGroupRef memberRef : memberRefs) {
            AtlasGroupResult unassignResult = memberRef.getType() == UserOrGroupRef.Type.GROUP ? this.atlasGroupAdapter.removeGroupFromGroup(AtlasGroupReference.create((String)memberRef.getId(), (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()), AtlasGroupReference.create((String)groupName, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId())) : this.atlasGroupAdapter.removeUserFromGroup(AtlasUserReference.create((String)"ATTR_ID", (Object)memberRef.getId(), (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()), AtlasGroupReference.create((String)groupName, (long)((ScimConnectorConfiguration)this.configuration).getDirectoryId()));
            if (unassignResult.isSuccess()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Removed member with id {} from group {}: {}", new Object[]{JSONUtil.asJson((Object)memberRef), StringUtil.sanitize((String)groupName), JSONUtil.asJson((Object)unassignResult)});
                continue;
            }
            if (logger.isErrorEnabled()) {
                logger.error("Removing member with id {} from group {} failed: {}", new Object[]{JSONUtil.asJson((Object)memberRef), StringUtil.sanitize((String)groupName), JSONUtil.asJson((Object)unassignResult)});
            }
            throw new ServerErrorException(String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)unassignResult.getMessages().orElse(Collections.singletonList("Unassigning users failed"))));
        }
    }
}

