/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira.userauth;

import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.jira.JiraSamlSsoService;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHook;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHookBasedLoginHandler;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHookException;
import com.resolution.atlasplugins.samlsso.userauth.PrincipalAndModified;
import com.resolution.atlasplugins.samlsso.userauth.PrincipalProvider;
import com.resolution.samlwrapper.api.exception.LoginHandlerException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.samlauth.api.AdditionalAuthenticationService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class JiraLoginHandler
extends AuthenticatorHookBasedLoginHandler {
    private static final Logger logger = LoggerFactory.getLogger(JiraLoginHandler.class);
    private final AuthenticatorHook authenticatorHook;
    private final SamlSsoService samlSsoService;
    public static final String SDCOOKIENAME_UNENCODED = "JiraSDSamlssoLogin";
    public static final String SDCOOKIENAME = "JiraSDSamlssoLoginV2";
    public static final String COOKIEVALUESEPARATOR = "###";

    @Autowired
    public JiraLoginHandler(JiraSamlSsoService samlSsoService, AdditionalAuthenticationService additionalAuthenticationService, AuthenticatorHook authenticatorHook, PrincipalProvider principalProvider, RunningConfiguration pluginConfiguration, @ComponentImport TemplateRenderer templateRenderer) {
        super(samlSsoService, additionalAuthenticationService, authenticatorHook, principalProvider, pluginConfiguration, templateRenderer);
        this.authenticatorHook = authenticatorHook;
        this.samlSsoService = samlSsoService;
    }

    @Override
    public void doLogin(HttpServletRequest req, HttpServletResponse resp, PrincipalAndModified principalAndModified, String redirectUrl, AuthenticationTracker tracker, String sessionIndex, String nameId, String idpId) throws LoginHandlerException, IOException {
        String cookieValue = URLEncoder.encode(sessionIndex + COOKIEVALUESEPARATOR + nameId + COOKIEVALUESEPARATOR + idpId + COOKIEVALUESEPARATOR + tracker.getTrackerId(), "UTF-8");
        logger.debug("Cookie value {} length is {} chars and {} bytes", new Object[]{cookieValue, cookieValue.length(), cookieValue.getBytes().length});
        logger.debug("Adding Servicedesk-Cookie {}", (Object)SDCOOKIENAME);
        Cookie cookie = new Cookie(SDCOOKIENAME, cookieValue);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setSecure(this.samlSsoService.isHttps());
        resp.addCookie(cookie);
        Principal principal = principalAndModified.getPrincipal();
        if (principalAndModified.isModifiedAndActive()) {
            String token = this.tokenStore.getSsoToken(principal.getName(), tracker);
            String urlForRedirect = this.samlSsoService.getRelativeBaseUrl() + "/plugins/servlet/samlsso" + "?" + "ssoservlettoken" + "=" + token;
            logger.debug("User is modified, redirecting again to have changes active {}", (Object)urlForRedirect);
            resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
            resp.sendRedirect(urlForRedirect);
        } else {
            try {
                String checkedRedirectUrl;
                block11: {
                    logger.debug("Trying to authorize user {}", (Object)principal.getName());
                    boolean authenticationSuccessful = this.authenticatorHook.authoriseUserAndEstablishSession(req, resp, principal, this.pluginConfiguration.isSetRememberMeCookie(), this.isServiceDeskLogin(redirectUrl), tracker);
                    if (authenticationSuccessful) {
                        String replacedRedirectUrl = redirectUrl;
                        if (redirectUrl.contains("/secure/Dashboard.jspa")) {
                            replacedRedirectUrl = redirectUrl.replace("/secure/Dashboard.jspa", "/plugins/servlet/samlsso/redirectToDashboard");
                            tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "redirecting query parameter to /plugins/servlet/samlsso/redirectToDashboard to workaround https://jira.atlassian.com/browse/JRASERVER-63278 (Error 404 when accessing Dashboard)", new Object[0]);
                        }
                        checkedRedirectUrl = replacedRedirectUrl;
                        try {
                            new URI(replacedRedirectUrl);
                        }
                        catch (URISyntaxException e) {
                            if (e.getIndex() > 0) {
                                checkedRedirectUrl = replacedRedirectUrl.substring(0, e.getIndex());
                                logger.info("URL {} is invalid, truncating to {}", (Object)replacedRedirectUrl, (Object)checkedRedirectUrl);
                                break block11;
                            }
                            logger.info("URL {} is invalid, replacing it with /", (Object)replacedRedirectUrl);
                            checkedRedirectUrl = "/";
                        }
                    } else {
                        tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
                        throw new LoginHandlerException("Authenticating user " + principal.getName() + " failed, check if the user exists and has permission to access Jira.", (SAMLAuthenticationTracker)tracker);
                    }
                }
                logger.debug("Redirecting to {}", (Object)checkedRedirectUrl);
                resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
                resp.sendRedirect(checkedRedirectUrl);
                tracker.setStatus(SAMLAuthenticationTracker.Status.LOGGED_IN);
            }
            catch (AuthenticatorHookException e) {
                tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
                String message = e.getMessage();
                if (message == null) {
                    message = e.getCause().getClass().getName() + ": " + e.getCause().getMessage();
                }
                throw new LoginHandlerException("Authenticating user " + principal.getName() + " failed: " + message, (Throwable)e, (SAMLAuthenticationTracker)tracker);
            }
        }
    }

    public boolean isServiceDeskLogin(String fullRedirectUrl) {
        return fullRedirectUrl.contains("/servicedesk/customer");
    }
}

