/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket.userauth;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import com.resolution.atlasplugins.samlsso.userauth.AbstractSamlUserMigrator;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
public class BitbucketSamlUserMigrator
extends AbstractSamlUserMigrator {
    private final SecurityService securityService;
    private final UserService userService;

    @Autowired
    public BitbucketSamlUserMigrator(AtlasUserAdapter atlasUserAdapter, @BitbucketImport SecurityService securityService, @BitbucketImport UserService userService) {
        super(atlasUserAdapter);
        this.securityService = securityService;
        this.userService = userService;
    }

    @Override
    public boolean isLegacySamlUser(@Nonnull String userid) {
        String SAMLSSOGROUPNAME = "createdBySAMLSingleSignOn";
        return (Boolean)this.securityService.withPermission(Permission.SYS_ADMIN, "check user group").call((Operation)((UncheckedOperation)() -> this.userService.isUserInGroup(userid, SAMLSSOGROUPNAME)));
    }
}

