/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.commons.task.api.Task;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.impl.AoSyncStatus;
import de.resolution.usersync.impl.AoSyncStatusMessage;
import de.resolution.usersync.impl.AoSyncUserResult;
import de.resolution.usersync.impl.ClusterNodeInformation;
import de.resolution.usersync.impl.SyncStatusAoProxy;
import de.resolution.usersync.impl.legacy.AoAtlasUserResult;
import de.resolution.usersync.impl.legacy.LegacyAoSyncStatus;
import de.resolution.usersync.impl.legacy.LegacyAoSyncStatusMessage;
import de.resolution.usersync.util.UserSyncPluginProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named(value="syncStatusRepository")
@ExportAsService
public class SyncStatusRepositoryImpl
implements SyncStatusRepository,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SyncStatusRepositoryImpl.class);
    private static final int DUMMY_CONNECTOR_ID = 0;
    public static final String SYNC_STATUS_ID = "SYNC_STATUS_ID";
    private final ActiveObjects ao;
    private final ClusterNodeInformation clusterInformation;
    private final EventPublisher eventPublisher;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final String WHERE_CONN_UID = "CONN_UID = ?";
    private static final int MAX_AMOUNT_IDS_TO_DELETE = 500;

    @Inject
    public SyncStatusRepositoryImpl(@ComponentImport ActiveObjects ao, @ComponentImport EventPublisher eventPublisher, ClusterNodeInformation clusterInformation) {
        this.ao = ao;
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
        this.clusterInformation = clusterInformation;
    }

    @EventListener
    public void checkForSyncStatusToBeMarkedDead(PluginEnabledEvent pluginEnabledEvent) {
        if (Objects.equals(UserSyncPluginProperties.get("pluginkey"), pluginEnabledEvent.getPlugin().getKey())) {
            this.eventPublisher.unregister((Object)this);
            if (this.initialized.compareAndSet(false, true)) {
                logger.debug("Checking for SyncStatus to be marked DEAD");
                this.markSyncsAsDeadIfNeeded();
            } else {
                logger.warn("Already initialized, this method should have been called only once");
            }
        }
    }

    @Override
    public void markSyncsAsDeadIfNeeded() {
        Set<String> allNodeIds = this.clusterInformation.getAllNodeIds();
        for (SyncStatus syncStatus : this.getRunningOrNew()) {
            if (!syncStatus.getClusterNode().equals(this.clusterInformation.getNodeId()) && allNodeIds.contains(syncStatus.getClusterNode())) continue;
            syncStatus.setStatus(Task.Status.DEAD);
            logger.warn("SyncStatus {} from connector {} was marked as RUNNING or NEW  on this node {} on startup, setting status to DEAD", new Object[]{syncStatus.getId(), syncStatus.getConnectorUID(), syncStatus.getClusterNode()});
        }
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
        logger.debug("Cancelling running or new SyncStatus");
        for (SyncStatus syncStatus : this.getRunningOrNew()) {
            if (!syncStatus.getClusterNode().equals(this.clusterInformation.getNodeId())) continue;
            syncStatus.setStatus(Task.Status.CANCELLING);
            logger.warn("Cancelling SyncStatus {} from connector {} on this node {}", new Object[]{syncStatus.getId(), syncStatus.getConnectorUID(), syncStatus.getClusterNode()});
        }
    }

    @Override
    public SyncStatusAoProxy create(String connectorUID) {
        return this.create(connectorUID, this.clusterInformation.getNodeId());
    }

    @Override
    public SyncStatusAoProxy create(String connectorUID, @Nonnull String nodeId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new SyncStatus for connector {}", (Object)StringUtil.sanitize((String)connectorUID));
        }
        return (SyncStatusAoProxy)this.ao.executeInTransaction(() -> {
            long now = new Date().getTime();
            AoSyncStatus aoSyncStatus = (AoSyncStatus)this.ao.create(AoSyncStatus.class, new DBParam[]{new DBParam("STATUS", (Object)Task.Status.NEW.toString()), new DBParam("CONN_UID", (Object)connectorUID), new DBParam("CONNECTOR_ID", (Object)0), new DBParam("CREATED_TIME", (Object)now), new DBParam("LAST_MODIFIED_TIME", (Object)now), new DBParam("CLUSTER_NODE", (Object)nodeId), new DBParam("RESULT", (Object)SyncStatus.Result.PENDING.toString())});
            return new SyncStatusAoProxy(this.ao, aoSyncStatus.getID());
        });
    }

    @Override
    public Optional<SyncStatusAoProxy> get(int id) {
        AoSyncStatus syncStatus = (AoSyncStatus)this.ao.executeInTransaction(() -> (AoSyncStatus)this.ao.get(AoSyncStatus.class, (Object)id));
        if (syncStatus == null) {
            return Optional.empty();
        }
        return Optional.of(new SyncStatusAoProxy(this.ao, syncStatus.getID()));
    }

    @Override
    @Nullable
    public SyncStatusAoProxy getLast(String connectorUID) {
        AoSyncStatus[] statusArray = (AoSyncStatus[])this.ao.executeInTransaction(() -> (AoSyncStatus[])this.ao.find(AoSyncStatus.class, Query.select().where(WHERE_CONN_UID, new Object[]{connectorUID}).order("ID DESC").limit(1)));
        if (statusArray.length < 1) {
            return null;
        }
        return new SyncStatusAoProxy(this.ao, statusArray[0].getID());
    }

    @Override
    public List<SyncStatusAoProxy> getAll() {
        return (List)this.ao.executeInTransaction(() -> Arrays.stream((AoSyncStatus[])this.ao.find(AoSyncStatus.class)).map(aoSyncStatus -> new SyncStatusAoProxy(this.ao, aoSyncStatus.getID())).collect(Collectors.toList()));
    }

    @Override
    public List<SyncStatusAoProxy> getAllForConnector(String connectorUID, int offset, int count) {
        int effectiveCount = count < 0 ? Integer.MAX_VALUE : count;
        return (List)this.ao.executeInTransaction(() -> Arrays.stream((AoSyncStatus[])this.ao.find(AoSyncStatus.class, Query.select().where(WHERE_CONN_UID, new Object[]{connectorUID}).limit(effectiveCount).offset(offset).order("ID DESC"))).map(aoSyncStatus -> new SyncStatusAoProxy(this.ao, aoSyncStatus.getID())).collect(Collectors.toList()));
    }

    @Override
    public int countForConnector(String connectorUID) {
        return (Integer)this.ao.executeInTransaction(() -> this.ao.count(AoSyncStatus.class, Query.select().where(WHERE_CONN_UID, new Object[]{connectorUID})));
    }

    @Override
    public List<SyncStatus> getRunningOrNew() {
        return (List)this.ao.executeInTransaction(() -> {
            AoSyncStatus[] withRunningStatus = (AoSyncStatus[])this.ao.find(AoSyncStatus.class, " STATUS = 'RUNNING' OR STATUS = 'CANCELLING' OR STATUS = 'NEW' ", new Object[0]);
            return Arrays.stream(withRunningStatus).map(aoStatus -> new SyncStatusAoProxy(this.ao, aoStatus.getID())).collect(Collectors.toList());
        });
    }

    @Override
    public boolean isRunning(String connectorUID) {
        return (Boolean)this.ao.executeInTransaction(() -> {
            AoSyncStatus[] runningStatus = (AoSyncStatus[])this.ao.find(AoSyncStatus.class, "CONN_UID = ? AND ( STATUS = 'RUNNING' OR STATUS = 'CANCELLING' ) ", new Object[]{connectorUID});
            return runningStatus.length != 0;
        });
    }

    @Override
    public boolean delete(int id) {
        return (Boolean)this.ao.executeInTransaction(() -> {
            AoSyncStatus status = (AoSyncStatus)this.ao.get(AoSyncStatus.class, (Object)id);
            if (status != null) {
                String resultFilePath = status.getResultFilePath();
                if (resultFilePath != null) {
                    Path path = Paths.get(resultFilePath, new String[0]);
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        logger.warn("Deleting result-file {} for status {} failed", new Object[]{path, id, e});
                    }
                }
                this.delete(status);
                return true;
            }
            return false;
        });
    }

    @Override
    public int generateDummyEntriesForStatusRepoAndOtherTables(int howManyEntries, @Nonnull String connectorUid) {
        int i;
        ArrayList<AoSyncStatus> aoSyncStati = new ArrayList<AoSyncStatus>();
        for (int i2 = 0; i2 < howManyEntries; ++i2) {
            AoSyncStatus syncStatus = (AoSyncStatus)this.ao.executeInTransaction(() -> {
                long now = new Date().getTime();
                return (AoSyncStatus)this.ao.create(AoSyncStatus.class, new DBParam[]{new DBParam("STATUS", (Object)Task.Status.DONE.toString()), new DBParam("CONN_UID", (Object)connectorUid), new DBParam("CONNECTOR_ID", (Object)1234), new DBParam("CREATED_TIME", (Object)now), new DBParam("LAST_MODIFIED_TIME", (Object)now), new DBParam("CLUSTER_NODE", (Object)this.clusterInformation.getNodeId()), new DBParam("RESULT", (Object)SyncStatus.Result.SUCCESS.toString())});
            });
            aoSyncStati.add(syncStatus);
        }
        for (AoSyncStatus syncStatus : aoSyncStati) {
            i = 0;
            while (i < 5) {
                int finalI = i++;
                this.ao.executeInTransaction(() -> {
                    AoSyncStatusMessage msg = (AoSyncStatusMessage)this.ao.create(AoSyncStatusMessage.class, new DBParam[]{new DBParam("MESSAGE", (Object)("dummy " + finalI))});
                    msg.setAoSyncStatus(syncStatus);
                    msg.save();
                    syncStatus.setLastModifiedTime(new Date().getTime());
                    syncStatus.save();
                    return null;
                });
            }
        }
        for (AoSyncStatus syncStatus : aoSyncStati) {
            for (i = 0; i < 5; ++i) {
                this.ao.executeInTransaction(() -> {
                    this.ao.create(AoSyncUserResult.class, new DBParam[]{new DBParam("OPERATION", (Object)"ADDED"), new DBParam("RESULT_JSON", (Object)"{}"), new DBParam("SUCCESS", (Object)true), new DBParam(SYNC_STATUS_ID, (Object)syncStatus.getID())});
                    return null;
                });
            }
        }
        return aoSyncStati.size();
    }

    @Override
    public int cleanup(long olderThanInSeconds) {
        return (Integer)this.ao.executeInTransaction(() -> {
            long olderThan = new Date().getTime() - olderThanInSeconds * 1000L;
            AoSyncStatus[] statusToDelete = (AoSyncStatus[])this.ao.find(AoSyncStatus.class, "LAST_MODIFIED_TIME < ? AND (STATUS = 'DONE' OR STATUS = 'DEAD' OR STATUS = 'CANCELLED' ) ", new Object[]{olderThan});
            if (statusToDelete.length == 0) {
                return 0;
            }
            List<Integer> foreignKeysToDelete = Arrays.stream(statusToDelete).map(AoSyncStatus::getID).collect(Collectors.toList());
            return this.cleanupTablesInChunks(foreignKeysToDelete);
        });
    }

    private int cleanupTablesInChunks(@Nonnull List<Integer> foreignKeysToDelete) {
        int count = 0;
        for (int i = 0; i < foreignKeysToDelete.size(); i += 500) {
            int end = Math.min(i + 500, foreignKeysToDelete.size());
            List<Integer> toDelete = foreignKeysToDelete.subList(i, end);
            count += this.cleanupTablesInRightOrder(toDelete);
        }
        return count;
    }

    private int cleanupTablesInRightOrder(@Nonnull List<Integer> idsToDelete) {
        this.ao.deleteWithSQL(AoSyncStatusMessage.class, SyncStatusRepositoryImpl.buildWhereClauseForForeignKeys("AO_SYNC_STATUS_ID", idsToDelete), idsToDelete.toArray());
        this.ao.deleteWithSQL(AoSyncUserResult.class, SyncStatusRepositoryImpl.buildWhereClauseForForeignKeys(SYNC_STATUS_ID, idsToDelete), idsToDelete.toArray());
        return this.ao.deleteWithSQL(AoSyncStatus.class, SyncStatusRepositoryImpl.buildWhereClauseForForeignKeys("ID", idsToDelete), idsToDelete.toArray());
    }

    @Nonnull
    private static String buildWhereClauseForForeignKeys(@Nonnull String tableName, @Nonnull List<Integer> foreignKeysToDelete) {
        String whereClause = "";
        if (foreignKeysToDelete.size() == 1) {
            whereClause = "= ?";
        } else {
            String questionMarks = "(" + foreignKeysToDelete.stream().map(f -> "?").collect(Collectors.joining(",")) + ")";
            whereClause = "in " + questionMarks;
        }
        return tableName + " " + whereClause;
    }

    @Override
    public int cleanup(String connectorUID, int resultsToKeep) {
        return (Integer)this.ao.executeInTransaction(() -> {
            AoSyncStatus[] statusForConnector = (AoSyncStatus[])this.ao.find(AoSyncStatus.class, Query.select().where(WHERE_CONN_UID, new Object[]{connectorUID}).order("ID ASC"));
            if (statusForConnector.length > resultsToKeep) {
                int toBeDeleted = statusForConnector.length - resultsToKeep;
                logger.debug("Deleting {} old results for Connector {}", (Object)toBeDeleted, (Object)connectorUID);
                List<Integer> foreignKeysToDelete = Arrays.stream(statusForConnector).map(AoSyncStatus::getID).collect(Collectors.toList()).subList(0, toBeDeleted);
                return this.cleanupTablesInChunks(foreignKeysToDelete);
            }
            logger.debug("No old results to delete for Connector {}", (Object)connectorUID);
            return 0;
        });
    }

    private void delete(AoSyncStatus aoSyncStatus) {
        this.ao.executeInTransaction(() -> {
            for (AoSyncStatusMessage msg : aoSyncStatus.getAoSyncStatusMessages()) {
                this.ao.delete(new RawEntity[]{msg});
            }
            this.ao.deleteWithSQL(AoSyncUserResult.class, "SYNC_STATUS_ID = ?", new Object[]{aoSyncStatus.getID()});
            this.ao.delete(new RawEntity[]{aoSyncStatus});
            return null;
        });
    }

    @Override
    public int cleanupLegacy(long olderThanInSeconds) {
        return (Integer)this.ao.executeInTransaction(() -> {
            long olderThan = new Date().getTime() - olderThanInSeconds * 1000L;
            LegacyAoSyncStatus[] statusToDelete = (LegacyAoSyncStatus[])this.ao.find(LegacyAoSyncStatus.class, "LAST_MODIFIED_TIME < ? AND (STATUS = 'DONE' OR STATUS = 'DEAD' OR STATUS = 'CANCELLED' ) ", new Object[]{olderThan});
            int count = 0;
            for (LegacyAoSyncStatus status : statusToDelete) {
                this.deleteLegacy(status);
                ++count;
            }
            return count;
        });
    }

    private void deleteLegacy(LegacyAoSyncStatus legacyAoSyncStatus) {
        this.ao.executeInTransaction(() -> {
            for (LegacyAoSyncStatusMessage msg : legacyAoSyncStatus.getAoSyncStatusMessages()) {
                this.ao.delete(new RawEntity[]{msg});
            }
            this.ao.deleteWithSQL(AoAtlasUserResult.class, "SYNC_STATUS_ID = ?", new Object[]{legacyAoSyncStatus.getID()});
            this.ao.delete(new RawEntity[]{legacyAoSyncStatus});
            return null;
        });
    }

    @Override
    public int countSyncUserResults() {
        return (Integer)this.ao.executeInTransaction(() -> this.ao.count(AoSyncUserResult.class));
    }

    @Override
    public int countLegacySyncStatus() {
        return (Integer)this.ao.executeInTransaction(() -> this.ao.count(LegacyAoSyncStatus.class));
    }
}

