/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.excel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import de.resolution.atlasuser.api.CancelHandle;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.api.user.SearchFilter;
import de.resolution.atlasuser.api.user.SortBy;
import de.resolution.atlasuser.api.user.UserSearchResult;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.task.api.Task;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.builtin.excel.ExcelExporterConnectorConfiguration;
import de.resolution.usersync.spi.AbstractConnector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public class ExcelExporterConnector
extends AbstractConnector<ExcelExporterConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(ExcelExporterConnector.class);
    private final File sharedHome;

    public ExcelExporterConnector(ExcelExporterConnectorConfiguration configuration, ConnectorService connectorService, AtlasUserAdapter atlasUserAdapter, boolean newConnector, long lastUpdated, File sharedHome) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/empty.json");
        this.sharedHome = sharedHome;
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
    }

    @Override
    public void sync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatus syncStatus) {
        UserSearchResult searchResult;
        syncStatus.setStatus(Task.Status.RUNNING);
        syncStatus.setSyncStatusResult(SyncStatus.Result.PENDING);
        AtlasUserAdapter atlasUserAdapter = syncFunction.getAtlasUserAdapter();
        SearchFilter searchFilter = SearchFilter.builder().directoryId(((ExcelExporterConnectorConfiguration)this.configuration).getDirectoryId()).build();
        SyncStatusFacade syncStatusFacade = syncStatus.facade();
        syncStatus.setStatusMessage("Loading users...");
        try {
            searchResult = atlasUserAdapter.search(searchFilter, SortBy.name(), (CancelHandle)syncStatus);
        }
        catch (Exception e) {
            syncStatusFacade.fail("Reading users from directory failed", e, logger);
            return;
        }
        if (searchResult.size() == 0) {
            syncStatusFacade.fail("No users found, directory is empty", logger);
            return;
        }
        if (searchResult.isCancelled()) {
            syncStatus.addMessage("Cancelled while fetching users");
            syncStatus.setStatusMessage("");
            syncStatus.setStatus(Task.Status.CANCELLED);
            return;
        }
        LinkedList<AtlasUser> userList = new LinkedList<AtlasUser>();
        HashMap<String, Integer> valueCountMap = new HashMap<String, Integer>();
        syncStatus.setStatusMessage("Iterating users...");
        for (Optional currentUser : searchResult) {
            syncStatusFacade.checkCancel();
            if (currentUser.isPresent()) {
                userList.add((AtlasUser)currentUser.get());
                ExcelExporterConnector.updateValueCountMap((AtlasUser)currentUser.get(), valueCountMap);
                continue;
            }
            syncStatus.addMessage("A user was skipped during Excel export. Please restart the export to create a complete dataset. Please contact our support if this is a permanent issue.");
        }
        LinkedHashMap<String, Integer> indexMap = ExcelExporterConnector.createIndexMap(valueCountMap);
        syncStatusFacade.checkCancel();
        try (SXSSFWorkbook workbook = new SXSSFWorkbook();){
            String sheetName = WorkbookUtil.createSafeSheetName((String)("Dir " + ((ExcelExporterConnectorConfiguration)this.configuration).getDirectoryId()));
            Sheet sheet = workbook.createSheet(sheetName);
            int headerRowIndex = 0;
            Row headerRow = sheet.createRow(headerRowIndex);
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            CellStyle headerStyle = workbook.createCellStyle();
            headerStyle.setFont(headerFont);
            headerStyle.setRotation((short)60);
            for (Map.Entry<String, Integer> entry : indexMap.entrySet()) {
                syncStatusFacade.checkCancel();
                String key = entry.getKey();
                int index = entry.getValue();
                int cellCount = (Integer)valueCountMap.get(entry.getKey());
                Cell cell = headerRow.createCell(index);
                cell.setCellValue(key);
                cell.setCellStyle(headerStyle);
                if (cellCount <= 1) continue;
                sheet.addMergedRegion(new CellRangeAddress(headerRowIndex, headerRowIndex, index, index + cellCount - 1));
            }
            int rowIndex = headerRowIndex + 1;
            for (AtlasUser currentUser : userList) {
                Row row = sheet.createRow(rowIndex);
                for (Map.Entry<String, Integer> indexMapEntry : indexMap.entrySet()) {
                    syncStatusFacade.checkCancel();
                    Set values = currentUser.getAttributeValues(indexMapEntry.getKey());
                    int valueIndex = 0;
                    for (String value : values) {
                        int colIndex = indexMapEntry.getValue() + valueIndex;
                        Cell cell = row.createCell(colIndex);
                        cell.setCellValue(value);
                        ++valueIndex;
                    }
                }
                ++rowIndex;
                syncStatus.add(AtlasUserResult.builder((AtlasUserReference)currentUser.getReference()).initialUser(currentUser).operation(AtlasUserResult.Operation.NOT_MODIFIED).build());
            }
            File file = new File(this.sharedHome, "userexport_" + this.getUniqueId() + "_" + syncStatus.getId() + ".xlsx");
            syncStatus.addMessage("Writing workbook to " + file.getAbsolutePath());
            try (FileOutputStream os = new FileOutputStream(file);){
                workbook.write((OutputStream)os);
            }
            syncStatus.setResultFilePath(file.getAbsolutePath());
            syncStatus.setStatusMessage("");
            syncStatus.setSyncStatusResult(SyncStatus.Result.SUCCESS);
            syncStatus.setStatus(Task.Status.DONE);
        }
        catch (Exception e) {
            syncStatusFacade.fail(e, logger);
        }
    }

    public static void updateValueCountMap(AtlasUser currentUser, @Nonnull Map<String, Integer> valueCountMap) {
        for (String key : currentUser.getAttributeKeys()) {
            Integer countInMap = valueCountMap.get(key);
            int countInUser = currentUser.getAttributeValues(key).size();
            if (countInMap != null && countInUser <= countInMap) continue;
            valueCountMap.put(key, countInUser);
        }
    }

    public static LinkedHashMap<String, Integer> createIndexMap(Map<String, Integer> valueCountMap) {
        LinkedHashMap<String, Integer> indexMap = new LinkedHashMap<String, Integer>();
        HashMap<String, Integer> mutableValueCountMap = new HashMap<String, Integer>(valueCountMap);
        int nextIndex = 0;
        nextIndex = ExcelExporterConnector.insertOneIfNotPresentAndReturnNextIndex("ATTR_NAME", mutableValueCountMap, indexMap, nextIndex);
        nextIndex = ExcelExporterConnector.insertOneIfNotPresentAndReturnNextIndex("ATTR_FULLNAME", mutableValueCountMap, indexMap, nextIndex);
        nextIndex = ExcelExporterConnector.insertOneIfNotPresentAndReturnNextIndex("ATTR_EMAIL", mutableValueCountMap, indexMap, nextIndex);
        nextIndex = ExcelExporterConnector.insertOneIfNotPresentAndReturnNextIndex("ATTR_ACTIVE", mutableValueCountMap, indexMap, nextIndex);
        nextIndex = ExcelExporterConnector.insertOneIfNotPresentAndReturnNextIndex("ATTR_GROUPS", mutableValueCountMap, indexMap, nextIndex);
        nextIndex = ExcelExporterConnector.insertOneIfNotPresentAndReturnNextIndex("ATTR_USER_KEY", mutableValueCountMap, indexMap, nextIndex);
        for (Map.Entry entry : mutableValueCountMap.entrySet()) {
            indexMap.put((String)entry.getKey(), nextIndex);
            nextIndex += ((Integer)entry.getValue()).intValue();
        }
        return indexMap;
    }

    private static int insertOneIfNotPresentAndReturnNextIndex(String attributeName, Map<String, Integer> valueCountMap, LinkedHashMap<String, Integer> indexMap, int currentIndex) {
        int nextIndexToReturn;
        indexMap.put(attributeName, currentIndex);
        if (valueCountMap.containsKey(attributeName) && valueCountMap.get(attributeName) > 0) {
            int valueCount = valueCountMap.get(attributeName);
            nextIndexToReturn = currentIndex + valueCount;
            logger.debug("Attribute {} is there with value {}, index is now {} ", new Object[]{attributeName, valueCount, currentIndex});
        } else {
            nextIndexToReturn = currentIndex + 1;
        }
        valueCountMap.remove(attributeName);
        return nextIndexToReturn;
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        return FindUserResult.failed("findUser is not implemented");
    }

    @Override
    @Nonnull
    public Class<ExcelExporterConnectorConfiguration> getConfigurationClass() {
        return ExcelExporterConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Export users from Excel";
    }

    @Override
    public List<String> getConnectorAttributes() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return false;
    }

    @Override
    public boolean isAllowCustomAttributeMapping() {
        return false;
    }

    @Override
    public boolean isAllowSelectingFindByAttribute() {
        return false;
    }

    @Override
    public boolean isSelectableGroupAttribute() {
        return false;
    }

    @Override
    public boolean isSelectableDirectory() {
        return true;
    }

    @Override
    public boolean isIncludeAllDirectories() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isAllowGroupConfiguration() {
        return false;
    }

    @Override
    public boolean isCanSyncSingleUser() {
        return false;
    }

    @Override
    public boolean isCleanupConfigurable() {
        return false;
    }

    @Override
    public boolean isCanBeScheduled() {
        return true;
    }

    @Override
    public boolean isCanHaveRequiredGroups() {
        return false;
    }

    @Override
    public boolean isHasProvisioningSettings() {
        return false;
    }

    @Override
    public boolean isAllowCreatingNewDirectory() {
        return false;
    }
}

