/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.disableInactive;

import de.resolution.atlasuser.api.AtlasUserStatusObject;
import de.resolution.atlasuser.api.exception.InvalidAtlasUserStateException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserFunction;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.api.cleanup.UserCleanup;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupInactiveUsersFunction
extends UserCleanup
implements AtlasUserFunction {
    private static final Logger logger = LoggerFactory.getLogger(CleanupInactiveUsersFunction.class);
    private static final String ATTRIBUTE_LAST_AUTHENTICATION_TIMESTAMP = "lastAuthenticationTimestamp";
    private final long maxDurationSinceLastLogin;
    private final SyncStatus syncStatus;
    private final boolean cleanupUsersWithoutTimestamp;

    public CleanupInactiveUsersFunction(@Nonnull String maxDurationSinceLastLoginAsDaysOrSeconds, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull SyncStatus syncStatus, boolean cleanupUsersWithoutTimestamp, CleanupBehaviour behaviour, boolean removeAllGroupAssignmentsOnCleanup) {
        super(behaviour, atlasUserAdapter, null, removeAllGroupAssignmentsOnCleanup);
        if (maxDurationSinceLastLoginAsDaysOrSeconds.endsWith("S")) {
            this.maxDurationSinceLastLogin = Long.parseLong(maxDurationSinceLastLoginAsDaysOrSeconds.substring(0, maxDurationSinceLastLoginAsDaysOrSeconds.length() - 1)) * 1000L;
            logger.debug("{} seconds is {} milliseconds", (Object)maxDurationSinceLastLoginAsDaysOrSeconds, (Object)this.maxDurationSinceLastLogin);
        } else {
            this.maxDurationSinceLastLogin = Long.parseLong(maxDurationSinceLastLoginAsDaysOrSeconds) * 24L * 60L * 60L * 1000L;
            logger.debug("{} days is {} milliseconds", (Object)maxDurationSinceLastLoginAsDaysOrSeconds, (Object)this.maxDurationSinceLastLogin);
        }
        this.syncStatus = syncStatus;
        this.cleanupUsersWithoutTimestamp = cleanupUsersWithoutTimestamp;
    }

    public Optional<AtlasUserResult> apply(AtlasUser atlasUser, AtlasUserStatusObject atlasUserStatusObject) {
        String usedAttribute;
        String lastAuthenticatedString;
        if (this.userIsAlreadyCleanedUp(atlasUser)) {
            AtlasUserResult atlasUserResult = AtlasUserResult.builder((AtlasUserReference)atlasUser.getReference()).inputUser(atlasUser).operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
            atlasUserStatusObject.add(atlasUserResult);
            return Optional.of(atlasUserResult);
        }
        if (Boolean.parseBoolean(atlasUser.get("ATTR_IS_SYSADMIN").orElse("false")) || Boolean.parseBoolean(atlasUser.get("ATTR_IS_ADMIN").orElse("false"))) {
            this.syncStatus.addMessage("Skipping admin or sysadmin <" + atlasUser.getName() + ">");
            AtlasUserResult atlasUserResult = AtlasUserResult.builder((AtlasUserReference)atlasUser.getReference()).inputUser(atlasUser).operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
            atlasUserStatusObject.add(atlasUserResult);
            return Optional.of(atlasUserResult);
        }
        long now = new Date().getTime();
        Optional loginLastLoginMillisOptional = atlasUser.get("login.lastLoginMillis");
        Optional lastAuthenticatedOptional = atlasUser.get("lastAuthenticated");
        Optional lastAuthenticationTimestampOptional = atlasUser.get(ATTRIBUTE_LAST_AUTHENTICATION_TIMESTAMP);
        Optional lastAuthConfluenceOptional = atlasUser.get("ATTR_CONFLUENCE_LAST_AUTHENTICATED");
        if (loginLastLoginMillisOptional.isPresent()) {
            lastAuthenticatedString = (String)loginLastLoginMillisOptional.get();
            usedAttribute = "login.lastLoginMillis";
        } else if (lastAuthConfluenceOptional.isPresent()) {
            lastAuthenticatedString = (String)lastAuthConfluenceOptional.get();
            usedAttribute = "ATTR_CONFLUENCE_LAST_AUTHENTICATED";
        } else if (lastAuthenticatedOptional.isPresent()) {
            lastAuthenticatedString = (String)lastAuthenticatedOptional.get();
            usedAttribute = "lastAuthenticated";
        } else if (lastAuthenticationTimestampOptional.isPresent()) {
            lastAuthenticatedString = (String)lastAuthenticationTimestampOptional.get();
            usedAttribute = ATTRIBUTE_LAST_AUTHENTICATION_TIMESTAMP;
        } else {
            usedAttribute = null;
            lastAuthenticatedString = "0";
        }
        long lastAuthenticatedMillis = Long.parseLong(lastAuthenticatedString);
        if (lastAuthenticatedMillis == 0L && !this.cleanupUsersWithoutTimestamp) {
            this.syncStatus.addMessage("User <" + atlasUser.getName() + "> has no lastAuthenticated timestamp and cleanup users without timestamp is disabled. Therefore the user will not be cleaned up.");
            AtlasUserResult atlasUserResult = AtlasUserResult.builder((AtlasUserReference)atlasUser.getReference()).initialUser(atlasUser).operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
            atlasUserStatusObject.add(atlasUserResult);
            return Optional.of(atlasUserResult);
        }
        long duration = now - lastAuthenticatedMillis;
        if (logger.isDebugEnabled()) {
            if (usedAttribute == null) {
                logger.debug("User {} has no last login attribute.", (Object)atlasUser.getName());
            } else {
                logger.debug("User {} has attribute {}={}. Time since last authenticated: {}", new Object[]{atlasUser.getName(), usedAttribute, lastAuthenticatedString, Duration.ofMillis(duration)});
            }
        }
        if (duration > this.maxDurationSinceLastLogin) {
            logger.debug("Duration since last login for user {} is {}, disabling as this is longer than {}", new Object[]{atlasUser.getName(), duration, this.maxDurationSinceLastLogin});
            try {
                AtlasUserResult atlasUserResult = super.cleanupUser(atlasUser);
                atlasUserStatusObject.add(atlasUserResult);
                return Optional.of(atlasUserResult);
            }
            catch (InvalidAtlasUserStateException e) {
                AtlasUserResult atlasUserResult = AtlasUserResult.builder((AtlasUserReference)atlasUser.getReference()).errorType(AtlasUserResult.ErrorType.VALIDATION_FAILED).errorString(e.getMessage()).build();
                atlasUserStatusObject.add(atlasUserResult);
                return Optional.of(atlasUserResult);
            }
        }
        logger.debug("Duration since last login for user {} is {}, NOT disabling as this is shorter than {}", new Object[]{atlasUser.getName(), duration, this.maxDurationSinceLastLogin});
        AtlasUserResult atlasUserResult = AtlasUserResult.builder((AtlasUserReference)atlasUser.getReference()).initialUser(atlasUser).operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
        atlasUserStatusObject.add(atlasUserResult);
        return Optional.of(atlasUserResult);
    }
}

