/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.samlwrapper.api.SAMLWrapper;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/replaycache")
@Component
public class ReplayCacheRestResource {
    private final SAMLWrapper samlWrapper;
    private final PrivilegeChecker privilegeChecker;

    @Autowired
    public ReplayCacheRestResource(SAMLWrapper samlWrapper, PrivilegeChecker privilegeChecker) {
        this.samlWrapper = samlWrapper;
        this.privilegeChecker = privilegeChecker;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getIds(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok((Object)Utils.asJson(this.samlWrapper.getResponseIdStore().getIds())).cacheControl(Utils.ccNoCache).build();
    }
}

