/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.oidcandoauth.oidc;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.servlet.ErrorResponse;
import com.resolution.samlwrapper.api.SAMLWrapper;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.HTTPWrapper;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.Elvis;
import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/readOidcMetadata")
@Component
public class ReadOidcMetadataRestResource {
    private final PrivilegeChecker privilegeChecker;
    private final HTTPWrapper httpWrapper = new HTTPWrapper();

    @Autowired
    public ReadOidcMetadataRestResource(SAMLWrapper samlWrapper, PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    public Response readMetadataFromURL(String fetchingInfoString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, IOException {
        this.privilegeChecker.checkSysAdmin(request);
        Map postBody = JSONUtil.deserializeMap((String)fetchingInfoString);
        if (postBody.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("No body in request to backend"))).cacheControl(Utils.ccNoCache).build();
        }
        if (!postBody.containsKey("wellKnownUrl")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("No wellknownUrl in request to backend"))).cacheControl(Utils.ccNoCache).build();
        }
        String wellKnownUrl = (String)postBody.get("wellKnownUrl");
        ResponseWrapper result = this.httpWrapper.get(wellKnownUrl);
        if (!result.isSuccess()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("Could not fetch metadata from url"))).cacheControl(Utils.ccNoCache).build();
        }
        MapStructuredData res = result.getParsedJson().asMap();
        StructuredData userInfo = res.get((Object)"userinfo_endpoint");
        res.put((Object)"userinfo_endpoint", Collections.singletonList(userInfo));
        return Response.ok().entity((Object)Utils.asJson(Elvis.ifNull((Object)res, (Object)StructuredData.create()))).cacheControl(Utils.ccNoCache).build();
    }
}

