/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.idpselection;

import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIdpSelector {
    private static final Logger logger = LoggerFactory.getLogger(DefaultIdpSelector.class);
    private final RunningConfiguration pluginConfiguration;

    @Autowired
    public DefaultIdpSelector(RunningConfiguration runningConfiguration) {
        this.pluginConfiguration = runningConfiguration;
    }

    public int getDefaultIdPId() {
        int minWeight = Integer.MAX_VALUE;
        int idpId = 1;
        for (CommonRunningIdpConfiguration cfg : this.pluginConfiguration.getRunningIdPConfigurations()) {
            if (cfg.getWeight() >= minWeight) continue;
            minWeight = cfg.getWeight();
            idpId = cfg.getId();
        }
        logger.debug("Default idp is {} with weight {}", (Object)idpId, (Object)minWeight);
        return idpId;
    }
}

