/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.azure;

import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.usersync.api.SyncStatusFacade;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AzureUserResult {
    private static final Logger logger = LoggerFactory.getLogger(AzureUserResult.class);
    protected static final String VALUE = "value";
    protected static final String ODATA_TYPE_ESCAPED = "\"@odata.type\"";
    protected static final String ODATA_NEXTLINK_ESCAPED = "\"@odata.nextLink\"";
    @Nullable
    private final String nextPageUrl;
    @Nonnull
    private List<StructuredData> users = Collections.emptyList();

    AzureUserResult(@Nonnull ResponseWrapper responseWrapper, @Nonnull Set<String> seenUserIdentifiers, @Nonnull SyncStatusFacade syncStatusFacade) {
        StructuredData body = responseWrapper.getParsedJson();
        this.nextPageUrl = body.findString(ODATA_NEXTLINK_ESCAPED);
        StructuredData value = body.find(VALUE);
        if (value != null && value.isList()) {
            this.users = this.parseUsers((List<StructuredData>)value.asList(), seenUserIdentifiers, syncStatusFacade);
        }
    }

    @Nonnull
    private List<StructuredData> parseUsers(List<StructuredData> usersList, @Nonnull Set<String> seenUserIdentifiers, @Nonnull SyncStatusFacade syncStatusFacade) {
        return usersList.stream().filter(user -> this.shouldProcessUser((StructuredData)user, seenUserIdentifiers, syncStatusFacade)).collect(Collectors.toList());
    }

    private boolean shouldProcessUser(@Nonnull StructuredData user, @Nonnull Set<String> seenUserIdentifiers, @Nonnull SyncStatusFacade syncStatusFacade) {
        String id = user.findString("id");
        StructuredData type = user.findOrEmpty(ODATA_TYPE_ESCAPED);
        if (id == null) {
            syncStatusFacade.failPartially("id is null, that's unexpected here.", logger);
            return false;
        }
        if (seenUserIdentifiers.contains(id)) {
            logger.debug("Skipping already synced user {}", (Object)id);
            return false;
        }
        if (!type.isEmpty() && !Objects.equals("#microsoft.graph.user", type.asString())) {
            if (logger.isTraceEnabled()) {
                logger.trace("Object with id {} is of type {}, but #microsoft.graph.user was expected.", (Object)id, (Object)type.asString());
            }
            return false;
        }
        return true;
    }

    @Nonnull
    List<StructuredData> getUsers() {
        return this.users;
    }

    @Nonnull
    List<String> getUserIds() {
        return this.users.stream().map(user -> user.findString("id")).collect(Collectors.toList());
    }

    @Nullable
    String getNextPageUrl() {
        return this.nextPageUrl;
    }
}

