/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.XMLLoader;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationLoadException;
import com.resolution.atlasplugins.samlsso.configuration.JsonConfigurationLoader;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.SupportInfoLoader;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V7SupportInfo;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/json")
public class JsonImportExportRestResource {
    private final RunningConfiguration pluginConfiguration;
    private final ConfigurationDefaultSetter configurationDefaultSetter;
    private final SupportInfoLoader supportInfoLoader = new SupportInfoLoader();
    private final JsonConfigurationLoader jsonConfigurationLoader;
    private final PrivilegeChecker privilegeChecker;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JsonImportExportRestResource.class);

    @Autowired
    public JsonImportExportRestResource(RunningConfiguration pluginConfiguration, ConfigurationDefaultSetter configurationDefaultSetter, JsonConfigurationLoader jsonConfigurationLoader, PrivilegeChecker privilegeChecker) {
        this.pluginConfiguration = pluginConfiguration;
        this.configurationDefaultSetter = configurationDefaultSetter;
        this.jsonConfigurationLoader = jsonConfigurationLoader;
        this.privilegeChecker = privilegeChecker;
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        this.privilegeChecker.checkSysAdmin(request);
        ConfigurationData configData = this.configurationDefaultSetter.clearSamlDefaults(this.pluginConfiguration.getConfigurationData());
        return Response.ok((Object)Utils.asJson(configData)).header("Content-Disposition", (Object)"attachment; filename=samlSingleSignOn.json").cacheControl(Utils.ccNoCache).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response importConfiguration(String importConfigDTOString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, IOException {
        ConfigurationData loadedConfigurationData;
        block12: {
            this.privilegeChecker.checkSysAdmin(request);
            ImportConfigDTO importConfigDTO = (ImportConfigDTO)this.objectMapper.readValue(importConfigDTOString, ImportConfigDTO.class);
            String dataString = importConfigDTO.data;
            if (dataString == null || dataString.trim().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Utils.createMessageForJson("data is null or empty")).build();
            }
            if (dataString.trim().startsWith("<")) {
                logger.debug("Content starts with <, this seems to be XML");
                try {
                    SupportInfoLoader.SupportInfoVersion supportInfoVersion = XMLLoader.load(dataString, SupportInfoLoader.SupportInfoVersion.class);
                    if (supportInfoVersion == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Utils.createMessageForJson("Support info version is not set")).cacheControl(Utils.ccNoCache).build();
                    }
                    if (supportInfoVersion.configurationData == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Utils.createMessageForJson("Config to import looks broken. Did you may try to import something which is not a config or supportInfo?")).cacheControl(Utils.ccNoCache).build();
                    }
                    if (supportInfoVersion.getConfigurationVersion() > 14) {
                        String errorMsg = "Invalid configuration version " + supportInfoVersion.getConfigurationVersion() + ", cannot load from a version higher than " + 14;
                        logger.error(errorMsg);
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg).cacheControl(Utils.ccNoCache).build();
                    }
                    V7SupportInfo supportInfo = this.supportInfoLoader.load(new ByteArrayInputStream(dataString.getBytes()), supportInfoVersion.getConfigurationVersion());
                    if (supportInfo.configurationData == null || supportInfo.ssoPluginInfo == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Utils.createMessageForJson("Parsing data failed")).cacheControl(Utils.ccNoCache).build();
                    }
                    String v7ConfigAsJson = new ObjectMapper().writer().writeValueAsString((Object)supportInfo.configurationData);
                    try {
                        loadedConfigurationData = this.jsonConfigurationLoader.load(v7ConfigAsJson, this.pluginConfiguration.getHostProduct());
                        break block12;
                    }
                    catch (ConfigurationLoadException e) {
                        return this.responseFromException(e);
                    }
                }
                catch (XMLLoader.XMLLoadFailedException e) {
                    logger.warn("Reading configuration from upload failed", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Utils.createMessageForJson("Unmarshalling SupportInfo-object failed: " + e.getMessage())).cacheControl(Utils.ccNoCache).build();
                }
            }
            logger.debug("Assuming JSON-input");
            try {
                loadedConfigurationData = this.jsonConfigurationLoader.load(dataString, this.pluginConfiguration.getHostProduct());
            }
            catch (ConfigurationLoadException e) {
                return this.responseFromException(e);
            }
        }
        this.configurationDefaultSetter.addSamlDefaults(loadedConfigurationData, false);
        this.pluginConfiguration.createNewCertificate(loadedConfigurationData, false);
        return Response.ok((Object)Utils.asJson(loadedConfigurationData)).cacheControl(Utils.ccNoCache).cacheControl(Utils.ccNoCache).build();
    }

    private Response responseFromException(Exception e) {
        logger.warn("Exception during import", (Throwable)e);
        return Response.serverError().entity(Utils.createMessageForJson("Unmarshalling SupportInfo-object failed: " + e.getMessage())).build();
    }

    public static class ImportConfigDTO {
        private final String data;

        @JsonCreator
        public ImportConfigDTO(@JsonProperty(value="data") String data) {
            this.data = data;
        }

        public String getData() {
            return this.data;
        }
    }
}

