/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira.userauth;

import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.jira.JiraSamlSsoService;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHook;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHookBasedLogoutHandler;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;

@JiraComponent
@Primary
public class JiraLogoutHander
extends AuthenticatorHookBasedLogoutHandler {
    private static final Logger logger = LoggerFactory.getLogger(JiraLogoutHander.class);

    @Autowired
    public JiraLogoutHander(JiraSamlSsoService samlssoService, RunningConfiguration pluginConfiguration, AuthenticatorHook authenticatorHook) {
        super(samlssoService, pluginConfiguration, authenticatorHook);
    }

    @Override
    public void doLogout(HttpServletRequest req, HttpServletResponse resp, AuthenticationTracker tracker) {
        logger.debug("Clearing Service Desk cookie");
        Cookie clearCookieUnencoded = new Cookie("JiraSDSamlssoLogin", "");
        clearCookieUnencoded.setMaxAge(0);
        clearCookieUnencoded.setPath("/");
        clearCookieUnencoded.setHttpOnly(true);
        clearCookieUnencoded.setSecure(this.samlSsoService.isHttps());
        resp.addCookie(clearCookieUnencoded);
        Cookie clearCookie = new Cookie("JiraSDSamlssoLoginV2", "");
        clearCookie.setMaxAge(0);
        clearCookie.setPath("/");
        clearCookie.setHttpOnly(true);
        clearCookie.setSecure(this.samlSsoService.isHttps());
        resp.addCookie(clearCookie);
        super.doLogout(req, resp, tracker);
    }
}

