/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.resolution.atlasplugins.samlsso.JiraServiceDeskDetector;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
public class ConfluenceConfigurationDefaultSetter
extends ConfigurationDefaultSetter {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceConfigurationDefaultSetter.class);
    private final Settings confluenceSettings;

    @Autowired
    public ConfluenceConfigurationDefaultSetter(@ConfluenceImport SettingsManager settingsManager, @ConfluenceImport ApplicationProperties applicationProperties, DirectoryAdapter directoryAdapter, JiraServiceDeskDetector jiraServiceDeskDetector) {
        super(applicationProperties, directoryAdapter, jiraServiceDeskDetector);
        this.confluenceSettings = settingsManager.getGlobalSettings();
    }

    @Override
    public void addSamlDefaults(ConfigurationData configurationData, boolean newConfig) {
        if (newConfig && configurationData.nonSsoDestinations.isEmpty()) {
            logger.info("Setting nonSsoDestinations to default {}", (Object)"/plugins/servlet/applinks.*,.*applicationlinks.*");
            configurationData.nonSsoDestinations = Utils.splitString("/plugins/servlet/applinks.*,.*applicationlinks.*");
        }
        if (newConfig && configurationData.enforceSsoDestinations.isEmpty()) {
            logger.info("Setting enforceSsoDestinations to default {}", (Object)"/");
            configurationData.enforceSsoDestinations = Utils.splitString("/");
        }
        super.addSamlDefaults(configurationData, newConfig);
    }

    @Override
    public void addSamlDefaults(SamlIdpConfigurationData idpConfig) {
        super.addSamlDefaults(idpConfig);
    }

    @Override
    @NotNull
    public List<String> getDefaultEnforceSsoUrls() {
        return Utils.splitString("/");
    }

    @Override
    @NotNull
    public List<String> getDefaultNonSsoUrls() {
        return Utils.splitString("/plugins/servlet/applinks.*,.*applicationlinks.*");
    }
}

