/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.validation;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.validation.CommonIdpConfigurationDataValidator;
import com.resolution.atlasplugins.samlsso.userauth.DirectoryAdapter;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.SAMLWrapperIdpConfiguration;
import de.resolution.commons.cert.api.CertUtil;
import de.resolution.commons.cert.api.CertificateCheckResult;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfigValidator;
import de.resolution.retransform.config.Source;
import de.resolution.usersync.api.UserSyncService;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={SamlIdpConfigurationDataValidator.class})
public class SamlIdpConfigurationDataValidator
extends CommonIdpConfigurationDataValidator<SamlIdpConfigurationData> {
    private final CertUtil certUtil;
    private static final Logger logger = LoggerFactory.getLogger(SamlIdpConfigurationDataValidator.class);
    private static final String MSG_CERT_INVALID = "Certificate invalid: ";
    private static final String MSG_CERT_EXPIRED = "This Certificate is expired.";
    private static final String MSG_ENTITY_ID_REQUIRED = "EntityID/Issuer must be set";
    private static final String MSG_SSO_POST_URL_NOT_SET = "IdP POST URL is not set for SingleSignOn";
    private static final String MSG_SSO_POST_URL_WRONG = "IdP POST URL does not start with http(s) for SingleSignOn";
    private static final String MSG_SSO_REDIRECT_URL_NOT_SET = "IdP Redirect URL is not set for SingleSignOn";
    private static final String MSG_SSO_REDIRECT_URL_WRONG = "IdP Redirect URL does not start with http(s) for SingleSignOn";
    private static final String MSG_SSO_BINDING_WRONG = "Binding type for SingleSignOn not selected";
    private static final String MSG_SLO_POST_URL_NOT_SET = "IdP POST URL is not set for Single Logout";
    private static final String MSG_SLO_POST_URL_WRONG = "IdP POST URL does not start with http(s) for Single Logout";
    private static final String MSG_SLO_REDIRECT_URL_NOT_SET = "IdP Redirect URL is not set for Single Logout";
    private static final String MSG_SLO_REDIRECT_URL_WRONG = "IdP Redirect URL does not start with http(s) for Single Logout";
    private static final String MSG_SLO_BINDING_WRONG = "Binding type for SingleSignOn not selected for Single Logout";
    private static final String MSG_DUMMY_VALUE = "This value must be replaced with the real value";
    private static final String MSG_NOT_EMPTY = "This field must not be emtpy";
    private final DirectoryAdapter directoryAdapter;

    @Autowired
    public SamlIdpConfigurationDataValidator(SAMLWrapper samlWrapper, DirectoryAdapter directoryAdapter, UserSyncService userSyncService, AttributeTransformationConfigValidator attributeTransformationConfigValidator) {
        super(attributeTransformationConfigValidator, userSyncService);
        this.certUtil = samlWrapper.getCertUtil();
        this.directoryAdapter = directoryAdapter;
    }

    @Override
    public ValidationResult validate(SamlIdpConfigurationData idpConfig, ConfigurationData configurationData) {
        ValidationResult result = super.validate(idpConfig, configurationData);
        if (idpConfig.idpId == null || idpConfig.idpId.trim().isEmpty()) {
            result.add("idpId", MSG_ENTITY_ID_REQUIRED, null);
        }
        if (idpConfig.idpId != null && idpConfig.idpId.startsWith("setEntityIdHere")) {
            result.add("idpId", null, MSG_DUMMY_VALUE);
        }
        String postBindingURL = idpConfig.postBindingURL;
        String redirectBindingURL = idpConfig.redirectBindingURL;
        switch (idpConfig.selectedLoginBinding) {
            case POST: {
                if (postBindingURL == null || postBindingURL.isEmpty()) {
                    logger.debug(MSG_SSO_POST_URL_NOT_SET);
                    result.add("postBindingURL", MSG_SSO_POST_URL_NOT_SET, null);
                }
                if (postBindingURL != null && !postBindingURL.startsWith("http")) {
                    logger.debug(MSG_SSO_POST_URL_WRONG);
                    result.add("postBindingURL", MSG_SSO_POST_URL_WRONG, null);
                }
                if (postBindingURL == null || !postBindingURL.startsWith("https://setPOSTBindingURLhere")) break;
                result.add("postBindingURL", null, MSG_DUMMY_VALUE);
                break;
            }
            case REDIRECT: {
                if (redirectBindingURL == null || redirectBindingURL.isEmpty()) {
                    logger.debug(MSG_SSO_REDIRECT_URL_NOT_SET);
                    result.add("redirectBindingURL", MSG_SSO_REDIRECT_URL_NOT_SET, null);
                }
                if (redirectBindingURL == null || redirectBindingURL.startsWith("http")) break;
                logger.debug(MSG_SSO_REDIRECT_URL_WRONG);
                result.add("redirectBindingURL", MSG_SSO_REDIRECT_URL_WRONG, null);
                break;
            }
            default: {
                logger.debug(MSG_SSO_BINDING_WRONG);
                result.addError(MSG_SSO_BINDING_WRONG);
            }
        }
        if (idpConfig.enableAdditionalAuthentication && idpConfig.selectedLoginBinding == SAMLWrapper.Binding.POST && !configurationData.setSameSiteAttributeOnSessionCookie) {
            result.add("enableAdditionalAuthentication", null, "Additional authentication requires that the session-cookie is set with SameSite=NONE. One way to achieve this is to enable it under Advanced.");
        }
        if (idpConfig.signRequests && !configurationData.includeSigningCertificateInMetadata) {
            result.add("signRequests", null, "The SAML metadata does not include the request signing certificate of the SAML Single Sign On addon. <br/>It may be necessary to enable <i>Include Signing Certificate in Metadadata</i> in the Service Provider-tab and reload the metadata on the Identity Provider.");
        }
        if (idpConfig.selectedLogoutBinding != SamlIdpConfigurationData.LogoutBinding.DISABLE) {
            String postBindingLogoutURL = idpConfig.postBindingLogoutURL;
            String postBindingLogoutResponseURL = idpConfig.postBindingLogoutResponseURL;
            String redirectBindingLogoutURL = idpConfig.redirectBindingLogoutURL;
            String redirectBindingLogoutResponseURL = idpConfig.redirectBindingLogoutResponseURL;
            switch (idpConfig.selectedLogoutBinding) {
                case POST: {
                    if (postBindingLogoutURL == null || postBindingLogoutURL.isEmpty()) {
                        result.add("postBindingLogoutURL", MSG_SLO_POST_URL_NOT_SET, null);
                        logger.debug(MSG_SLO_POST_URL_NOT_SET);
                    }
                    if (postBindingLogoutURL != null && !postBindingLogoutURL.startsWith("http")) {
                        logger.debug(MSG_SLO_POST_URL_WRONG);
                        result.add("postBindingLogoutURL", MSG_SLO_POST_URL_WRONG, null);
                    }
                    if (postBindingLogoutResponseURL == null || postBindingLogoutResponseURL.startsWith("http")) break;
                    logger.debug(MSG_SLO_POST_URL_WRONG);
                    result.add("postBindingLogoutResponseURL", MSG_SLO_POST_URL_WRONG);
                    break;
                }
                case REDIRECT: {
                    if (redirectBindingLogoutURL == null || redirectBindingLogoutURL.isEmpty()) {
                        result.add("redirectBindingLogoutURL", MSG_SLO_REDIRECT_URL_NOT_SET, null);
                        logger.debug(MSG_SLO_REDIRECT_URL_NOT_SET);
                    }
                    if (redirectBindingLogoutURL != null && !redirectBindingLogoutURL.startsWith("http")) {
                        logger.debug(MSG_SLO_REDIRECT_URL_WRONG);
                        result.add(redirectBindingLogoutURL, MSG_SLO_REDIRECT_URL_WRONG, null);
                    }
                    if (redirectBindingLogoutResponseURL == null || redirectBindingLogoutResponseURL.startsWith("http")) break;
                    logger.debug(MSG_SLO_REDIRECT_URL_WRONG);
                    result.add("redirectBindingLogoutResponseURL", MSG_SLO_REDIRECT_URL_WRONG, null);
                    break;
                }
                default: {
                    logger.debug(MSG_SLO_BINDING_WRONG);
                    result.addError(MSG_SLO_BINDING_WRONG);
                }
            }
            if (configurationData.overrideLoggedOutUrlMethod == RunningConfiguration.OverrideLoggedOutUrlMethod.NO_REDIRECTION) {
                result.add("selectedLogoutBinding", null, "Single Logout will not work until logout redirection is enabled in the Redirection tab.");
            }
        }
        ValidationResult certResult = ValidationResult.create();
        result.add("certificates", certResult);
        if (idpConfig.certificates.isEmpty()) {
            certResult.addWarning("Since you have not configured a certificate for this IdP yet, SAML responses will not be validated! Leaving this empty in your production environment is a major security vulnerability!");
        }
        for (int i = 0; i < idpConfig.certificates.size(); ++i) {
            String certPem = idpConfig.certificates.get(i);
            if (certPem == null || certPem.length() == 0) {
                certResult.add(i, MSG_NOT_EMPTY, null);
                continue;
            }
            CertificateCheckResult certCheck = this.certUtil.check(certPem, null);
            if (!certCheck.isCertSet()) {
                logger.error("Reading certificate {} for IdP with entityID \"{}\" failed. This is very likely an invalid certificate. Please reimport the IdP metadata and save the config with the fixed certificate. SAML Single Sign On won't work until this is fixed.", (Object)idpConfig.id, (Object)idpConfig.idpId);
                certResult.add(i, "Reading certificate failed. This is very likely an invalid certificate. Please reimport the IdP metadata and save the config with the fixed certificate.", null);
                continue;
            }
            if (certCheck.isCertSet() && !certCheck.isValid()) {
                certResult.add(i, MSG_CERT_INVALID + certCheck.getMessage(), null);
                continue;
            }
            if (!certCheck.isCertSet() || !certCheck.isExpired()) continue;
            certResult.add(i, null, MSG_CERT_EXPIRED);
        }
        if (idpConfig.relayStateParameterName == null || idpConfig.relayStateParameterName.isEmpty()) {
            result.add("relayStateParameterName", MSG_NOT_EMPTY, null);
        }
        if (idpConfig.userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.SAML && idpConfig.enableUserCreation && idpConfig.attributeTransformations != null) {
            ArrayList<String> validationErrors = new ArrayList<String>();
            if (idpConfig.attributeTransformations.stream().filter(t -> t.getSource().getType() == Source.Type.UNMAPPED).anyMatch(t -> "ATTR_NAME".equals(t.getTarget().getName()))) {
                validationErrors.add("Username");
            }
            if (idpConfig.attributeTransformations.stream().filter(t -> t.getSource().getType() == Source.Type.UNMAPPED).anyMatch(t -> "ATTR_EMAIL".equals(t.getTarget().getName()))) {
                validationErrors.add("Email Address");
            }
            if (idpConfig.attributeTransformations.stream().filter(t -> t.getSource().getType() == Source.Type.UNMAPPED).anyMatch(t -> "ATTR_FULLNAME".equals(t.getTarget().getName()))) {
                validationErrors.add("Full Name");
            }
            if (!validationErrors.isEmpty()) {
                result.add("enableUserCreation", "Attributes: " + String.join((CharSequence)", ", validationErrors) + " must be mapped (above) to allow to create users!");
            }
        }
        if (idpConfig.userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.SAML && idpConfig.addNonExistingGroups && idpConfig.attributeTransformations != null && idpConfig.attributeTransformations.stream().filter(t -> t.getSource().getType() == Source.Type.UNMAPPED).anyMatch(t -> "ATTR_GROUPS".equals(t.getTarget().getName()))) {
            result.add("addNonExistingGroups", null, "Attribute Groups must be mapped (above) to create groups.");
        }
        if (idpConfig.userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.SAML && idpConfig.removeFromGroups && idpConfig.attributeTransformations != null && idpConfig.groupsForNewUsers.isEmpty() && idpConfig.attributeTransformations.stream().filter(t -> t.getSource().getType() == Source.Type.UNMAPPED).anyMatch(t -> "ATTR_GROUPS".equals(t.getTarget().getName()))) {
            result.add("removeFromGroups", null, "Attribute Groups must be mapped (above) to determine if group memberships need to be changed.");
        }
        if (idpConfig.userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.SAML || idpConfig.userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.CONNECTORANDSAML) {
            if (idpConfig.enableUserCreation && !this.directoryAdapter.directoryExists(idpConfig.directoryIdForNewUsers)) {
                result.add("directoryIdForNewUsers", null, "Directory must exist");
            }
            ValidationResult groupsForNewUsersResult = ValidationResult.create();
            result.add("groupsForNewUsers", groupsForNewUsersResult);
            for (int i = 0; i < idpConfig.groupsForNewUsers.size(); ++i) {
                String groupForNewUsers = idpConfig.groupsForNewUsers.get(i);
                if (groupForNewUsers == null) {
                    groupsForNewUsersResult.add(i, "There is something wrong with your configuration. Did you alter it by hand?", null);
                    continue;
                }
                String groupTrimmed = groupForNewUsers.trim();
                if (this.directoryAdapter.groupExists(groupTrimmed)) continue;
                groupsForNewUsersResult.add(i, null, "Group " + groupTrimmed + " does not exist");
            }
            ValidationResult groupsForNewSdCustomersResult = ValidationResult.create();
            result.add("groupsForNewSdCustomers", groupsForNewSdCustomersResult);
            for (int i = 0; i < idpConfig.groupsForNewSdCustomers.size(); ++i) {
                String groupForNewSdCustomers = idpConfig.groupsForNewSdCustomers.get(i);
                if (groupForNewSdCustomers == null) {
                    groupsForNewSdCustomersResult.add(i, "There is something wrong with your configuration. Did you alter it by hand?", null);
                    continue;
                }
                String groupTrimmed = groupForNewSdCustomers.trim();
                if (this.directoryAdapter.groupExists(groupTrimmed)) continue;
                groupsForNewSdCustomersResult.add(i, null, "Group " + groupTrimmed + " does not exist");
            }
            ValidationResult organizationResult = ValidationResult.create();
            result.add("organizationsForNewSdCustomers", organizationResult);
            for (int i = 0; i < idpConfig.organizationsForNewSdCustomers.size(); ++i) {
                String orgForNewSdCustomers = idpConfig.organizationsForNewSdCustomers.get(i);
                if (orgForNewSdCustomers != null && !orgForNewSdCustomers.trim().isEmpty()) continue;
                organizationResult.add(i, "Organization must not be empty", null);
            }
        }
        if (idpConfig.authnContextClassRefs.stream().anyMatch(str -> str == null || str.trim().isEmpty())) {
            result.add("authnContextClassRefs", "Values must not be empty", null);
        }
        if (idpConfig.authnContextDeclRefs.stream().anyMatch(str -> str == null || str.trim().isEmpty())) {
            result.add("authnContextDeclRefs", "Values must not be empty", null);
        }
        if (!idpConfig.authnContextClassRefs.isEmpty() && idpConfig.authnContextComparisonType == SAMLWrapperIdpConfiguration.AuthnContextComparisonType.none) {
            result.add("authnContextComparisonType", "Must not be none if AuthnContextClassRefs are set", null);
        }
        if (idpConfig.authnContextClassRefs.isEmpty() && idpConfig.authnContextComparisonType != SAMLWrapperIdpConfiguration.AuthnContextComparisonType.none) {
            result.add("authnContextComparisonType", "Must be none if no AuthnContextClassRefs are set", null);
        }
        if (idpConfig.useUrlFromRequest) {
            result.add("useUrlFromRequest", null, "");
        }
        if (idpConfig.findByAttributeName != null && idpConfig.attributeTransformations != null && !idpConfig.findByAttributeName.equals("addNewEntryToAttributeMapping")) {
            if (idpConfig.attributeTransformations.stream().filter(t -> t.getSource().getType() == Source.Type.UNMAPPED).anyMatch(t -> idpConfig.findByAttributeName.equals(t.getTarget().getName()))) {
                result.add("findByAttributeName", "You have to configure an attribute mapping for the selected attribute");
            }
            if (idpConfig.findByAttributeName.isEmpty()) {
                result.add("findByAttributeName", "You just deleted the attribute to find a user. You must choose a new one before saving the configuration.");
            }
            if (idpConfig.attributeTransformations.stream().noneMatch(mapping -> mapping.getTarget().getName() != null && mapping.getTarget().getName().equals(idpConfig.findByAttributeName))) {
                result.add("findByAttributeName", "You set a findByAttribute which does not exist in attribute transformations. ");
            }
            if (idpConfig.findByAttributeName.equals("ATTR_FULLNAME") || idpConfig.findByAttributeName.equals("ATTR_GROUPS")) {
                result.add("findByAttributeName", "This attribute is not supported to find the user");
            }
        }
        if (!idpConfig.isValidateAudience) {
            result.add("isValidateAudience", null, "Not validating the audience of a SAML response might lower the security of your instance.");
        }
        if (idpConfig.isValidateDestination) {
            result.add("isValidateDestination", null, "If your instance is reachable via more than one base url, the login may fail.");
        }
        return result;
    }
}

