/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.SAMLWrapperConfiguration;
import com.resolution.samlwrapper.api.SAMLWrapperIdpConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude
public class SamlIdpConfigurationData
extends CommonIdpConfigurationData {
    public String requestUrlOverride;
    public String postBindingURL;
    public String postBindingLogoutURL;
    public String postBindingLogoutResponseURL;
    public String redirectBindingURL;
    public String redirectBindingLogoutURL;
    public String redirectBindingLogoutResponseURL;
    public SAMLWrapper.Binding selectedLoginBinding = SAMLWrapper.Binding.POST;
    public LogoutBinding selectedLogoutBinding = LogoutBinding.DISABLE;
    public SAMLWrapper.ProtocolBindingOfResponse protocolBindingOfResponse = SAMLWrapper.ProtocolBindingOfResponse.SAME_AS_REQUEST;
    public SAMLWrapper.NameIdFormat nameIdFormatInRequest = SAMLWrapper.NameIdFormat.NONE;
    public List<String> certificates = new ArrayList<String>();
    public boolean denyMessagesSignedWithExpiredCertificates = true;
    public String relayStateParameterName = "RelayState";
    public String useridAttribute = null;
    public Map<String, String> attributeMapping = new HashMap<String, String>();
    public Long directoryIdForNewUsers = 1L;
    public List<String> groupsForNewUsers = new ArrayList<String>();
    public List<String> groupsForNewSdCustomers = new ArrayList<String>();
    public List<String> organizationsForNewSdCustomers = new ArrayList<String>();
    public boolean removeFromGroups = false;
    public boolean addNonExistingGroups = false;
    public boolean addNonExistingOrganizations = false;
    public boolean updateExisting = false;
    public boolean enableUserCreation = false;
    public boolean enableUserRenaming = false;
    public boolean signRequests = true;
    public String metadataurl;
    public String metadataxml;
    public boolean metadataignorecert;
    public boolean useMetadataxml = false;
    public boolean acceptUnsignedLogoutResponse = true;
    public boolean signLogoutResponse = false;
    public boolean acceptUnsignedLogoutRequest = false;
    public boolean autoReloadMetadata = true;
    public long lastMetadataReload;
    public MetadataReloadStatus metadataReloadStatus = MetadataReloadStatus.NONE;
    public String metadataSignatureCertificate;
    public boolean acceptLogoutRequestWithoutSessionIndex = false;
    public boolean sendLogoutResponseAfterLogoutRequest = true;
    public SAMLWrapperIdpConfiguration.AuthnContextComparisonType authnContextComparisonType = SAMLWrapperIdpConfiguration.AuthnContextComparisonType.none;
    public List<String> authnContextClassRefs = new ArrayList<String>();
    public List<String> authnContextDeclRefs = new ArrayList<String>();
    public List<String> acceptedIssuers = new ArrayList<String>();
    public boolean createdFromMetadata = false;
    public boolean isValidateAudience = true;
    public boolean isValidateDestination = false;
    public SAMLWrapperConfiguration.TrueFalseNone wantAssertionsSigned = SAMLWrapperConfiguration.TrueFalseNone.TRUE;
    public SAMLWrapperConfiguration.TrueFalseNone authnRequestsSigned = SAMLWrapperConfiguration.TrueFalseNone.NONE;
    public boolean includeSigningCertificateInMetadata = true;
    public boolean includeEncryptionCertificateInMetadata = false;
    public boolean includeLogoutUrlInMetadata = false;
    public boolean includeUrlInRelayState = false;
    public boolean forceAuthenticationForAdditionalAuthentication = true;

    public SamlIdpConfigurationData() {
        this.protocolType = ProtocolType.SAML;
    }

    public SamlIdpConfigurationData(SamlIdpConfigurationData other) {
        super(other);
        this.requestUrlOverride = other.requestUrlOverride;
        this.postBindingURL = other.postBindingURL;
        this.postBindingLogoutURL = other.postBindingLogoutURL;
        this.postBindingLogoutResponseURL = other.postBindingLogoutResponseURL;
        this.redirectBindingURL = other.redirectBindingURL;
        this.redirectBindingLogoutURL = other.redirectBindingLogoutURL;
        this.redirectBindingLogoutResponseURL = other.redirectBindingLogoutResponseURL;
        this.selectedLoginBinding = other.selectedLoginBinding;
        this.selectedLogoutBinding = other.selectedLogoutBinding;
        this.protocolBindingOfResponse = other.protocolBindingOfResponse;
        this.nameIdFormatInRequest = other.nameIdFormatInRequest;
        this.useUrlFromRequest = other.useUrlFromRequest;
        this.attributeMapping = new HashMap<String, String>();
        this.attributeMapping.putAll(other.attributeMapping);
        this.certificates.addAll(other.certificates);
        this.denyMessagesSignedWithExpiredCertificates = other.denyMessagesSignedWithExpiredCertificates;
        this.relayStateParameterName = other.relayStateParameterName;
        this.useridAttribute = other.useridAttribute;
        this.acceptUnsignedLogoutResponse = other.acceptUnsignedLogoutResponse;
        this.acceptUnsignedLogoutRequest = other.acceptUnsignedLogoutRequest;
        this.acceptLogoutRequestWithoutSessionIndex = other.acceptLogoutRequestWithoutSessionIndex;
        this.signLogoutResponse = other.signLogoutResponse;
        this.findByAttributeName = other.findByAttributeName;
        this.directoryIdForNewUsers = other.directoryIdForNewUsers;
        this.groupsForNewUsers = other.groupsForNewUsers;
        this.groupsForNewSdCustomers = other.groupsForNewSdCustomers;
        this.organizationsForNewSdCustomers = other.organizationsForNewSdCustomers;
        this.removeFromGroups = other.removeFromGroups;
        this.updateExisting = other.updateExisting;
        this.addNonExistingGroups = other.addNonExistingGroups;
        this.addNonExistingOrganizations = other.addNonExistingOrganizations;
        this.enableUserCreation = other.enableUserCreation;
        this.enableUserRenaming = other.enableUserRenaming;
        this.signRequests = other.signRequests;
        this.metadataurl = other.metadataurl;
        this.metadataxml = other.metadataxml;
        this.metadataignorecert = other.metadataignorecert;
        this.metadataSignatureCertificate = other.metadataSignatureCertificate;
        this.useMetadataxml = other.useMetadataxml;
        this.autoReloadMetadata = other.autoReloadMetadata;
        this.lastMetadataReload = other.lastMetadataReload;
        this.metadataReloadStatus = other.metadataReloadStatus;
        this.createdFromMetadata = other.createdFromMetadata;
        this.sendLogoutResponseAfterLogoutRequest = other.sendLogoutResponseAfterLogoutRequest;
        this.authnContextComparisonType = other.authnContextComparisonType;
        this.authnContextClassRefs.addAll(other.authnContextClassRefs);
        this.authnContextDeclRefs.addAll(other.authnContextDeclRefs);
        this.acceptedIssuers.addAll(other.acceptedIssuers);
        this.isValidateDestination = other.isValidateDestination;
        this.isValidateAudience = other.isValidateAudience;
        this.wantAssertionsSigned = other.wantAssertionsSigned;
        this.authnRequestsSigned = other.authnRequestsSigned;
        this.includeSigningCertificateInMetadata = other.includeSigningCertificateInMetadata;
        this.includeEncryptionCertificateInMetadata = other.includeEncryptionCertificateInMetadata;
        this.includeLogoutUrlInMetadata = other.includeLogoutUrlInMetadata;
        this.includeUrlInRelayState = other.includeUrlInRelayState;
        this.forceAuthenticationForAdditionalAuthentication = other.forceAuthenticationForAdditionalAuthentication;
    }

    @Override
    public SamlIdpConfigurationData migrateToNewerModelVersion() {
        return this;
    }

    public static enum MetadataReloadStatus {
        NONE,
        UPDATED,
        ACTUAL,
        FAILED;

    }

    public static enum LogoutBinding {
        POST,
        REDIRECT,
        DISABLE;

    }
}

