/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.IdPType;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.AttributeTransformationConfigTranslator;
import java.util.Collections;
import javax.annotation.Nullable;

public abstract class CommonRunningIdpConfiguration {
    private final CommonIdpConfigurationData commonIdpConfigurationData;
    private AttributeTransformer userSyncLookupTransformer;
    private AttributeTransformer userLookUpTransformer;
    private AttributeTransformationConfig userLookUpConfig;

    protected CommonRunningIdpConfiguration(CommonIdpConfigurationData commonIdpConfigurationData, @Nullable AtlasUserAdapter atlasUserAdapter) {
        this.commonIdpConfigurationData = commonIdpConfigurationData;
        if (commonIdpConfigurationData.userSyncLookupTransformation != null) {
            this.userSyncLookupTransformer = (AttributeTransformer)new AttributeTransformationConfigTranslator(Collections.singletonList(commonIdpConfigurationData.userSyncLookupTransformation)).withAtlasUserAdapter(atlasUserAdapter).translate().values().iterator().next();
        }
        if (commonIdpConfigurationData.findByAttributeName != null) {
            for (AttributeTransformationConfig attributeTransformationConfig : commonIdpConfigurationData.attributeTransformations) {
                if (!commonIdpConfigurationData.findByAttributeName.equals(attributeTransformationConfig.getTarget().getName())) continue;
                this.userLookUpTransformer = (AttributeTransformer)new AttributeTransformationConfigTranslator(Collections.singletonList(attributeTransformationConfig)).withAtlasUserAdapter(atlasUserAdapter).translate().values().iterator().next();
                this.userLookUpConfig = attributeTransformationConfig;
                break;
            }
        }
    }

    public Integer getId() {
        return this.commonIdpConfigurationData.id;
    }

    public Integer getWeight() {
        return this.commonIdpConfigurationData.weight;
    }

    public String getName() {
        return this.commonIdpConfigurationData.name;
    }

    public String getDescription() {
        return this.commonIdpConfigurationData.description;
    }

    public AttributeTransformer getUserSyncLookupTransformer() {
        return this.userSyncLookupTransformer;
    }

    public String getUserSyncConnector() {
        return this.commonIdpConfigurationData.userSyncConnectorUID;
    }

    public boolean isEnableAdditionalAuthentication() {
        return this.commonIdpConfigurationData.enableAdditionalAuthentication;
    }

    public String getIdpId() {
        return this.commonIdpConfigurationData.idpId;
    }

    public boolean isUseUrlFromRequest() {
        return this.commonIdpConfigurationData.useUrlFromRequest;
    }

    public AttributeTransformer getUserLookUpTransformer() {
        return this.userLookUpTransformer;
    }

    public CommonIdpConfigurationData.UserUpdateMethod getUserUpdateMethod() {
        return this.commonIdpConfigurationData.userUpdateMethod;
    }

    public String getFindByAttributeName() {
        return this.commonIdpConfigurationData.findByAttributeName;
    }

    public boolean isEnableUserReactivation() {
        return this.commonIdpConfigurationData.enableUserReactivation;
    }

    public boolean isAllowChangingActiveStateOnConnectorUpdate() {
        return this.commonIdpConfigurationData.allowChangingActiveStateOnConnectorUpdate;
    }

    public ProtocolType getProtocolType() {
        return this.commonIdpConfigurationData.protocolType;
    }

    public IdPType getIdpType() {
        return this.commonIdpConfigurationData.idpType;
    }

    public AttributeTransformationConfig getUserSyncLookupTransformationConfig() {
        return this.commonIdpConfigurationData.userSyncLookupTransformation;
    }

    public AttributeTransformationConfig getUserLookUpTransformationConfig() {
        return this.userLookUpConfig;
    }

    public boolean shouldDisplayIdpButtonOnLoginPage() {
        return this.commonIdpConfigurationData.shouldDisplayIdpButtonOnLoginPage;
    }

    public String getIdpButtonText() {
        return this.commonIdpConfigurationData.idpButtonText;
    }
}

