/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.DefaultDependencyResolutionResult;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.RepositorySessionDecorator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;

@Component(role=ProjectDependenciesResolver.class)
public class DefaultProjectDependenciesResolver
implements ProjectDependenciesResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repoSystem;
    @Requirement
    private List<RepositorySessionDecorator> decorators;

    @Override
    public DependencyResolutionResult resolve(DependencyResolutionRequest request) throws DependencyResolutionException {
        DependencyNode node;
        DependencyManagement dependencyManagement;
        RequestTrace trace = RequestTrace.newChild(null, request);
        DefaultDependencyResolutionResult result = new DefaultDependencyResolutionResult();
        MavenProject project = request.getMavenProject();
        DependencyFilter filter = request.getResolutionFilter();
        Object session = request.getRepositorySession();
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        if (this.logger.isDebugEnabled() && session.getConfigProperties().get("aether.dependencyManager.verbose") == null) {
            DefaultRepositorySystemSession verbose = new DefaultRepositorySystemSession((RepositorySystemSession)session);
            verbose.setConfigProperty("aether.dependencyManager.verbose", Boolean.TRUE);
            session = verbose;
        }
        for (RepositorySessionDecorator repositorySessionDecorator : this.decorators) {
            RepositorySystemSession repositorySystemSession = repositorySessionDecorator.decorate(project, (RepositorySystemSession)session);
            if (repositorySystemSession == null) continue;
            session = repositorySystemSession;
        }
        CollectRequest collect = new CollectRequest();
        collect.setRootArtifact(RepositoryUtils.toArtifact(project.getArtifact()));
        collect.setRequestContext("project");
        collect.setRepositories(project.getRemoteProjectRepositories());
        if (project.getDependencyArtifacts() == null) {
            for (Dependency dependency : project.getDependencies()) {
                if (StringUtils.isEmpty(dependency.getGroupId()) || StringUtils.isEmpty(dependency.getArtifactId()) || StringUtils.isEmpty(dependency.getVersion())) continue;
                collect.addDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        } else {
            HashMap<String, Dependency> hashMap = new HashMap<String, Dependency>();
            for (Dependency dependency2 : project.getDependencies()) {
                ArtifactType type;
                String classifier = dependency2.getClassifier();
                if (classifier == null && (type = stereotypes.get(dependency2.getType())) != null) {
                    classifier = type.getClassifier();
                }
                String key = ArtifactIdUtils.toVersionlessId(dependency2.getGroupId(), dependency2.getArtifactId(), dependency2.getType(), classifier);
                hashMap.put(key, dependency2);
            }
            Iterator<org.apache.maven.artifact.Artifact> iterator = project.getDependencyArtifacts().iterator();
            while (iterator.hasNext()) {
                org.apache.maven.artifact.Artifact artifact;
                String key = (artifact = iterator.next()).getDependencyConflictId();
                Dependency dependency3 = (Dependency)hashMap.get(key);
                List<Exclusion> exclusions = dependency3 != null ? dependency3.getExclusions() : null;
                org.eclipse.aether.graph.Dependency dep = RepositoryUtils.toDependency(artifact, exclusions);
                if (!"system".equals(dep.getScope()) && dep.getArtifact().getFile() != null) {
                    Artifact art = dep.getArtifact();
                    art = art.setFile(null).setVersion(art.getBaseVersion());
                    dep = dep.setArtifact(art);
                }
                collect.addDependency(dep);
            }
        }
        if ((dependencyManagement = project.getDependencyManagement()) != null) {
            for (Dependency dependency : dependencyManagement.getDependencies()) {
                collect.addManagedDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collect, filter);
        dependencyRequest.setTrace(trace);
        try {
            collect.setTrace(RequestTrace.newChild(trace, dependencyRequest));
            node = this.repoSystem.collectDependencies((RepositorySystemSession)session, collect).getRoot();
            result.setDependencyGraph(node);
        }
        catch (DependencyCollectionException e) {
            result.setDependencyGraph(e.getResult().getRoot());
            result.setCollectionErrors(e.getResult().getExceptions());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project.getId() + ": " + e.getMessage(), e);
        }
        dependencyRequest.setRoot(node);
        if (this.logger.isWarnEnabled()) {
            for (DependencyNode child : node.getChildren()) {
                if (child.getRelocations().isEmpty()) continue;
                this.logger.warn("The artifact " + child.getRelocations().get(0) + " has been relocated to " + child.getDependency().getArtifact());
            }
        }
        if (this.logger.isDebugEnabled()) {
            node.accept(new GraphLogger(project));
        }
        try {
            this.process(result, this.repoSystem.resolveDependencies((RepositorySystemSession)session, dependencyRequest).getArtifactResults());
        }
        catch (org.eclipse.aether.resolution.DependencyResolutionException e) {
            this.process(result, e.getResult().getArtifactResults());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project.getId() + ": " + e.getMessage(), e);
        }
        return result;
    }

    private void process(DefaultDependencyResolutionResult result, Collection<ArtifactResult> results) {
        for (ArtifactResult ar : results) {
            DependencyNode node = ar.getRequest().getDependencyNode();
            if (ar.isResolved()) {
                result.addResolvedDependency(node.getDependency());
                continue;
            }
            result.setResolutionErrors(node.getDependency(), ar.getExceptions());
        }
    }

    class GraphLogger
    implements DependencyVisitor {
        private final MavenProject project;
        private String indent = "";

        GraphLogger(MavenProject project) {
            this.project = project;
        }

        @Override
        public boolean visitEnter(DependencyNode node) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.indent);
            org.eclipse.aether.graph.Dependency dep = node.getDependency();
            if (dep != null) {
                Artifact art = dep.getArtifact();
                buffer.append(art);
                if (StringUtils.isNotEmpty(dep.getScope())) {
                    buffer.append(':').append(dep.getScope());
                }
                if (dep.isOptional()) {
                    buffer.append(" (optional)");
                }
                if ((node.getManagedBits() & 2) == 2) {
                    String premanagedScope = DependencyManagerUtils.getPremanagedScope(node);
                    buffer.append(" (scope managed from ");
                    buffer.append(Objects.toString(premanagedScope, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 1) == 1) {
                    String premanagedVersion = DependencyManagerUtils.getPremanagedVersion(node);
                    buffer.append(" (version managed from ");
                    buffer.append(Objects.toString(premanagedVersion, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 4) == 4) {
                    Boolean premanagedOptional = DependencyManagerUtils.getPremanagedOptional(node);
                    buffer.append(" (optionality managed from ");
                    buffer.append(Objects.toString(premanagedOptional, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 0x10) == 16) {
                    Collection<org.eclipse.aether.graph.Exclusion> premanagedExclusions = DependencyManagerUtils.getPremanagedExclusions(node);
                    buffer.append(" (exclusions managed from ");
                    buffer.append(Objects.toString(premanagedExclusions, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 8) == 8) {
                    Map<String, String> premanagedProperties = DependencyManagerUtils.getPremanagedProperties(node);
                    buffer.append(" (properties managed from ");
                    buffer.append(Objects.toString(premanagedProperties, "default"));
                    buffer.append(')');
                }
            } else {
                buffer.append(this.project.getGroupId());
                buffer.append(':').append(this.project.getArtifactId());
                buffer.append(':').append(this.project.getPackaging());
                buffer.append(':').append(this.project.getVersion());
            }
            DefaultProjectDependenciesResolver.this.logger.debug(buffer.toString());
            this.indent = this.indent + "   ";
            return true;
        }

        @Override
        public boolean visitLeave(DependencyNode node) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }
    }
}

