/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.transfer;

import java.util.Locale;
import org.apache.maven.cli.transfer.AbstractMavenTransferListener;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jMavenTransferListener
extends AbstractTransferListener {
    protected final Logger out;

    public Slf4jMavenTransferListener() {
        this.out = LoggerFactory.getLogger(Slf4jMavenTransferListener.class);
    }

    public Slf4jMavenTransferListener(Logger out) {
        this.out = out;
    }

    @Override
    public void transferInitiated(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "to" : "from";
        TransferResource resource = event.getResource();
        StringBuilder message = new StringBuilder();
        message.append(action).append(' ').append(direction).append(' ').append(resource.getRepositoryId());
        message.append(": ");
        message.append(resource.getRepositoryUrl()).append(resource.getResourceName());
        this.out.info(message.toString());
    }

    @Override
    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.out.warn("{} from {} for {}{}", new Object[]{event.getException().getMessage(), resource.getRepositoryId(), resource.getRepositoryUrl(), resource.getResourceName()});
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "to" : "from";
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        AbstractMavenTransferListener.FileSizeFormat format = new AbstractMavenTransferListener.FileSizeFormat(Locale.ENGLISH);
        StringBuilder message = new StringBuilder();
        message.append(action).append(' ').append(direction).append(' ').append(resource.getRepositoryId());
        message.append(": ");
        message.append(resource.getRepositoryUrl()).append(resource.getResourceName());
        message.append(" (").append(format.format(contentLength));
        long duration = System.currentTimeMillis() - resource.getTransferStartTime();
        if (duration > 0L) {
            double bytesPerSecond = (double)contentLength / ((double)duration / 1000.0);
            message.append(" at ").append(format.format((long)bytesPerSecond)).append("/s");
        }
        message.append(')');
        this.out.info(message.toString());
    }
}

