/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.transfer;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.cli.transfer.AbstractMavenTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

public class ConsoleMavenTransferListener
extends AbstractMavenTransferListener {
    private Map<TransferResource, Long> transfers = Collections.synchronizedMap(new LinkedHashMap());
    private boolean printResourceNames;
    private int lastLength;

    public ConsoleMavenTransferListener(PrintStream out, boolean printResourceNames) {
        super(out);
        this.printResourceNames = printResourceNames;
    }

    @Override
    public synchronized void transferInitiated(TransferEvent event) {
        this.overridePreviousTransfer(event);
        super.transferInitiated(event);
    }

    @Override
    public synchronized void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        this.overridePreviousTransfer(event);
        super.transferCorrupted(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void transferProgressed(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.transfers.put(resource, event.getTransferredBytes());
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("Progress (").append(this.transfers.size()).append("): ");
        Map<TransferResource, Long> map = this.transfers;
        synchronized (map) {
            Iterator<Map.Entry<TransferResource, Long>> entries = this.transfers.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<TransferResource, Long> entry = entries.next();
                long total = entry.getKey().getContentLength();
                Long complete = entry.getValue();
                buffer.append(this.getStatus(entry.getKey().getResourceName(), complete, total));
                if (!entries.hasNext()) continue;
                buffer.append(" | ");
            }
        }
        int pad = this.lastLength - buffer.length();
        this.lastLength = buffer.length();
        this.pad(buffer, pad);
        buffer.append('\r');
        this.out.print(buffer);
        this.out.flush();
    }

    private String getStatus(String resourceName, long complete, long total) {
        AbstractMavenTransferListener.FileSizeFormat format = new AbstractMavenTransferListener.FileSizeFormat(Locale.ENGLISH);
        StringBuilder status = new StringBuilder();
        if (this.printResourceNames) {
            status.append(StringUtils.substringAfterLast((String)resourceName, (String)"/"));
            status.append(" (");
        }
        status.append(format.formatProgress(complete, total));
        if (this.printResourceNames) {
            status.append(")");
        }
        return status.toString();
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
            spaces -= n;
        }
    }

    @Override
    public synchronized void transferSucceeded(TransferEvent event) {
        this.transfers.remove(event.getResource());
        this.overridePreviousTransfer(event);
        super.transferSucceeded(event);
    }

    @Override
    public synchronized void transferFailed(TransferEvent event) {
        this.transfers.remove(event.getResource());
        this.overridePreviousTransfer(event);
        super.transferFailed(event);
    }

    private void overridePreviousTransfer(TransferEvent event) {
        if (this.lastLength > 0) {
            StringBuilder buffer = new StringBuilder(128);
            this.pad(buffer, this.lastLength);
            buffer.append('\r');
            this.out.print(buffer);
            this.out.flush();
            this.lastLength = 0;
        }
    }
}

