/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.event;

import java.util.List;
import java.util.Objects;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEventLogger
extends AbstractExecutionListener {
    private final Logger logger;
    private static final int LINE_LENGTH = 72;
    private static final int MAX_PADDED_BUILD_TIME_DURATION_LENGTH = 9;
    private static final int MAX_PROJECT_NAME_LENGTH = 52;
    private int totalProjects;
    private volatile int currentVisitedProjectCount;

    public ExecutionEventLogger() {
        this.logger = LoggerFactory.getLogger(ExecutionEventLogger.class);
    }

    public ExecutionEventLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
    }

    private static String chars(char c, int count) {
        StringBuilder buffer = new StringBuilder(count);
        for (int i = count; i > 0; --i) {
            buffer.append(c);
        }
        return buffer.toString();
    }

    private void infoLine(char c) {
        this.infoMain(ExecutionEventLogger.chars(c, 72));
    }

    private void infoMain(String msg) {
        this.logger.info(MessageUtils.buffer().strong(msg).toString());
    }

    @Override
    public void projectDiscoveryStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Scanning for projects...");
        }
    }

    @Override
    public void sessionStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getSession().getProjects().size() > 1) {
            this.infoLine('-');
            this.infoMain("Reactor Build Order:");
            this.logger.info("");
            List<MavenProject> projects = event.getSession().getProjects();
            for (MavenProject project : projects) {
                int len = 72 - project.getName().length() - project.getPackaging().length() - 2;
                this.logger.info("{}{}[{}]", new Object[]{project.getName(), ExecutionEventLogger.chars(' ', len > 0 ? len : 1), project.getPackaging()});
            }
            this.totalProjects = projects.size();
        }
    }

    @Override
    public void sessionEnded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            if (event.getSession().getProjects().size() > 1) {
                this.logReactorSummary(event.getSession());
            }
            this.logResult(event.getSession());
            this.logStats(event.getSession());
            this.infoLine('-');
        }
    }

    private boolean isSingleVersionedReactor(MavenSession session) {
        boolean result = true;
        MavenProject topProject = session.getTopLevelProject();
        List<MavenProject> sortedProjects = session.getProjectDependencyGraph().getSortedProjects();
        for (MavenProject mavenProject : sortedProjects) {
            if (topProject.getVersion().equals(mavenProject.getVersion())) continue;
            result = false;
            break;
        }
        return result;
    }

    private void logReactorSummary(MavenSession session) {
        boolean isSingleVersion = this.isSingleVersionedReactor(session);
        this.infoLine('-');
        StringBuilder summary = new StringBuilder("Reactor Summary");
        if (isSingleVersion) {
            summary.append(" for ");
            summary.append(session.getTopLevelProject().getName());
            summary.append(" ");
            summary.append(session.getTopLevelProject().getVersion());
        }
        summary.append(":");
        this.infoMain(summary.toString());
        this.logger.info("");
        MavenExecutionResult result = session.getResult();
        List<MavenProject> projects = session.getProjects();
        for (MavenProject project : projects) {
            int padSize;
            String buildTimeDuration;
            BuildSummary buildSummary;
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(project.getName());
            buffer.append(' ');
            if (!isSingleVersion) {
                buffer.append(project.getVersion());
                buffer.append(' ');
            }
            if (buffer.length() <= 52) {
                while (buffer.length() < 52) {
                    buffer.append('.');
                }
                buffer.append(' ');
            }
            if ((buildSummary = result.getBuildSummary(project)) == null) {
                buffer.append(MessageUtils.buffer().warning("SKIPPED"));
            } else if (buildSummary instanceof BuildSuccess) {
                buffer.append(MessageUtils.buffer().success("SUCCESS"));
                buffer.append(" [");
                buildTimeDuration = CLIReportingUtils.formatDuration(buildSummary.getTime());
                padSize = 9 - buildTimeDuration.length();
                if (padSize > 0) {
                    buffer.append(ExecutionEventLogger.chars(' ', padSize));
                }
                buffer.append(buildTimeDuration);
                buffer.append(']');
            } else if (buildSummary instanceof BuildFailure) {
                buffer.append(MessageUtils.buffer().failure("FAILURE"));
                buffer.append(" [");
                buildTimeDuration = CLIReportingUtils.formatDuration(buildSummary.getTime());
                padSize = 9 - buildTimeDuration.length();
                if (padSize > 0) {
                    buffer.append(ExecutionEventLogger.chars(' ', padSize));
                }
                buffer.append(buildTimeDuration);
                buffer.append(']');
            }
            this.logger.info(buffer.toString());
        }
    }

    private void logResult(MavenSession session) {
        this.infoLine('-');
        MessageBuilder buffer = MessageUtils.buffer();
        if (session.getResult().hasExceptions()) {
            buffer.failure("BUILD FAILURE");
        } else {
            buffer.success("BUILD SUCCESS");
        }
        this.logger.info(buffer.toString());
    }

    private void logStats(MavenSession session) {
        this.infoLine('-');
        long finish = System.currentTimeMillis();
        long time = finish - session.getRequest().getStartTime().getTime();
        String wallClock = session.getRequest().getDegreeOfConcurrency() > 1 ? " (Wall Clock)" : "";
        this.logger.info("Total time:  {}{}", (Object)CLIReportingUtils.formatDuration(time), (Object)wallClock);
        this.logger.info("Finished at: {}", (Object)CLIReportingUtils.formatTimestamp(finish));
    }

    @Override
    public void projectSkipped(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            this.infoLine('-');
            this.infoMain("Skipping " + event.getProject().getName());
            this.logger.info("This project has been banned from the build due to previous failures.");
            this.infoLine('-');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void projectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            MavenProject project = event.getProject();
            this.logger.info("");
            String projectKey = project.getGroupId() + ':' + project.getArtifactId();
            String preHeader = "--< ";
            String postHeader = " >--";
            int headerLen = "--< ".length() + projectKey.length() + " >--".length();
            String prefix = ExecutionEventLogger.chars('-', Math.max(0, (72 - headerLen) / 2)) + "--< ";
            String suffix = " >--" + ExecutionEventLogger.chars('-', Math.max(0, 72 - headerLen - prefix.length() + "--< ".length()));
            this.logger.info(MessageUtils.buffer().strong(prefix).project(projectKey).strong(suffix).toString());
            String building = "Building " + event.getProject().getName() + " " + event.getProject().getVersion();
            if (this.totalProjects <= 1) {
                this.infoMain(building);
            } else {
                int number;
                ExecutionEventLogger executionEventLogger = this;
                synchronized (executionEventLogger) {
                    number = ++this.currentVisitedProjectCount;
                }
                String progress = " [" + number + '/' + this.totalProjects + ']';
                int pad = 72 - building.length() - progress.length();
                this.infoMain(building + (pad > 0 ? ExecutionEventLogger.chars(' ', pad) : "") + progress);
            }
            prefix = ExecutionEventLogger.chars('-', Math.max(0, (72 - project.getPackaging().length() - 4) / 2));
            suffix = ExecutionEventLogger.chars('-', Math.max(0, 72 - project.getPackaging().length() - 4 - prefix.length()));
            this.infoMain(prefix + "[ " + project.getPackaging() + " ]" + suffix);
        }
    }

    @Override
    public void mojoSkipped(ExecutionEvent event) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Goal {} requires online mode for execution but Maven is currently offline, skipping", (Object)event.getMojoExecution().getGoal());
        }
    }

    @Override
    public void mojoStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            MessageBuilder buffer = MessageUtils.buffer().strong("--- ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.strong(" ---");
            this.logger.info(buffer.toString());
        }
    }

    @Override
    public void forkStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            MessageBuilder buffer = MessageUtils.buffer().strong(">>> ");
            this.append(buffer, event.getMojoExecution());
            buffer.strong(" > ");
            this.appendForkInfo(buffer, event.getMojoExecution().getMojoDescriptor());
            this.append(buffer, event.getProject());
            buffer.strong(" >>>");
            this.logger.info(buffer.toString());
        }
    }

    @Override
    public void forkSucceeded(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            MessageBuilder buffer = MessageUtils.buffer().strong("<<< ");
            this.append(buffer, event.getMojoExecution());
            buffer.strong(" < ");
            this.appendForkInfo(buffer, event.getMojoExecution().getMojoDescriptor());
            this.append(buffer, event.getProject());
            buffer.strong(" <<<");
            this.logger.info(buffer.toString());
            this.logger.info("");
        }
    }

    private void append(MessageBuilder buffer, MojoExecution me) {
        buffer.mojo(me.getArtifactId() + ':' + me.getVersion() + ':' + me.getGoal());
        if (me.getExecutionId() != null) {
            buffer.a(Character.valueOf(' ')).strong('(' + me.getExecutionId() + ')');
        }
    }

    private void appendForkInfo(MessageBuilder buffer, MojoDescriptor md) {
        StringBuilder buff = new StringBuilder();
        if (StringUtils.isNotEmpty(md.getExecutePhase())) {
            if (StringUtils.isNotEmpty(md.getExecuteLifecycle())) {
                buff.append('[');
                buff.append(md.getExecuteLifecycle());
                buff.append(']');
            }
            buff.append(md.getExecutePhase());
        } else {
            buff.append(':');
            buff.append(md.getExecuteGoal());
        }
        buffer.strong(buff.toString());
    }

    private void append(MessageBuilder buffer, MavenProject project) {
        buffer.a(" @ ").project(project.getArtifactId());
    }

    @Override
    public void forkedProjectStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled() && event.getMojoExecution().getForkedExecutions().size() > 1) {
            this.logger.info("");
            this.infoLine('>');
            this.infoMain("Forking " + event.getProject().getName() + " " + event.getProject().getVersion());
            this.infoLine('>');
        }
    }
}

