/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.client.model;

import com.google.gson.annotations.SerializedName;
import com.rapid7.ias.client.model.RequiredIdResource;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class ScanConfig {
    @SerializedName(value="id")
    private UUID id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="app")
    private RequiredIdResource app = null;
    @SerializedName(value="attack_template")
    private RequiredIdResource attackTemplate = null;
    @SerializedName(value="errors")
    private List<String> errors = null;

    @ApiModelProperty(value="The ID of the Scan Config")
    public UUID getId() {
        return this.id;
    }

    public ScanConfig name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the Scan Config")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ScanConfig description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the Scan Config")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScanConfig app(RequiredIdResource app) {
        this.app = app;
        return this;
    }

    @ApiModelProperty(required=true, value="The App that the Scan is associated with")
    public RequiredIdResource getApp() {
        return this.app;
    }

    public void setApp(RequiredIdResource app) {
        this.app = app;
    }

    public ScanConfig attackTemplate(RequiredIdResource attackTemplate) {
        this.attackTemplate = attackTemplate;
        return this;
    }

    @ApiModelProperty(required=true, value="The attack template that the Scan Config should use")
    public RequiredIdResource getAttackTemplate() {
        return this.attackTemplate;
    }

    public void setAttackTemplate(RequiredIdResource attackTemplate) {
        this.attackTemplate = attackTemplate;
    }

    public ScanConfig errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public ScanConfig addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="A list of errors that detail any current validation failures")
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanConfig scanConfig = (ScanConfig)o;
        return Objects.equals(this.id, scanConfig.id) && Objects.equals(this.name, scanConfig.name) && Objects.equals(this.description, scanConfig.description) && Objects.equals(this.app, scanConfig.app) && Objects.equals(this.attackTemplate, scanConfig.attackTemplate) && Objects.equals(this.errors, scanConfig.errors);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.app, this.attackTemplate, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScanConfig {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    attackTemplate: ").append(this.toIndentedString(this.attackTemplate)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

