/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.client.api;

import com.google.gson.reflect.TypeToken;
import com.rapid7.ias.client.ApiCallback;
import com.rapid7.ias.client.ApiClient;
import com.rapid7.ias.client.ApiException;
import com.rapid7.ias.client.ApiResponse;
import com.rapid7.ias.client.Configuration;
import com.rapid7.ias.client.Pair;
import com.rapid7.ias.client.ProgressRequestBody;
import com.rapid7.ias.client.ProgressResponseBody;
import com.rapid7.ias.client.model.PageAttackTemplate;
import com.rapid7.ias.client.model.ResourceAttackTemplate;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class AttackTemplatesApi {
    private ApiClient apiClient;

    public AttackTemplatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttackTemplatesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getAttackTemplateCall(UUID attackTemplateId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/attack-templates/{attack-template-id}".replaceAll("\\{attack-template-id\\}", this.apiClient.escapeString(attackTemplateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAttackTemplateValidateBeforeCall(UUID attackTemplateId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (attackTemplateId == null) {
            throw new ApiException("Missing the required parameter 'attackTemplateId' when calling getAttackTemplate(Async)");
        }
        Call call = this.getAttackTemplateCall(attackTemplateId, progressListener, progressRequestListener);
        return call;
    }

    public ResourceAttackTemplate getAttackTemplate(UUID attackTemplateId) throws ApiException {
        ApiResponse<ResourceAttackTemplate> resp = this.getAttackTemplateWithHttpInfo(attackTemplateId);
        return resp.getData();
    }

    public ApiResponse<ResourceAttackTemplate> getAttackTemplateWithHttpInfo(UUID attackTemplateId) throws ApiException {
        Call call = this.getAttackTemplateValidateBeforeCall(attackTemplateId, null, null);
        Type localVarReturnType = new TypeToken<ResourceAttackTemplate>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAttackTemplateAsync(UUID attackTemplateId, final ApiCallback<ResourceAttackTemplate> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAttackTemplateValidateBeforeCall(attackTemplateId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourceAttackTemplate>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAttackTemplatesCall(Integer index, Integer size, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/attack-templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (index != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("index", index));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAttackTemplatesValidateBeforeCall(Integer index, Integer size, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAttackTemplatesCall(index, size, sort, progressListener, progressRequestListener);
        return call;
    }

    public PageAttackTemplate getAttackTemplates(Integer index, Integer size, String sort) throws ApiException {
        ApiResponse<PageAttackTemplate> resp = this.getAttackTemplatesWithHttpInfo(index, size, sort);
        return resp.getData();
    }

    public ApiResponse<PageAttackTemplate> getAttackTemplatesWithHttpInfo(Integer index, Integer size, String sort) throws ApiException {
        Call call = this.getAttackTemplatesValidateBeforeCall(index, size, sort, null, null);
        Type localVarReturnType = new TypeToken<PageAttackTemplate>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAttackTemplatesAsync(Integer index, Integer size, String sort, final ApiCallback<PageAttackTemplate> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAttackTemplatesValidateBeforeCall(index, size, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageAttackTemplate>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

