/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rapid7.ias.client.model.ReadOnlyIdResource;
import com.rapid7.ias.client.model.RootCause;
import com.rapid7.ias.client.model.Variance;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class Vulnerability {
    @SerializedName(value="id")
    private UUID id = null;
    @SerializedName(value="app")
    private ReadOnlyIdResource app = null;
    @SerializedName(value="root_cause")
    private RootCause rootCause = null;
    @SerializedName(value="severity")
    private SeverityEnum severity = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="variances")
    private List<Variance> variances = null;

    @ApiModelProperty(value="The ID of the Vulnerability")
    public UUID getId() {
        return this.id;
    }

    public Vulnerability app(ReadOnlyIdResource app) {
        this.app = app;
        return this;
    }

    @ApiModelProperty(value="The App that the Vulnerability is associated with")
    public ReadOnlyIdResource getApp() {
        return this.app;
    }

    public void setApp(ReadOnlyIdResource app) {
        this.app = app;
    }

    public Vulnerability rootCause(RootCause rootCause) {
        this.rootCause = rootCause;
        return this;
    }

    @ApiModelProperty(value="A descriptor for the location of the Vulnerability")
    public RootCause getRootCause() {
        return this.rootCause;
    }

    public void setRootCause(RootCause rootCause) {
        this.rootCause = rootCause;
    }

    public Vulnerability severity(SeverityEnum severity) {
        this.severity = severity;
        return this;
    }

    @ApiModelProperty(required=true, value="The severity of the Vulnerability")
    public SeverityEnum getSeverity() {
        return this.severity;
    }

    public void setSeverity(SeverityEnum severity) {
        this.severity = severity;
    }

    public Vulnerability status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the Vulnerability")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Vulnerability variances(List<Variance> variances) {
        this.variances = variances;
        return this;
    }

    public Vulnerability addVariancesItem(Variance variancesItem) {
        if (this.variances == null) {
            this.variances = new ArrayList<Variance>();
        }
        this.variances.add(variancesItem);
        return this;
    }

    @ApiModelProperty(value="Evidence found that indicates the presence of a Vulnerability")
    public List<Variance> getVariances() {
        return this.variances;
    }

    public void setVariances(List<Variance> variances) {
        this.variances = variances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vulnerability vulnerability = (Vulnerability)o;
        return Objects.equals(this.id, vulnerability.id) && Objects.equals(this.app, vulnerability.app) && Objects.equals(this.rootCause, vulnerability.rootCause) && Objects.equals((Object)this.severity, (Object)vulnerability.severity) && Objects.equals((Object)this.status, (Object)vulnerability.status) && Objects.equals(this.variances, vulnerability.variances);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.app, this.rootCause, this.severity, this.status, this.variances});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Vulnerability {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    rootCause: ").append(this.toIndentedString(this.rootCause)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    variances: ").append(this.toIndentedString(this.variances)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        UNREVIEWED("UNREVIEWED"),
        FALSE_POSITIVE("FALSE_POSITIVE"),
        VERIFIED("VERIFIED"),
        IGNORED("IGNORED"),
        REMEDIATED("REMEDIATED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            @Override
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SeverityEnum {
        SAFE("SAFE"),
        INFORMATIONAL("INFORMATIONAL"),
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH");

        private String value;

        private SeverityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SeverityEnum fromValue(String text) {
            for (SeverityEnum b : SeverityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SeverityEnum> {
            @Override
            public void write(JsonWriter jsonWriter, SeverityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public SeverityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SeverityEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

