/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.client.model;

import com.google.gson.annotations.SerializedName;
import com.rapid7.ias.client.model.Exchange;
import com.rapid7.ias.client.model.ReadOnlyIdResource;
import com.rapid7.ias.client.model.StringReferenceResource;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Variance {
    @SerializedName(value="original_value")
    private String originalValue = null;
    @SerializedName(value="original_exchange")
    private Exchange originalExchange = null;
    @SerializedName(value="attack")
    private StringReferenceResource attack = null;
    @SerializedName(value="module")
    private ReadOnlyIdResource module = null;
    @SerializedName(value="attack_value")
    private String attackValue = null;
    @SerializedName(value="attack_exchanges")
    private List<Exchange> attackExchanges = null;
    @SerializedName(value="message")
    private String message = null;

    @ApiModelProperty(value="The value of a variable prior to being attacked")
    public String getOriginalValue() {
        return this.originalValue;
    }

    public Variance originalExchange(Exchange originalExchange) {
        this.originalExchange = originalExchange;
        return this;
    }

    @ApiModelProperty(value="The HTTP exchange executed prior to the attack")
    public Exchange getOriginalExchange() {
        return this.originalExchange;
    }

    public void setOriginalExchange(Exchange originalExchange) {
        this.originalExchange = originalExchange;
    }

    public Variance attack(StringReferenceResource attack) {
        this.attack = attack;
        return this;
    }

    @ApiModelProperty(value="The ID of the attack")
    public StringReferenceResource getAttack() {
        return this.attack;
    }

    public void setAttack(StringReferenceResource attack) {
        this.attack = attack;
    }

    public Variance module(ReadOnlyIdResource module) {
        this.module = module;
        return this;
    }

    @ApiModelProperty(value="The ID of the module")
    public ReadOnlyIdResource getModule() {
        return this.module;
    }

    public void setModule(ReadOnlyIdResource module) {
        this.module = module;
    }

    @ApiModelProperty(value="The value of a variable used to attack")
    public String getAttackValue() {
        return this.attackValue;
    }

    public Variance attackExchanges(List<Exchange> attackExchanges) {
        this.attackExchanges = attackExchanges;
        return this;
    }

    public Variance addAttackExchangesItem(Exchange attackExchangesItem) {
        if (this.attackExchanges == null) {
            this.attackExchanges = new ArrayList<Exchange>();
        }
        this.attackExchanges.add(attackExchangesItem);
        return this;
    }

    @ApiModelProperty(value="The HTTP exchange executed as part of the attack")
    public List<Exchange> getAttackExchanges() {
        return this.attackExchanges;
    }

    public void setAttackExchanges(List<Exchange> attackExchanges) {
        this.attackExchanges = attackExchanges;
    }

    @ApiModelProperty(value="A message that may highlight the result of the attack")
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variance variance = (Variance)o;
        return Objects.equals(this.originalValue, variance.originalValue) && Objects.equals(this.originalExchange, variance.originalExchange) && Objects.equals(this.attack, variance.attack) && Objects.equals(this.module, variance.module) && Objects.equals(this.attackValue, variance.attackValue) && Objects.equals(this.attackExchanges, variance.attackExchanges) && Objects.equals(this.message, variance.message);
    }

    public int hashCode() {
        return Objects.hash(this.originalValue, this.originalExchange, this.attack, this.module, this.attackValue, this.attackExchanges, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Variance {\n");
        sb.append("    originalValue: ").append(this.toIndentedString(this.originalValue)).append("\n");
        sb.append("    originalExchange: ").append(this.toIndentedString(this.originalExchange)).append("\n");
        sb.append("    attack: ").append(this.toIndentedString(this.attack)).append("\n");
        sb.append("    module: ").append(this.toIndentedString(this.module)).append("\n");
        sb.append("    attackValue: ").append(this.toIndentedString(this.attackValue)).append("\n");
        sb.append("    attackExchanges: ").append(this.toIndentedString(this.attackExchanges)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

