/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.rapid7.ias.client.model.ReadOnlyIdResource;
import com.rapid7.ias.client.model.RequiredIdResource;
import com.rapid7.ias.client.model.ScanSubmitter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;

public class Scan {
    @SerializedName(value="id")
    private UUID id = null;
    @SerializedName(value="app")
    private ReadOnlyIdResource app = null;
    @SerializedName(value="scan_config")
    private RequiredIdResource scanConfig = null;
    @SerializedName(value="submitter")
    private ScanSubmitter submitter = null;
    @SerializedName(value="submit_time")
    private DateTime submitTime = null;
    @SerializedName(value="completion_time")
    private DateTime completionTime = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="failure_reason")
    private FailureReasonEnum failureReason = null;

    @ApiModelProperty(value="The ID of the Scan")
    public UUID getId() {
        return this.id;
    }

    public Scan app(ReadOnlyIdResource app) {
        this.app = app;
        return this;
    }

    @ApiModelProperty(value="The App to be associated with the Scan, must also be the App associated with the specified Scan Config")
    public ReadOnlyIdResource getApp() {
        return this.app;
    }

    public void setApp(ReadOnlyIdResource app) {
        this.app = app;
    }

    public Scan scanConfig(RequiredIdResource scanConfig) {
        this.scanConfig = scanConfig;
        return this;
    }

    @ApiModelProperty(required=true, value="The Scan Config used when the Scan was submitted, must be associated with the App specified for this Scan")
    public RequiredIdResource getScanConfig() {
        return this.scanConfig;
    }

    public void setScanConfig(RequiredIdResource scanConfig) {
        this.scanConfig = scanConfig;
    }

    public Scan submitter(ScanSubmitter submitter) {
        this.submitter = submitter;
        return this;
    }

    @ApiModelProperty(value="The submitter of the Scan")
    public ScanSubmitter getSubmitter() {
        return this.submitter;
    }

    public void setSubmitter(ScanSubmitter submitter) {
        this.submitter = submitter;
    }

    @ApiModelProperty(value="The time the Scan was submitted")
    public DateTime getSubmitTime() {
        return this.submitTime;
    }

    @ApiModelProperty(value="The time the Scan was completed")
    public DateTime getCompletionTime() {
        return this.completionTime;
    }

    @ApiModelProperty(value="The status of the Scan")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(value="The reason the Scan may have failed")
    public FailureReasonEnum getFailureReason() {
        return this.failureReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scan scan = (Scan)o;
        return Objects.equals(this.id, scan.id) && Objects.equals(this.app, scan.app) && Objects.equals(this.scanConfig, scan.scanConfig) && Objects.equals(this.submitter, scan.submitter) && Objects.equals(this.submitTime, scan.submitTime) && Objects.equals(this.completionTime, scan.completionTime) && Objects.equals((Object)this.status, (Object)scan.status) && Objects.equals((Object)this.failureReason, (Object)scan.failureReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.app, this.scanConfig, this.submitter, this.submitTime, this.completionTime, this.status, this.failureReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Scan {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    scanConfig: ").append(this.toIndentedString(this.scanConfig)).append("\n");
        sb.append("    submitter: ").append(this.toIndentedString(this.submitter)).append("\n");
        sb.append("    submitTime: ").append(this.toIndentedString(this.submitTime)).append("\n");
        sb.append("    completionTime: ").append(this.toIndentedString(this.completionTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString((Object)this.failureReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FailureReasonEnum {
        CANCELED("CANCELED"),
        NETWORK_UNAVAILABLE("NETWORK_UNAVAILABLE"),
        SYSTEM_ERROR("SYSTEM_ERROR"),
        CONFIGURATION_INVALID("CONFIGURATION_INVALID"),
        BAD_AUTH("BAD_AUTH"),
        LICENSE_INVALID("LICENSE_INVALID"),
        ENGINE_UNAVAILABLE("ENGINE_UNAVAILABLE"),
        INITIALIZATION_FAILURE("INITIALIZATION_FAILURE"),
        SWAGGER_PARSING_ERROR("SWAGGER_PARSING_ERROR"),
        DATABASE_TOO_LARGE("DATABASE_TOO_LARGE"),
        INSUFFICIENT_DISK_SPACE("INSUFFICIENT_DISK_SPACE"),
        INSUFFICIENT_MEMORY("INSUFFICIENT_MEMORY"),
        TOO_MANY_THREADS("TOO_MANY_THREADS"),
        RASP_FAILURE("RASP_FAILURE"),
        REPORT_GENERATION_FAILURE("REPORT_GENERATION_FAILURE");

        private String value;

        private FailureReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FailureReasonEnum fromValue(String text) {
            for (FailureReasonEnum b : FailureReasonEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FailureReasonEnum> {
            @Override
            public void write(JsonWriter jsonWriter, FailureReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public FailureReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FailureReasonEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        PENDING("PENDING"),
        RUNNING("RUNNING"),
        SCANNED("SCANNED"),
        PROCESSED("PROCESSED"),
        COMPLETE("COMPLETE"),
        PAUSED("PAUSED"),
        BLACKED_OUT("BLACKED_OUT"),
        PAUSING("PAUSING"),
        RESUMING("RESUMING"),
        STOPPING("STOPPING"),
        CANCELING("CANCELING"),
        FAILED("FAILED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            @Override
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

