/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.client.model;

import com.google.gson.annotations.SerializedName;
import com.rapid7.ias.client.model.Link;
import com.rapid7.ias.client.model.RequiredIdResource;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class ResourceScanConfig {
    @SerializedName(value="id")
    private UUID id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="app")
    private RequiredIdResource app = null;
    @SerializedName(value="attack_template")
    private RequiredIdResource attackTemplate = null;
    @SerializedName(value="errors")
    private List<String> errors = null;
    @SerializedName(value="links")
    private List<Link> links = null;

    @ApiModelProperty(value="The ID of the Scan Config")
    public UUID getId() {
        return this.id;
    }

    public ResourceScanConfig name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the Scan Config")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceScanConfig description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the Scan Config")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceScanConfig app(RequiredIdResource app) {
        this.app = app;
        return this;
    }

    @ApiModelProperty(required=true, value="The App that the Scan is associated with")
    public RequiredIdResource getApp() {
        return this.app;
    }

    public void setApp(RequiredIdResource app) {
        this.app = app;
    }

    public ResourceScanConfig attackTemplate(RequiredIdResource attackTemplate) {
        this.attackTemplate = attackTemplate;
        return this;
    }

    @ApiModelProperty(required=true, value="The attack template that the Scan Config should use")
    public RequiredIdResource getAttackTemplate() {
        return this.attackTemplate;
    }

    public void setAttackTemplate(RequiredIdResource attackTemplate) {
        this.attackTemplate = attackTemplate;
    }

    public ResourceScanConfig errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public ResourceScanConfig addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="A list of errors that detail any current validation failures")
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public ResourceScanConfig links(List<Link> links) {
        this.links = links;
        return this;
    }

    public ResourceScanConfig addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceScanConfig resourceScanConfig = (ResourceScanConfig)o;
        return Objects.equals(this.id, resourceScanConfig.id) && Objects.equals(this.name, resourceScanConfig.name) && Objects.equals(this.description, resourceScanConfig.description) && Objects.equals(this.app, resourceScanConfig.app) && Objects.equals(this.attackTemplate, resourceScanConfig.attackTemplate) && Objects.equals(this.errors, resourceScanConfig.errors) && Objects.equals(this.links, resourceScanConfig.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.app, this.attackTemplate, this.errors, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceScanConfig {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    attackTemplate: ").append(this.toIndentedString(this.attackTemplate)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

