/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.bamboo.impl;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.rapid7.ias.bamboo.impl.IasConstants;
import com.rapid7.ias.bamboo.impl.InsightAppSecException;
import com.rapid7.ias.bamboo.impl.InsightAppSecHelper;
import com.rapid7.ias.bamboo.util.UtilityLogger;
import com.rapid7.ias.client.ApiClient;
import com.rapid7.ias.client.model.ResourceApp;
import com.rapid7.ias.client.model.ResourceScanConfig;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Scanned
public class InsightAppSecScanTaskConfigurator
extends AbstractTaskConfigurator
implements IasConstants {
    @ComponentImport
    CredentialsAccessor credentialsAccessor;
    private I18nBean i18nBean;

    public InsightAppSecScanTaskConfigurator(@ComponentImport I18nBeanFactory i18nBeanFactory, @ComponentImport CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
        this.i18nBean = i18nBeanFactory.getI18nBean();
    }

    private Map<Long, String> getCredentials() {
        Hashtable<Long, String> credentials = new Hashtable<Long, String>();
        for (CredentialsData data : this.credentialsAccessor.getAllCredentials()) {
            if (!data.getName().startsWith("Rapid7")) continue;
            credentials.put(data.getId(), data.getName());
        }
        return credentials;
    }

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map configMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        configMap.put("region", params.getString("region"));
        configMap.put("otherRegion", params.getString("otherRegion"));
        configMap.put("selectedCred", params.getString("selectedCred"));
        configMap.put("appName", params.getString("appName"));
        configMap.put("scanConfigName", params.getString("scanConfigName"));
        configMap.put("proxyHost", params.getString("proxyHost"));
        configMap.put("proxyPort", params.getString("proxyPort"));
        configMap.put("advanceOn", params.getString("advanceOn"));
        if (params.getString("advanceOn").equals("STARTED")) {
            configMap.put("checkInterval", params.getString("checkIntervalStarted"));
            configMap.put("maxPending", params.getString("maxPendingStarted"));
        } else {
            configMap.put("checkInterval", params.getString("checkInterval"));
            configMap.put("maxPending", params.getString("maxPending"));
        }
        configMap.put("maxExecution", params.getString("maxExecution"));
        configMap.put("findingsReportGeneration", params.getString("findingsReportGeneration"));
        configMap.put("vulnQueryEnforcement", params.getString("vulnQueryEnforcement"));
        configMap.put("debugging", params.getString("debugging"));
        configMap.put("vulnQuery", params.getString("vulnQuery"));
        return configMap;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        Logger log = LogManager.getLogger(InsightAppSecScanTaskConfigurator.class);
        UtilityLogger logger = new UtilityLogger(log);
        super.validate(params, errorCollection);
        String regionValue = params.getString("region");
        if (regionValue.equals("OTHER")) {
            regionValue = params.getString("otherRegion");
        }
        String credentialId = params.getString("selectedCred");
        String appNameValue = params.getString("appName");
        String scanConfigNameValue = params.getString("scanConfigName");
        String proxyHostValue = params.getString("proxyHost");
        String proxyPortValue = params.getString("proxyPort");
        String debugging = params.getString("debugging");
        Boolean proxyEnabled = null;
        if (credentialId == null) {
            errorCollection.addError("selectedCred", this.i18nBean.getText("error.apiKey"));
        } else if (this.credentialsAccessor.getCredentials(Long.parseLong(credentialId)) == null) {
            errorCollection.addError("selectedCred", this.i18nBean.getText("error.apiKeyNotExist"));
        } else if (StringUtils.isEmpty((String)regionValue)) {
            errorCollection.addError("region", this.i18nBean.getText("error.region"));
        } else if (StringUtils.isEmpty((String)appNameValue)) {
            errorCollection.addError("appName", this.i18nBean.getText("error.appName"));
        } else if (StringUtils.isEmpty((String)scanConfigNameValue)) {
            errorCollection.addError("scanConfigName", this.i18nBean.getText("error.scanConfigName"));
        } else if (StringUtils.isNotEmpty((String)proxyPortValue) && !StringUtils.isNumeric((String)proxyPortValue)) {
            errorCollection.addError("proxyPort", this.i18nBean.getText("error.proxyPort"));
        } else {
            CredentialsData cred = this.credentialsAccessor.getCredentials(Long.parseLong(credentialId));
            if (proxyHostValue.isEmpty()) {
                proxyHostValue = null;
                proxyPortValue = null;
            } else {
                proxyEnabled = this.checkProxyConnection(proxyHostValue, proxyPortValue);
            }
            InsightAppSecHelper iasHelper = new InsightAppSecHelper(regionValue, (String)cred.getConfiguration().get("password"), logger, proxyHostValue, proxyPortValue, debugging);
            try {
                ResourceApp application = iasHelper.getApplication(appNameValue);
                if (application == null && proxyEnabled == null || application == null && proxyEnabled.booleanValue()) {
                    errorCollection.addError("appName", this.i18nBean.getText("error.invalidAppConfig"));
                } else if (application == null && !proxyEnabled.booleanValue()) {
                    errorCollection.addError("proxyHost", this.i18nBean.getText("error.proxyConnection"));
                    errorCollection.addError("proxyPort", this.i18nBean.getText("error.proxyConnection"));
                } else {
                    ResourceScanConfig scanConfig = iasHelper.getScanConfiguration(scanConfigNameValue, application.getId());
                    if (scanConfig == null) {
                        errorCollection.addError("scanConfigName", this.i18nBean.getText("error.invalidScanConfig"));
                    }
                }
            }
            catch (InsightAppSecException iase) {
                errorCollection.addError("selectedCred", this.i18nBean.getText("error.authFailure"));
            }
        }
    }

    private boolean checkProxyConnection(String proxyHostValue, String proxyPortValue) {
        ApiClient apiClient = new ApiClient(proxyHostValue, proxyPortValue);
        apiClient.setBasePath("https://www.rapid7.com");
        return apiClient.checkProxyConnection();
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        Map<Long, String> credentials = this.getCredentials();
        if (credentials.size() > 0) {
            context.put("credentialList", this.getCredentials());
        }
        context.put("regionList", REGION_OPTIONS_LIST);
        context.put("checkIntervalStarted", this.i18nBean.getText("default.checkInterval"));
        context.put("maxPendingStarted", this.i18nBean.getText("default.maxPending"));
        context.put("checkInterval", this.i18nBean.getText("default.checkInterval"));
        context.put("maxPending", this.i18nBean.getText("default.maxPending"));
        context.put("maxExecution", this.i18nBean.getText("default.maxExecution"));
        context.put("advanceOnOptions", ADVANCE_ON_OPTIONS_LIST);
        context.put("findingsReportGeneration", this.i18nBean.getText("default.findingsReportGeneration"));
        context.put("debugging", this.i18nBean.getText("default.debugging"));
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put("credentialList", this.getCredentials());
        context.put("regionList", REGION_OPTIONS_LIST);
        context.put("advanceOnOptions", ADVANCE_ON_OPTIONS_LIST);
        Map config = taskDefinition.getConfiguration();
        context.put("selectedCred", config.get("selectedCred"));
        context.put("region", config.get("region"));
        context.put("otherRegion", config.get("otherRegion"));
        context.put("advanceOn", config.get("advanceOn"));
        context.put("appName", config.get("appName"));
        context.put("scanConfigName", config.get("scanConfigName"));
        context.put("proxyHost", config.get("proxyHost"));
        context.put("proxyPort", config.get("proxyPort"));
        context.put("checkIntervalStarted", config.get("checkInterval"));
        context.put("maxPendingStarted", config.get("maxPending"));
        context.put("checkInterval", config.get("checkInterval"));
        context.put("maxPending", config.get("maxPending"));
        context.put("maxExecution", config.get("maxExecution"));
        context.put("findingsReportGeneration", config.get("findingsReportGeneration"));
        context.put("vulnQueryEnforcement", config.get("vulnQueryEnforcement"));
        context.put("vulnQuery", config.get("vulnQuery"));
        context.put("debugging", config.get("debugging"));
    }
}

