/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.bamboo.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.rapid7.ias.bamboo.impl.InsightAppSecException;
import com.rapid7.ias.bamboo.util.UtilityLogger;
import com.rapid7.ias.client.ApiClient;
import com.rapid7.ias.client.ApiException;
import com.rapid7.ias.client.ApiResponse;
import com.rapid7.ias.client.api.AppsApi;
import com.rapid7.ias.client.api.ScanConfigsApi;
import com.rapid7.ias.client.api.ScansApi;
import com.rapid7.ias.client.api.SearchApi;
import com.rapid7.ias.client.api.VulnerabilitiesApi;
import com.rapid7.ias.client.model.PageApp;
import com.rapid7.ias.client.model.PageScanConfig;
import com.rapid7.ias.client.model.PageVulnerability;
import com.rapid7.ias.client.model.RequiredIdResource;
import com.rapid7.ias.client.model.ResourceApp;
import com.rapid7.ias.client.model.ResourceScan;
import com.rapid7.ias.client.model.ResourceScanConfig;
import com.rapid7.ias.client.model.ResourceVulnerability;
import com.rapid7.ias.client.model.Scan;
import com.rapid7.ias.client.model.SearchRequest;
import com.squareup.okhttp.Call;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InsightAppSecHelper {
    private String USER_AGENT = "r7:insightappsec-bamboo/1.2.2";
    private String SCAN_CONFIG_QUERY = "scanconfig.app.id='%1$s' && scanconfig.name='%2$s'";
    private UtilityLogger logger;
    public ScansApi scansApi;
    public ScanConfigsApi scanConfigsApi;
    public AppsApi appsApi;
    public SearchApi searchApi;
    public VulnerabilitiesApi vulnerabilitiesApi;

    public InsightAppSecHelper(String region, String apiKey, UtilityLogger logger, String proxyHost, String proxyPort, String debugging) {
        this.logger = logger;
        debugging = debugging == null || debugging.isEmpty() ? "false" : debugging;
        ApiClient client = new ApiClient(proxyHost, proxyPort).setDebugging(Boolean.parseBoolean(debugging));
        client.setBasePath("https://" + region + ".api.insight.rapid7.com/ias/v1");
        client.addDefaultHeader("X-Api-Key", apiKey);
        client.setUserAgent(this.USER_AGENT);
        this.scansApi = new ScansApi(client);
        this.scanConfigsApi = new ScanConfigsApi(client);
        this.appsApi = new AppsApi(client);
        this.searchApi = new SearchApi(client);
        this.vulnerabilitiesApi = new VulnerabilitiesApi(client);
    }

    private void handleException(ApiException exception) throws InsightAppSecException {
        if (exception.getCode() == 401) {
            throw new InsightAppSecException(exception.getResponseBody());
        }
    }

    public String runScan(UUID scanConfigId) throws InsightAppSecException {
        Scan scan = new Scan();
        RequiredIdResource scanConfig = new RequiredIdResource();
        scanConfig.setId(scanConfigId);
        scan.setScanConfig(scanConfig);
        try {
            ApiResponse<Void> response = this.scansApi.submitScanWithHttpInfo(scan);
            String scanLocation = null;
            String scanId = null;
            Map<String, List<String>> headers = response.getHeaders();
            for (Map.Entry<String, List<String>> pair : headers.entrySet()) {
                if (!pair.getKey().equals("Location")) continue;
                scanLocation = pair.getValue().get(0);
            }
            if (scanLocation == null) {
                return null;
            }
            Pattern pattern = Pattern.compile(".+/(.+)$");
            Matcher matcher = pattern.matcher(scanLocation);
            if (matcher.find()) {
                scanId = matcher.group(1);
            }
            return scanId;
        }
        catch (ApiException iase) {
            this.logger.error("InsightAppSec Scan Exception: " + iase.getResponseBody() + " (" + iase.getCode() + ")");
            this.handleException(iase);
            return null;
        }
        catch (Exception e) {
            this.logger.error("Exception when calling ScansApi#submitScan: " + e.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> scanStatus(String scanId) throws InsightAppSecException {
        HashMap<String, String> status = new HashMap<String, String>(){
            {
                this.put("Status", "Unknown");
                this.put("Reason", "Unknown");
            }
        };
        try {
            final ResourceScan scan = this.scansApi.getScan(UUID.fromString(scanId));
            if (scan.getStatus() != null) {
                if (scan.getStatus().getValue() != null) {
                    status = new HashMap<String, String>(){
                        {
                            this.put("Status", scan.getStatus().getValue());
                            if (scan.getFailureReason() != null) {
                                this.put("Reason", Objects.toString(scan.getFailureReason().getValue(), ""));
                            } else {
                                this.put("Reason", "");
                            }
                        }
                    };
                    return status;
                }
            }
        }
        catch (ApiException iase) {
            this.logger.error("Failed to retrieve scan by ID " + scanId + ": " + iase.getCode());
            this.handleException(iase);
        }
        finally {
            return status;
        }
    }

    public ResourceScanConfig getScanConfiguration(String scanConfigName, UUID appId) throws InsightAppSecException {
        SearchRequest scanConfigSearch = new SearchRequest();
        scanConfigSearch.type(SearchRequest.TypeEnum.SCAN_CONFIG);
        scanConfigSearch.setQuery(String.format(this.SCAN_CONFIG_QUERY, appId.toString(), scanConfigName));
        try {
            Call searchApiCall = this.searchApi.performSearchCall(scanConfigSearch, 0, 50, null, null, null);
            ApiResponse response = this.searchApi.getApiClient().execute(searchApiCall, (Type)((Object)PageScanConfig.class));
            PageScanConfig resultsPage = (PageScanConfig)response.getData();
            List<ResourceScanConfig> results = resultsPage.getData();
            if (results == null || results.size() != 1) {
                this.logger.error("Number of application's scan configs with name " + scanConfigName + " should be 1.");
                return null;
            }
            return results.get(0);
        }
        catch (ApiException iase) {
            this.logger.error("InsightAppSec Scan Config Exception: " + iase.getResponseBody() + " (" + iase.getCode() + ")");
            this.handleException(iase);
        }
        catch (Exception e) {
            this.logger.error("Exception when calling ScanConfigsApi#getScanConfigs: " + e.toString());
        }
        return null;
    }

    public ResourceApp getApplication(String appName) throws InsightAppSecException {
        Integer index = 0;
        Integer size = 1000;
        Boolean cont = true;
        while (cont.booleanValue()) {
            try {
                PageApp apps = this.appsApi.getApps(index, size, null);
                List<ResourceApp> listApps = apps.getData();
                for (ResourceApp app : listApps) {
                    if (!app.getName().equals(appName)) continue;
                    return app;
                }
                if (index + 1 >= apps.getMetadata().getTotalPages()) {
                    cont = false;
                }
            }
            catch (ApiException iase) {
                String message = iase.getCause() == null ? null : iase.getCause().toString();
                this.logger.error("InsightAppSec Apps Client Exception: " + iase.getResponseBody() + " (" + iase.getCode() + ")");
                this.logger.error("Error Message: " + message);
                this.handleException(iase);
                return null;
            }
            catch (Exception e) {
                this.logger.error("Exception when calling AppsApi#getApps: " + e.getMessage());
                return null;
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return null;
    }

    public List<ResourceVulnerability> getFindings(String scanId, String queryCondition) throws InsightAppSecException {
        Integer totalPages;
        Integer page = 0;
        Integer size = 1000;
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setType(SearchRequest.TypeEnum.VULNERABILITY);
        String query = "vulnerability.scans.id='" + scanId + "'";
        if (!queryCondition.equals("")) {
            query = query + " && " + queryCondition;
        }
        searchRequest.setQuery(query);
        ArrayList<ResourceVulnerability> findings = new ArrayList<ResourceVulnerability>();
        do {
            try {
                Call call = this.searchApi.performSearchCall(searchRequest, page, size, null, null, null);
                ApiResponse result = this.searchApi.getApiClient().execute(call, (Type)((Object)PageVulnerability.class));
                PageVulnerability pageVulnerability = (PageVulnerability)result.getData();
                List<ResourceVulnerability> vulns = pageVulnerability.getData();
                for (ResourceVulnerability vuln : vulns) {
                    findings.add(vuln);
                }
                totalPages = pageVulnerability.getMetadata().getTotalPages();
            }
            catch (ApiException iase) {
                this.logger.error("InsightAppSec Apps Client Exception: " + iase.getResponseBody() + " (" + iase.getCode() + ")");
                this.handleException(iase);
                return null;
            }
            catch (Exception e) {
                this.logger.error("Exception when calling SearchApi#performSearch");
                return null;
            }
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
        } while (page < totalPages);
        return findings;
    }

    public void generateScanMetrics(List<ResourceVulnerability> vulns, String filename) {
        HashMap<String, Integer> severityMetrics = new HashMap<String, Integer>();
        HashMap<String, Integer> moduleMetrics = new HashMap<String, Integer>();
        for (ResourceVulnerability vuln : vulns) {
            String module = "Unknown";
            try {
                module = this.vulnerabilitiesApi.getModule(vuln.getVariances().get(0).getModule().getId()).getName();
            }
            catch (ApiException apiException) {
                // empty catch block
            }
            if (moduleMetrics.containsKey(module)) {
                moduleMetrics.put(module, (Integer)moduleMetrics.get(module) + 1);
            } else {
                moduleMetrics.put(module, 1);
            }
            String severity = vuln.getSeverity().getValue();
            if (severityMetrics.containsKey(severity)) {
                severityMetrics.put(severity, (Integer)severityMetrics.get(severity) + 1);
                continue;
            }
            severityMetrics.put(severity, 1);
        }
        HashMap<String, HashMap<String, Integer>> metrics = new HashMap<String, HashMap<String, Integer>>();
        metrics.put("severity", severityMetrics);
        metrics.put("module", moduleMetrics);
        try (FileWriter writer = new FileWriter(filename);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(metrics, (Appendable)writer);
        }
        catch (IOException e) {
            this.logger.error("Failed to generate findings metric report: " + e.getMessage());
        }
    }

    public void generateFindingsReport(List<ResourceVulnerability> vulns, String filename) {
        ArrayList findingsList = new ArrayList();
        for (ResourceVulnerability vuln : vulns) {
            HashMap<String, String> rootCause = new HashMap<String, String>();
            rootCause.put("Url", vuln.getRootCause().getUrl());
            rootCause.put("Parameter", vuln.getRootCause().getParameter());
            rootCause.put("Method", vuln.getRootCause().getMethod());
            HashMap<String, String> variance = new HashMap<String, String>();
            try {
                variance.put("Attack", this.vulnerabilitiesApi.getAttack(vuln.getVariances().get(0).getAttack().getId(), vuln.getVariances().get(0).getModule().getId()).getType());
            }
            catch (ApiException e) {
                variance.put("Attack", vuln.getVariances().get(0).getAttack().getId());
            }
            try {
                variance.put("Module", this.vulnerabilitiesApi.getModule(vuln.getVariances().get(0).getModule().getId()).getName());
            }
            catch (ApiException e) {
                variance.put("Module", vuln.getVariances().get(0).getModule().getId().toString());
            }
            HashMap<String, Object> finding = new HashMap<String, Object>();
            finding.put("AppId", vuln.getApp().getId().toString());
            finding.put("VulnId", vuln.getId().toString());
            finding.put("Status", vuln.getStatus().getValue());
            finding.put("Severity", vuln.getSeverity().getValue());
            finding.put("RootCause", rootCause);
            finding.put("Variance", variance);
            findingsList.add(finding);
        }
        try (FileWriter writer = new FileWriter(filename);){
            Gson gson = new GsonBuilder().create();
            gson.toJson(findingsList, (Appendable)writer);
        }
        catch (IOException e) {
            this.logger.error("Failed to generate findings report: " + e.getMessage());
        }
    }
}

