/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.client.api;

import com.google.gson.reflect.TypeToken;
import com.rapid7.ias.client.ApiCallback;
import com.rapid7.ias.client.ApiClient;
import com.rapid7.ias.client.ApiException;
import com.rapid7.ias.client.ApiResponse;
import com.rapid7.ias.client.Configuration;
import com.rapid7.ias.client.Pair;
import com.rapid7.ias.client.ProgressRequestBody;
import com.rapid7.ias.client.ProgressResponseBody;
import com.rapid7.ias.client.model.AttackDocumentation;
import com.rapid7.ias.client.model.AttackMetadata;
import com.rapid7.ias.client.model.ModuleMetadata;
import com.rapid7.ias.client.model.PageVulnerability;
import com.rapid7.ias.client.model.ResourceVulnerability;
import com.rapid7.ias.client.model.Vulnerability;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class VulnerabilitiesApi {
    private ApiClient apiClient;

    public VulnerabilitiesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VulnerabilitiesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getAttackCall(String attackId, UUID moduleId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/modules/{module-id}/attacks/{attack-id}".replaceAll("\\{attack-id\\}", this.apiClient.escapeString(attackId.toString())).replaceAll("\\{module-id\\}", this.apiClient.escapeString(moduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAttackValidateBeforeCall(String attackId, UUID moduleId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (attackId == null) {
            throw new ApiException("Missing the required parameter 'attackId' when calling getAttack(Async)");
        }
        if (moduleId == null) {
            throw new ApiException("Missing the required parameter 'moduleId' when calling getAttack(Async)");
        }
        Call call = this.getAttackCall(attackId, moduleId, progressListener, progressRequestListener);
        return call;
    }

    public AttackMetadata getAttack(String attackId, UUID moduleId) throws ApiException {
        ApiResponse<AttackMetadata> resp = this.getAttackWithHttpInfo(attackId, moduleId);
        return resp.getData();
    }

    public ApiResponse<AttackMetadata> getAttackWithHttpInfo(String attackId, UUID moduleId) throws ApiException {
        Call call = this.getAttackValidateBeforeCall(attackId, moduleId, null, null);
        Type localVarReturnType = new TypeToken<AttackMetadata>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAttackAsync(String attackId, UUID moduleId, final ApiCallback<AttackMetadata> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAttackValidateBeforeCall(attackId, moduleId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AttackMetadata>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAttackDocumentationCall(String attackId, UUID moduleId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/modules/{module-id}/attacks/{attack-id}/documentation".replaceAll("\\{attack-id\\}", this.apiClient.escapeString(attackId.toString())).replaceAll("\\{module-id\\}", this.apiClient.escapeString(moduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAttackDocumentationValidateBeforeCall(String attackId, UUID moduleId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (attackId == null) {
            throw new ApiException("Missing the required parameter 'attackId' when calling getAttackDocumentation(Async)");
        }
        if (moduleId == null) {
            throw new ApiException("Missing the required parameter 'moduleId' when calling getAttackDocumentation(Async)");
        }
        Call call = this.getAttackDocumentationCall(attackId, moduleId, progressListener, progressRequestListener);
        return call;
    }

    public AttackDocumentation getAttackDocumentation(String attackId, UUID moduleId) throws ApiException {
        ApiResponse<AttackDocumentation> resp = this.getAttackDocumentationWithHttpInfo(attackId, moduleId);
        return resp.getData();
    }

    public ApiResponse<AttackDocumentation> getAttackDocumentationWithHttpInfo(String attackId, UUID moduleId) throws ApiException {
        Call call = this.getAttackDocumentationValidateBeforeCall(attackId, moduleId, null, null);
        Type localVarReturnType = new TypeToken<AttackDocumentation>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAttackDocumentationAsync(String attackId, UUID moduleId, final ApiCallback<AttackDocumentation> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAttackDocumentationValidateBeforeCall(attackId, moduleId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AttackDocumentation>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getModuleCall(UUID moduleId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/modules/{module-id}".replaceAll("\\{module-id\\}", this.apiClient.escapeString(moduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getModuleValidateBeforeCall(UUID moduleId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (moduleId == null) {
            throw new ApiException("Missing the required parameter 'moduleId' when calling getModule(Async)");
        }
        Call call = this.getModuleCall(moduleId, progressListener, progressRequestListener);
        return call;
    }

    public ModuleMetadata getModule(UUID moduleId) throws ApiException {
        ApiResponse<ModuleMetadata> resp = this.getModuleWithHttpInfo(moduleId);
        return resp.getData();
    }

    public ApiResponse<ModuleMetadata> getModuleWithHttpInfo(UUID moduleId) throws ApiException {
        Call call = this.getModuleValidateBeforeCall(moduleId, null, null);
        Type localVarReturnType = new TypeToken<ModuleMetadata>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getModuleAsync(UUID moduleId, final ApiCallback<ModuleMetadata> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getModuleValidateBeforeCall(moduleId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ModuleMetadata>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getVulnerabilitiesCall(Integer index, Integer size, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/vulnerabilities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (index != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("index", index));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getVulnerabilitiesValidateBeforeCall(Integer index, Integer size, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getVulnerabilitiesCall(index, size, sort, progressListener, progressRequestListener);
        return call;
    }

    public PageVulnerability getVulnerabilities(Integer index, Integer size, String sort) throws ApiException {
        ApiResponse<PageVulnerability> resp = this.getVulnerabilitiesWithHttpInfo(index, size, sort);
        return resp.getData();
    }

    public ApiResponse<PageVulnerability> getVulnerabilitiesWithHttpInfo(Integer index, Integer size, String sort) throws ApiException {
        Call call = this.getVulnerabilitiesValidateBeforeCall(index, size, sort, null, null);
        Type localVarReturnType = new TypeToken<PageVulnerability>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getVulnerabilitiesAsync(Integer index, Integer size, String sort, final ApiCallback<PageVulnerability> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getVulnerabilitiesValidateBeforeCall(index, size, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageVulnerability>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getVulnerabilityCall(UUID vulnId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/vulnerabilities/{vuln-id}".replaceAll("\\{vuln-id\\}", this.apiClient.escapeString(vulnId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getVulnerabilityValidateBeforeCall(UUID vulnId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (vulnId == null) {
            throw new ApiException("Missing the required parameter 'vulnId' when calling getVulnerability(Async)");
        }
        Call call = this.getVulnerabilityCall(vulnId, progressListener, progressRequestListener);
        return call;
    }

    public ResourceVulnerability getVulnerability(UUID vulnId) throws ApiException {
        ApiResponse<ResourceVulnerability> resp = this.getVulnerabilityWithHttpInfo(vulnId);
        return resp.getData();
    }

    public ApiResponse<ResourceVulnerability> getVulnerabilityWithHttpInfo(UUID vulnId) throws ApiException {
        Call call = this.getVulnerabilityValidateBeforeCall(vulnId, null, null);
        Type localVarReturnType = new TypeToken<ResourceVulnerability>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getVulnerabilityAsync(UUID vulnId, final ApiCallback<ResourceVulnerability> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getVulnerabilityValidateBeforeCall(vulnId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourceVulnerability>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateVulnerabilityCall(Vulnerability resource, UUID vulnId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Vulnerability localVarPostBody = resource;
        String localVarPath = "/vulnerabilities/{vuln-id}".replaceAll("\\{vuln-id\\}", this.apiClient.escapeString(vulnId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateVulnerabilityValidateBeforeCall(Vulnerability resource, UUID vulnId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (resource == null) {
            throw new ApiException("Missing the required parameter 'resource' when calling updateVulnerability(Async)");
        }
        if (vulnId == null) {
            throw new ApiException("Missing the required parameter 'vulnId' when calling updateVulnerability(Async)");
        }
        Call call = this.updateVulnerabilityCall(resource, vulnId, progressListener, progressRequestListener);
        return call;
    }

    public void updateVulnerability(Vulnerability resource, UUID vulnId) throws ApiException {
        this.updateVulnerabilityWithHttpInfo(resource, vulnId);
    }

    public ApiResponse<Void> updateVulnerabilityWithHttpInfo(Vulnerability resource, UUID vulnId) throws ApiException {
        Call call = this.updateVulnerabilityValidateBeforeCall(resource, vulnId, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateVulnerabilityAsync(Vulnerability resource, UUID vulnId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateVulnerabilityValidateBeforeCall(resource, vulnId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

