/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.client.api;

import com.google.gson.reflect.TypeToken;
import com.rapid7.ias.client.ApiCallback;
import com.rapid7.ias.client.ApiClient;
import com.rapid7.ias.client.ApiException;
import com.rapid7.ias.client.ApiResponse;
import com.rapid7.ias.client.Configuration;
import com.rapid7.ias.client.Pair;
import com.rapid7.ias.client.ProgressRequestBody;
import com.rapid7.ias.client.ProgressResponseBody;
import com.rapid7.ias.client.model.PageScanConfig;
import com.rapid7.ias.client.model.ResourceScanConfig;
import com.rapid7.ias.client.model.ScanConfig;
import com.rapid7.ias.client.model.ScanConfigOptions;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class ScanConfigsApi {
    private ApiClient apiClient;

    public ScanConfigsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ScanConfigsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createScanConfigCall(ScanConfig scanConfig, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ScanConfig localVarPostBody = scanConfig;
        String localVarPath = "/scan-configs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createScanConfigValidateBeforeCall(ScanConfig scanConfig, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (scanConfig == null) {
            throw new ApiException("Missing the required parameter 'scanConfig' when calling createScanConfig(Async)");
        }
        Call call = this.createScanConfigCall(scanConfig, progressListener, progressRequestListener);
        return call;
    }

    public void createScanConfig(ScanConfig scanConfig) throws ApiException {
        this.createScanConfigWithHttpInfo(scanConfig);
    }

    public ApiResponse<Void> createScanConfigWithHttpInfo(ScanConfig scanConfig) throws ApiException {
        Call call = this.createScanConfigValidateBeforeCall(scanConfig, null, null);
        return this.apiClient.execute(call);
    }

    public Call createScanConfigAsync(ScanConfig scanConfig, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createScanConfigValidateBeforeCall(scanConfig, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteScanConfigCall(UUID scanConfigId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scan-configs/{scan-config-id}".replaceAll("\\{scan-config-id\\}", this.apiClient.escapeString(scanConfigId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteScanConfigValidateBeforeCall(UUID scanConfigId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (scanConfigId == null) {
            throw new ApiException("Missing the required parameter 'scanConfigId' when calling deleteScanConfig(Async)");
        }
        Call call = this.deleteScanConfigCall(scanConfigId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteScanConfig(UUID scanConfigId) throws ApiException {
        this.deleteScanConfigWithHttpInfo(scanConfigId);
    }

    public ApiResponse<Void> deleteScanConfigWithHttpInfo(UUID scanConfigId) throws ApiException {
        Call call = this.deleteScanConfigValidateBeforeCall(scanConfigId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteScanConfigAsync(UUID scanConfigId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteScanConfigValidateBeforeCall(scanConfigId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getScanConfigCall(UUID scanConfigId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scan-configs/{scan-config-id}".replaceAll("\\{scan-config-id\\}", this.apiClient.escapeString(scanConfigId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getScanConfigValidateBeforeCall(UUID scanConfigId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (scanConfigId == null) {
            throw new ApiException("Missing the required parameter 'scanConfigId' when calling getScanConfig(Async)");
        }
        Call call = this.getScanConfigCall(scanConfigId, progressListener, progressRequestListener);
        return call;
    }

    public ResourceScanConfig getScanConfig(UUID scanConfigId) throws ApiException {
        ApiResponse<ResourceScanConfig> resp = this.getScanConfigWithHttpInfo(scanConfigId);
        return resp.getData();
    }

    public ApiResponse<ResourceScanConfig> getScanConfigWithHttpInfo(UUID scanConfigId) throws ApiException {
        Call call = this.getScanConfigValidateBeforeCall(scanConfigId, null, null);
        Type localVarReturnType = new TypeToken<ResourceScanConfig>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getScanConfigAsync(UUID scanConfigId, final ApiCallback<ResourceScanConfig> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getScanConfigValidateBeforeCall(scanConfigId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResourceScanConfig>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getScanConfigOptionsCall(UUID scanConfigId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scan-configs/{scan-config-id}/options".replaceAll("\\{scan-config-id\\}", this.apiClient.escapeString(scanConfigId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getScanConfigOptionsValidateBeforeCall(UUID scanConfigId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (scanConfigId == null) {
            throw new ApiException("Missing the required parameter 'scanConfigId' when calling getScanConfigOptions(Async)");
        }
        Call call = this.getScanConfigOptionsCall(scanConfigId, progressListener, progressRequestListener);
        return call;
    }

    public ScanConfigOptions getScanConfigOptions(UUID scanConfigId) throws ApiException {
        ApiResponse<ScanConfigOptions> resp = this.getScanConfigOptionsWithHttpInfo(scanConfigId);
        return resp.getData();
    }

    public ApiResponse<ScanConfigOptions> getScanConfigOptionsWithHttpInfo(UUID scanConfigId) throws ApiException {
        Call call = this.getScanConfigOptionsValidateBeforeCall(scanConfigId, null, null);
        Type localVarReturnType = new TypeToken<ScanConfigOptions>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getScanConfigOptionsAsync(UUID scanConfigId, final ApiCallback<ScanConfigOptions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getScanConfigOptionsValidateBeforeCall(scanConfigId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ScanConfigOptions>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getScanConfigsCall(Integer index, Integer size, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scan-configs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (index != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("index", index));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getScanConfigsValidateBeforeCall(Integer index, Integer size, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getScanConfigsCall(index, size, sort, progressListener, progressRequestListener);
        return call;
    }

    public PageScanConfig getScanConfigs(Integer index, Integer size, String sort) throws ApiException {
        ApiResponse<PageScanConfig> resp = this.getScanConfigsWithHttpInfo(index, size, sort);
        return resp.getData();
    }

    public ApiResponse<PageScanConfig> getScanConfigsWithHttpInfo(Integer index, Integer size, String sort) throws ApiException {
        Call call = this.getScanConfigsValidateBeforeCall(index, size, sort, null, null);
        Type localVarReturnType = new TypeToken<PageScanConfig>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getScanConfigsAsync(Integer index, Integer size, String sort, final ApiCallback<PageScanConfig> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getScanConfigsValidateBeforeCall(index, size, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageScanConfig>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getScanConfigsOptionsDefaultCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/scan-configs/options/default";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getScanConfigsOptionsDefaultValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getScanConfigsOptionsDefaultCall(progressListener, progressRequestListener);
        return call;
    }

    public ScanConfigOptions getScanConfigsOptionsDefault() throws ApiException {
        ApiResponse<ScanConfigOptions> resp = this.getScanConfigsOptionsDefaultWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ScanConfigOptions> getScanConfigsOptionsDefaultWithHttpInfo() throws ApiException {
        Call call = this.getScanConfigsOptionsDefaultValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ScanConfigOptions>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getScanConfigsOptionsDefaultAsync(final ApiCallback<ScanConfigOptions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getScanConfigsOptionsDefaultValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ScanConfigOptions>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateScanConfigCall(UUID scanConfigId, ScanConfig scanConfig, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ScanConfig localVarPostBody = scanConfig;
        String localVarPath = "/scan-configs/{scan-config-id}".replaceAll("\\{scan-config-id\\}", this.apiClient.escapeString(scanConfigId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateScanConfigValidateBeforeCall(UUID scanConfigId, ScanConfig scanConfig, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (scanConfigId == null) {
            throw new ApiException("Missing the required parameter 'scanConfigId' when calling updateScanConfig(Async)");
        }
        if (scanConfig == null) {
            throw new ApiException("Missing the required parameter 'scanConfig' when calling updateScanConfig(Async)");
        }
        Call call = this.updateScanConfigCall(scanConfigId, scanConfig, progressListener, progressRequestListener);
        return call;
    }

    public void updateScanConfig(UUID scanConfigId, ScanConfig scanConfig) throws ApiException {
        this.updateScanConfigWithHttpInfo(scanConfigId, scanConfig);
    }

    public ApiResponse<Void> updateScanConfigWithHttpInfo(UUID scanConfigId, ScanConfig scanConfig) throws ApiException {
        Call call = this.updateScanConfigValidateBeforeCall(scanConfigId, scanConfig, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateScanConfigAsync(UUID scanConfigId, ScanConfig scanConfig, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateScanConfigValidateBeforeCall(scanConfigId, scanConfig, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateScanConfigOptionsCall(ScanConfigOptions options, UUID scanConfigId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ScanConfigOptions localVarPostBody = options;
        String localVarPath = "/scan-configs/{scan-config-id}/options".replaceAll("\\{scan-config-id\\}", this.apiClient.escapeString(scanConfigId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body(new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateScanConfigOptionsValidateBeforeCall(ScanConfigOptions options, UUID scanConfigId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (options == null) {
            throw new ApiException("Missing the required parameter 'options' when calling updateScanConfigOptions(Async)");
        }
        if (scanConfigId == null) {
            throw new ApiException("Missing the required parameter 'scanConfigId' when calling updateScanConfigOptions(Async)");
        }
        Call call = this.updateScanConfigOptionsCall(options, scanConfigId, progressListener, progressRequestListener);
        return call;
    }

    public void updateScanConfigOptions(ScanConfigOptions options, UUID scanConfigId) throws ApiException {
        this.updateScanConfigOptionsWithHttpInfo(options, scanConfigId);
    }

    public ApiResponse<Void> updateScanConfigOptionsWithHttpInfo(ScanConfigOptions options, UUID scanConfigId) throws ApiException {
        Call call = this.updateScanConfigOptionsValidateBeforeCall(options, scanConfigId, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateScanConfigOptionsAsync(ScanConfigOptions options, UUID scanConfigId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateScanConfigOptionsValidateBeforeCall(options, scanConfigId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

