/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.ias.bamboo.impl;

import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.rapid7.ias.bamboo.impl.IasConstants;
import com.rapid7.ias.bamboo.impl.InsightAppSecException;
import com.rapid7.ias.bamboo.impl.InsightAppSecHelper;
import com.rapid7.ias.bamboo.util.UtilityLogger;
import com.rapid7.ias.client.model.ResourceApp;
import com.rapid7.ias.client.model.ResourceScanConfig;
import com.rapid7.ias.client.model.ResourceVulnerability;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Scanned
public class InsightAppSecScanTask
implements CommonTaskType,
IasConstants {
    private UtilityLogger logger;
    private static final Logger log = Logger.getLogger(InsightAppSecScanTask.class);
    private String region;
    private String appName;
    private String scanConfigName;
    private String proxyHost;
    private String proxyPort;
    private String debugging;
    @ComponentImport
    ArtifactManager artifactManager;

    public InsightAppSecScanTask(@ComponentImport ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    @NotNull
    public TaskResult execute(CommonTaskContext taskContext) throws TaskException {
        TaskResultBuilder result = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        this.logger = new UtilityLogger(log, taskContext.getBuildLogger());
        Map runtimeContext = taskContext.getRuntimeTaskContext();
        String apiKey = (String)runtimeContext.get("password");
        ConfigurationMap configMap = taskContext.getConfigurationMap();
        this.region = (String)configMap.get((Object)"region");
        this.appName = (String)configMap.get((Object)"appName");
        this.scanConfigName = (String)configMap.get((Object)"scanConfigName");
        this.proxyHost = (String)configMap.get((Object)"proxyHost");
        this.proxyPort = (String)configMap.get((Object)"proxyPort");
        this.debugging = (String)configMap.get((Object)"debugging");
        if (apiKey == null) {
            this.logger.error("Previously configured credential is no longer defined within Bamboo; please review task and credential configuration");
            Thread.currentThread().interrupt();
            return result.failedWithError().build();
        }
        this.logger.info("Rapid7 InsightAppSec Platform Region: " + this.region);
        this.logger.info("App: " + this.appName);
        this.logger.info("Scan Config: " + this.scanConfigName);
        InsightAppSecHelper iasHelper = new InsightAppSecHelper(this.region, apiKey, this.logger, this.proxyHost, this.proxyPort, this.debugging);
        try {
            String scanId;
            ResourceApp app = iasHelper.getApplication(this.appName);
            if (app == null) {
                return result.failed().build();
            }
            this.logger.info("Retrieved app ID: " + app.getId().toString());
            ResourceScanConfig scanConfig = iasHelper.getScanConfiguration(this.scanConfigName, app.getId());
            if (scanConfig == null) {
                return result.failed().build();
            }
            this.logger.info("Retrieved scan config ID: " + scanConfig.getId().toString());
            try {
                scanId = iasHelper.runScan(scanConfig.getId());
                if (scanId == null) {
                    this.logger.error("Scan submitted for " + this.appName + " app; failing due to no scan ID being returned");
                    return result.failed().build();
                }
                this.logger.info("Scan submitted for " + this.appName + " app; scan ID: " + scanId);
                if (((String)configMap.get((Object)"advanceOn")).equals("SUBMITTED")) {
                    this.logger.info("Scan submitted, marking task as success.  Advance On: " + (String)configMap.get((Object)"advanceOn"));
                    return result.success().build();
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to initiate scan: " + e.toString());
                Thread.currentThread().interrupt();
                return result.failedWithError().build();
            }
            Integer elapsedTime = 0;
            Map<String, String> scanStatus = new HashMap<String, String>(){
                {
                    this.put("Status", "Unknown");
                    this.put("Reason", "Unknown");
                }
            };
            while (!Arrays.asList("FAILED", "COMPLETE").contains(scanStatus.get("Status"))) {
                scanStatus = iasHelper.scanStatus(scanId);
                this.logger.info("Scan status for " + scanId + ": " + scanStatus.get("Status"));
                if (scanStatus.get("Status").startsWith("FAILED")) {
                    this.logger.info("Scan failed (" + scanStatus.get("Reason") + "), failing task for scan ID: " + scanId);
                    Thread.currentThread().interrupt();
                    return result.failed().build();
                }
                if (((String)configMap.get((Object)"advanceOn")).equals("STARTED") && scanStatus.get("Status").equals("RUNNING")) {
                    this.logger.info("Scan running, marking task as success.  Advance On: " + (String)configMap.get((Object)"advanceOn"));
                    return result.success().build();
                }
                if (scanStatus.get("Status").equals("PENDING") && elapsedTime > Integer.parseInt((String)configMap.getOrDefault((Object)"maxPending", (Object)"30"))) {
                    this.logger.info("Scan reached max pending timeout, failing task for scan ID: " + scanId);
                    Thread.currentThread().interrupt();
                    return result.failed().build();
                }
                if (!scanStatus.get("Status").equals("COMPLETE") && elapsedTime > Integer.parseInt((String)configMap.getOrDefault((Object)"maxExecution", (Object)"120"))) {
                    this.logger.info("Scan reached max execution timeout, failing task for scan ID: " + scanId);
                    Thread.currentThread().interrupt();
                    return result.failed().build();
                }
                String checkInterval = (String)configMap.getOrDefault((Object)"checkInterval", (Object)"5");
                this.logger.debug("Sleeping for " + checkInterval + " minutes while scanning");
                try {
                    TimeUnit.MINUTES.sleep(Integer.parseInt(checkInterval));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                elapsedTime = elapsedTime + Integer.parseInt(checkInterval);
            }
            if (((String)scanStatus.get("Status")).equals("COMPLETE")) {
                List<ResourceVulnerability> queryFindings;
                this.logger.info("Successful InsightAppSec scan for " + this.appName + " application; Scan Config " + this.scanConfigName + ". Scan ID: " + scanId);
                if (Boolean.parseBoolean((String)configMap.get((Object)"findingsReportGeneration"))) {
                    List<ResourceVulnerability> allFindings = iasHelper.getFindings(scanId, "");
                    iasHelper.generateScanMetrics(allFindings, taskContext.getWorkingDirectory() + "/insightappsec-scan-metrics.json");
                    iasHelper.generateFindingsReport(allFindings, taskContext.getWorkingDirectory() + "/insightappsec-scan-findings.json");
                    TaskContext buildTaskContext = (TaskContext)Narrow.downTo((Object)taskContext, TaskContext.class);
                    if (buildTaskContext != null) {
                        this.publishArtifacts(buildTaskContext, "reports", taskContext.getWorkingDirectory());
                    }
                }
                if (Boolean.parseBoolean((String)configMap.get((Object)"vulnQueryEnforcement")) && (queryFindings = iasHelper.getFindings(scanId, (String)configMap.get((Object)"vulnQuery"))).size() > 0) {
                    this.logger.info("Search for scan ID " + scanId + " and query " + (String)configMap.get((Object)"vulnQuery") + " returned " + queryFindings.size() + " findings; failing build");
                    return result.failed().build();
                }
                return result.success().build();
            }
            this.logger.info("InsightAppSec scan failed for Scan ID " + scanId + ": " + scanStatus.get("Status"));
            return result.failed().build();
        }
        catch (InsightAppSecException iase) {
            this.logger.error("Invalid API key during scan initiation: " + iase.toString());
            Thread.currentThread().interrupt();
            return result.failedWithError().build();
        }
    }

    public String getName() {
        return "Rapid7 InsightAppSec";
    }

    private void publishArtifacts(TaskContext taskContext, String name, File directory) {
        this.logger.info("Publishing artifact(s) for scan");
        ArtifactDefinitionContextImpl artifact = new ArtifactDefinitionContextImpl(name, true, SecureToken.create());
        artifact.setCopyPattern("insightappsec-scan-*.json");
        ArtifactPublishingResult result = this.artifactManager.publish(taskContext.getBuildLogger(), taskContext.getBuildContext().getPlanResultKey(), directory, (ArtifactDefinitionContext)artifact, new Hashtable(), 1);
        taskContext.getBuildContext().getArtifactContext().addPublishingResult(result);
    }
}

