var jsr = undefined;
function drawChart() {
    var data = google.visualization.arrayToDataTable([
        ['Severity', 'Count'],
        ['High (' + jsr.summary.failedStats.high + ')', jsr.summary.failedStats.high],
        ['Medium (' + jsr.summary.failedStats.medium + ')', jsr.summary.failedStats.medium],
        ['Low (' + jsr.summary.failedStats.low + ')', jsr.summary.failedStats.low]
    ]);

    var options = {
        title: 'Qualys IaC Scan Failed Report',
        pieHole: 0.4,
        pieSliceText: 'value',
        slices: {
            0: {
                color: '#dc3912'
            },
            1: {
                color: '#ff9900'
            },
            2: {
                color: '#366eea'
            }
        },
        'chartArea': {
            'width': '100%',
            'height': '80%'
        },
    };

    var chart = new google.visualization.PieChart(document.getElementById('qualysIaCScanPieChart'));

    chart.draw(data, options);
}

function initResultTab(jsr) {
    debugger;
    if (!jsr) {
        jQuery('.no-scan-result').show();
        jQuery('.scan-result-page').hide();
        return;
    }
    jQuery('.no-scan-result').hide();
    if (jsr.summary.failedStats && !(jsr.summary.failedStats.high === 0 && jsr.summary.failedStats.medium === 0 && jsr.summary.failedStats.low === 0)) {
        google.charts.load('current', {
            'packages': ['corechart']
        });
        google.charts.setOnLoadCallback(drawChart);
        jQuery('#qualysIaCScanPieChart').removeClass('d-none');
        jQuery('.pie-chart-col').removeClass('d-none');
    } else {
        jQuery('.no-data-qualys-iac-pie-chart').removeClass('d-none');
    }
    var isFailedResultsOnly = (jsr.isFailedResultsOnly == undefined || jsr.isFailedResultsOnly == null ? false : jsr.isFailedResultsOnly);
    var failedControlId = [];
    tmp = '';
    jQuery.each(jsr.lstterraFormChecks, function(i, item) {
        var controlId = item.controlId;
        var controlName = item.controlName;
        var criticality = item.criticality;
        var filePath = item.filePath ? item.filePath : '';
        var resource = item.resource;
        var resultType = item.resultType === 'FAILED' ? '<span class="text-danger fw-bold">FAILED</span>' : '<span class="text-success fw-bold">PASSED</span>';
        tmp = tmp + "<tr class='"+(item.resultType === 'FAILED' && !isFailedResultsOnly ? 'bg-danger' : 'bg-normal')+"'><td class='col-1'>" + controlId + "</td><td>" + controlName + "</td><td>" + criticality + "</td><td>" + resultType + "</td><td>" + filePath + "</td><td> " + resource + " </td></tr>";
        if(item.resultType === 'FAILED') {
            failedControlId.push(controlId);
        }
    });
    if (tmp.trim().length > 0) {
        jQuery('.iac-posture-rows').append(tmp);
    }
    tmp = '';
    jQuery.each(jsr.lstremediation, function(i, item) {
        var controlId = item.controlId;
        var remediation = item.remediation;
        tmp = tmp + "<tr><td class='col-1'>" + controlId + "</td><td>" + remediation + "</td></tr>";
    });
    if (tmp.trim().length > 0) {
        jQuery('.iac-remediation-rows').append(tmp);
    }
    if (!jsr.lstterraFormChecks || jsr.lstterraFormChecks.length === 0) {
        jQuery('.iacposture-tab').addClass('d-none');
        jQuery('.no-data-iacposture-tab').removeClass('d-none');
    }

    if (!jsr.lstremediation || jsr.lstremediation.length === 0) {
        jQuery('.remediation-tab').addClass('d-none');
        jQuery('.no-data-remediation-tab').removeClass('d-none');
    }

    tmp = '';
    jQuery.each(jsr.lstParsingErrors, function(i, item) {
        var checkType = item.checkType;
        var parsingErrorLocation = item.parsingErrorLocation;
        tmp = tmp + "<tr><td class='col-1'>" + checkType + "</td><td>" + parsingErrorLocation + "</td></tr>";
    });
    if (tmp.trim().length > 0) {
        jQuery('.parsing-error-rows').append(tmp);
        jQuery('.parsing-error-tab').removeClass('d-none');
    }
    if (!jsr.lstParsingErrors || jsr.lstParsingErrors.length === 0) {
        jQuery('.parsing-error-tab').addClass('d-none');
    }
    jQuery('#iacposture,#remediation,#parsing-error').DataTable();
    if (jsr.summary) {
        jQuery('#scan-id').text(jsr.scanId);
        jQuery('#scan-name').text(jsr.scanName);
        jQuery('#scan-status').text(jsr.scanStatus);
        jQuery('.scan-info-row').removeClass('d-none');
        jQuery('#total-build-failure-control-count').text(jsr.summary.totalBuildFailureControlCount);
        jQuery('#out-of-build-failure-control-count').text(' of ' + jsr.summary.failed);

        if (jsr.appliedBuildSetting && jsr.lstterraFormChecks && jsr.lstterraFormChecks.length > 0) {
            var resURL = jQuery('#resURL').val();
            var cancel_icon = '<span class="aui-icon aui-icon-small aui-iconfont-cross-circle cancel-icon"></span>';
            var correct_icon = '<span class="aui-icon aui-icon-small aui-iconfont-approve"></span>';
            if (jsr.summary.highViolatesCriteria) {
                jQuery('.high-criteria-icon').html(cancel_icon);
            } else {
                jQuery('.high-criteria-icon').html(correct_icon);
            }
            if (jsr.summary.mediumViolatesCriteria) {
                jQuery('.medium-criteria-icon').html(cancel_icon);
            } else {
                jQuery('.medium-criteria-icon').html(correct_icon);
            }
            if (jsr.summary.lowViolatesCriteria) {
                jQuery('.low-criteria-icon').html(cancel_icon);
            } else {
                jQuery('.low-criteria-icon').html(correct_icon);
            }
        }
        if (jsr.appliedBuildSetting == false) {
            jQuery('#buildFailureCount').addClass('d-none');
        }
    }
    AJS.tabs.setup();
    jQuery('.scan-result-page').show();

}
jQuery(document).ready(function() {
    initResultTab(window.jsr);
});
AJS.$(document).on('click','#qualys-iac-scan-job-report',function(){
    initResultTab(window.jsr);
});