AJS.$(document).on('change','#buildFailureSetting',function(event){
     if(jQuery(this).is(":checked")) {
        jQuery('#dvbuildFailureSetting').show();
     }
     else{
         jQuery('#dvbuildFailureSetting').hide();
         jQuery('#buildFailureSettingHigh').val('0');
         jQuery('#buildFailureSettingMedium').val('0');
         jQuery('#buildFailureSettingLow').val('0');
     }
});
AJS.$(document).on('change','#timeoutSetting',function(event){
     if(jQuery(this).is(":checked")) {
        jQuery('#dvtimeoutSetting').show();
     }
     else{
        jQuery('#dvtimeoutSetting').hide();
        jQuery('#timoutSettingScanInterval').val('30');
        jQuery('#timoutSettingTotalJobCompletion').val('10');
     }
});
AJS.$(document).on("click", "#iac_test_connection", function (event) {
    jQuery('#iac_testConnectionMessage').html("");
    jQuery('#spinner').css({"display":"block"});
    restRequest("test_connection");
});
function restRequest(button) {
    if (!validateFields(button)) {
        if (button == "test_connection") {
            jQuery('#spinner').css({"display":"none"});
        }
    }
    var request = JSON.stringify(getInputData());
    var xhr = createRestRequest("POST", "/rest/iac_qualys/1.0/test/iac_connection");
    if (!xhr) {
        console.log("Request Failed");
        return;
    }
    xhr.onload = function () {
        var parsed = JSON.parse(xhr.responseText);
        if (xhr.status == 200) {
            if (button == "test_connection") {
                jQuery('#iac_testConnectionMessage').css('color', 'green');
                jQuery('#iac_testConnectionMessage').html(parsed.response);
            }
        }
        else {
            if (button == "test_connection") {
                jQuery('#iac_testConnectionMessage').css('color', '#d22020');
                jQuery('#iac_testConnectionMessage').html(parsed.response);
            }
        }
        jQuery('#spinner').css({"display":"none"});
    };
    xhr.onerror = function () {
        console.log('There was an error!');
    };
    xhr.setRequestHeader("Content-Type", "application/json");
    xhr.send(request);
}

function validateFields(button) {
    if (button == "test_connection") {
        var messageElement = jQuery('#iac_testConnectionMessage');
    }
    if (jQuery('#iac_platFormURL').val().length < 1) {
        messageElement.text('Platform URL must not be empty');
        messageElement.css('color', '#d22020');
        return false;
    } else if (jQuery('#iac_userName').val().length < 1) {
        messageElement.text('Username must not be empty');
        messageElement.css('color', '#d22020');
        return false;
    } else if (jQuery('#iac_password').val().length < 1) {
        messageElement.text('Password must not be empty');
        messageElement.css('color', '#d22020');
        return false;
    }
    return true;
}

function createRestRequest(method, url) {
    var resolvedUrl = AJS.contextPath() + url;
    var xhr = new XMLHttpRequest();
    if ("withCredentials" in xhr) {
        xhr.open(method, resolvedUrl, true);
    } else if (typeof XDomainRequest != "undefined") {
        xhr = new XDomainRequest();
        xhr.open(method, resolvedUrl);
    } else {
        xhr = null;
    }
    return xhr;
}
function getInputData() {
    return {
        "iac_platFormURL": jQuery("#iac_platFormURL").val(),
        "iac_userName": jQuery('#iac_userName').val(),
        "iac_password": jQuery('#iac_password').val()
    };
}
