/*
 * Decompiled with CFR 0.152.
 */
package lombok.launch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShadowClassLoader
extends ClassLoader {
    private static final String SELF_NAME = "lombok/launch/ShadowClassLoader.class";
    private static final ConcurrentMap<String, Class<?>> highlanderMap = new ConcurrentHashMap();
    private final String SELF_BASE;
    private final File SELF_BASE_FILE;
    private final int SELF_BASE_LENGTH;
    private final List<File> override = new ArrayList<File>();
    private final String sclSuffix;
    private final List<String> parentExclusion = new ArrayList<String>();
    private final List<String> highlanders = new ArrayList<String>();
    private final Map<String, Object> mapJarPathToTracker = new HashMap<String, Object>();
    private static final Map<Object, String> mapTrackerToJarPath = new WeakHashMap<Object, String>();
    private static final Map<Object, Set<String>> mapTrackerToJarContents = new WeakHashMap<Object, Set<String>>();

    ShadowClassLoader(ClassLoader source2, String sclSuffix, String selfBase, List<String> parentExclusion, List<String> highlanders) {
        super(source2);
        this.sclSuffix = sclSuffix;
        if (parentExclusion != null) {
            for (String pe : parentExclusion) {
                if (!(pe = pe.replace(".", "/")).endsWith("/")) {
                    pe = String.valueOf(pe) + "/";
                }
                this.parentExclusion.add(pe);
            }
        }
        if (highlanders != null) {
            for (String hl : highlanders) {
                this.highlanders.add(hl);
            }
        }
        if (selfBase != null) {
            this.SELF_BASE = selfBase;
            this.SELF_BASE_LENGTH = selfBase.length();
        } else {
            String decoded;
            String sclClassStr;
            URL sclClassUrl = ShadowClassLoader.class.getResource("ShadowClassLoader.class");
            String string = sclClassStr = sclClassUrl == null ? null : sclClassUrl.toString();
            if (sclClassStr == null || !sclClassStr.endsWith(SELF_NAME)) {
                ClassLoader cl = ShadowClassLoader.class.getClassLoader();
                throw new RuntimeException("ShadowLoader can't find itself. SCL loader type: " + (cl == null ? "*NULL*" : cl.getClass().toString()));
            }
            this.SELF_BASE_LENGTH = sclClassStr.length() - SELF_NAME.length();
            try {
                decoded = URLDecoder.decode(sclClassStr.substring(0, this.SELF_BASE_LENGTH), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError("UTF-8 not available");
            }
            this.SELF_BASE = decoded;
        }
        this.SELF_BASE_FILE = this.SELF_BASE.startsWith("jar:file:") && this.SELF_BASE.endsWith("!/") ? new File(this.SELF_BASE.substring(9, this.SELF_BASE.length() - 2)) : (this.SELF_BASE.startsWith("file:") ? new File(this.SELF_BASE.substring(5)) : new File(this.SELF_BASE));
        String scl = System.getProperty("shadow.override." + sclSuffix);
        if (scl != null && !scl.isEmpty()) {
            String[] stringArray = scl.split("\\s*" + (File.pathSeparatorChar == ';' ? ";" : ":") + "\\s*");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.endsWith("/*") || part.endsWith(String.valueOf(File.separator) + "*")) {
                    this.addOverrideJarDir(part.substring(0, part.length() - 2));
                } else {
                    this.addOverrideClasspathEntry(part);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getOrMakeJarListing(String absolutePathToJar) {
        Map<Object, String> map = mapTrackerToJarPath;
        synchronized (map) {
            Object ourTracker = this.mapJarPathToTracker.get(absolutePathToJar);
            if (ourTracker != null) {
                return mapTrackerToJarContents.get(ourTracker);
            }
            for (Map.Entry<Object, String> entry : mapTrackerToJarPath.entrySet()) {
                if (!entry.getValue().equals(absolutePathToJar)) continue;
                Object otherTracker = entry.getKey();
                this.mapJarPathToTracker.put(absolutePathToJar, otherTracker);
                return mapTrackerToJarContents.get(otherTracker);
            }
            Object newTracker = new Object();
            Set<String> jarMembers = this.getJarMemberSet(absolutePathToJar);
            mapTrackerToJarContents.put(newTracker, jarMembers);
            mapTrackerToJarPath.put(newTracker, absolutePathToJar);
            this.mapJarPathToTracker.put(absolutePathToJar, newTracker);
            return jarMembers;
        }
    }

    private Set<String> getJarMemberSet(String absolutePathToJar) {
        try {
            int shiftBits = 1;
            JarFile jar = new JarFile(absolutePathToJar);
            int jarSizePower2 = Integer.highestOneBit(jar.size());
            if (jarSizePower2 != jar.size()) {
                jarSizePower2 <<= 1;
            }
            if (jarSizePower2 == 0) {
                jarSizePower2 = 1;
            }
            HashSet<String> jarMembers = new HashSet<String>(jarSizePower2 >> shiftBits, 1 << shiftBits);
            try {
                try {
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        if (jarEntry.isDirectory()) continue;
                        jarMembers.add(jarEntry.getName());
                    }
                }
                catch (Exception exception) {
                    jar.close();
                }
            }
            finally {
                jar.close();
            }
            return jarMembers;
        }
        catch (Exception exception) {
            return Collections.emptySet();
        }
    }

    private URL getResourceFromLocation(String name, String altName, File location) {
        File absoluteFile;
        if (location.isDirectory()) {
            try {
                File f;
                if (altName != null && (f = new File(location, altName)).isFile() && f.canRead()) {
                    return f.toURI().toURL();
                }
                f = new File(location, name);
                if (f.isFile() && f.canRead()) {
                    return f.toURI().toURL();
                }
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (!location.isFile() || !location.canRead()) {
            return null;
        }
        try {
            absoluteFile = location.getCanonicalFile();
        }
        catch (Exception exception) {
            absoluteFile = location.getAbsoluteFile();
        }
        Set<String> jarContents = this.getOrMakeJarListing(absoluteFile.getAbsolutePath());
        String absoluteUri = absoluteFile.toURI().toString();
        try {
            if (jarContents.contains(altName)) {
                return new URI("jar:" + absoluteUri + "!/" + altName).toURL();
            }
        }
        catch (Exception exception) {}
        try {
            if (jarContents.contains(name)) {
                return new URI("jar:" + absoluteUri + "!/" + name).toURL();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private boolean inOwnBase(URL item, String name) {
        if (item == null) {
            return false;
        }
        String itemString = item.toString();
        return itemString.length() == this.SELF_BASE_LENGTH + name.length() && this.SELF_BASE.regionMatches(0, itemString, 0, this.SELF_BASE_LENGTH);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        URL fromSelf;
        String altName = null;
        if (name.endsWith(".class")) {
            altName = String.valueOf(name.substring(0, name.length() - 6)) + ".SCL." + this.sclSuffix;
        }
        Vector<URL> vector = new Vector<URL>();
        for (File ce : this.override) {
            URL url = this.getResourceFromLocation(name, altName, ce);
            if (url == null) continue;
            vector.add(url);
        }
        if (this.override.isEmpty() && (fromSelf = this.getResourceFromLocation(name, altName, this.SELF_BASE_FILE)) != null) {
            vector.add(fromSelf);
        }
        Enumeration<URL> sec = super.getResources(name);
        while (sec.hasMoreElements()) {
            URL item = sec.nextElement();
            if (this.inOwnBase(item, name)) continue;
            vector.add(item);
        }
        if (altName != null) {
            Enumeration<URL> tern = super.getResources(altName);
            while (tern.hasMoreElements()) {
                URL item = tern.nextElement();
                if (this.inOwnBase(item, altName)) continue;
                vector.add(item);
            }
        }
        return vector.elements();
    }

    @Override
    public URL getResource(String name) {
        return this.getResource_(name, false);
    }

    private URL getResource_(String name, boolean noSuper) {
        URL res;
        String altName = null;
        if (name.endsWith(".class")) {
            altName = String.valueOf(name.substring(0, name.length() - 6)) + ".SCL." + this.sclSuffix;
        }
        for (File ce : this.override) {
            URL url = this.getResourceFromLocation(name, altName, ce);
            if (url == null) continue;
            return url;
        }
        if (!this.override.isEmpty()) {
            if (noSuper) {
                return null;
            }
            if (altName != null) {
                try {
                    URL res2 = this.getResourceSkippingSelf(altName);
                    if (res2 != null) {
                        return res2;
                    }
                }
                catch (IOException iOException) {}
            }
            try {
                return this.getResourceSkippingSelf(name);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        URL url = this.getResourceFromLocation(name, altName, this.SELF_BASE_FILE);
        if (url != null) {
            return url;
        }
        if (altName != null && (res = super.getResource(altName)) != null && (!noSuper || this.inOwnBase(res, altName))) {
            return res;
        }
        res = super.getResource(name);
        if (res != null && (!noSuper || this.inOwnBase(res, name))) {
            return res;
        }
        return null;
    }

    private boolean exclusionListMatch(String name) {
        for (String pe : this.parentExclusion) {
            if (!name.startsWith(pe)) continue;
            return true;
        }
        return false;
    }

    private URL getResourceSkippingSelf(String name) throws IOException {
        URL candidate = super.getResource(name);
        if (candidate == null) {
            return null;
        }
        if (!this.inOwnBase(candidate, name)) {
            return candidate;
        }
        Enumeration<URL> en = super.getResources(name);
        while (en.hasMoreElements()) {
            candidate = en.nextElement();
            if (this.inOwnBase(candidate, name)) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> alreadyDefined;
        Class<?> c;
        block19: {
            byte[] b;
            Class c2;
            Class<?> alreadyLoaded = this.findLoadedClass(name);
            if (alreadyLoaded != null) {
                return alreadyLoaded;
            }
            if (this.highlanders.contains(name) && (c2 = (Class)highlanderMap.get(name)) != null) {
                return c2;
            }
            String fileNameOfClass = String.valueOf(name.replace(".", "/")) + ".class";
            URL res = this.getResource_(fileNameOfClass, true);
            if (res == null) {
                if (!this.exclusionListMatch(fileNameOfClass)) {
                    return super.loadClass(name, resolve);
                }
                throw new ClassNotFoundException(name);
            }
            int p = 0;
            try {
                InputStream in = res.openStream();
                try {
                    int r;
                    b = new byte[65536];
                    while ((r = in.read(b, p, b.length - p)) != -1) {
                        if ((p += r) != b.length) continue;
                        byte[] nb = new byte[b.length * 2];
                        System.arraycopy(b, 0, nb, 0, p);
                        b = nb;
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException("I/O exception reading class " + name, e);
            }
            try {
                c = this.defineClass(name, b, 0, p);
            }
            catch (LinkageError e) {
                Class alreadyDefined2;
                if (this.highlanders.contains(name) && (alreadyDefined2 = (Class)highlanderMap.get(name)) != null) {
                    return alreadyDefined2;
                }
                try {
                    c = this.findLoadedClass(name);
                }
                catch (LinkageError linkageError) {
                    throw e;
                }
                if (c != null) break block19;
                throw e;
            }
        }
        if (this.highlanders.contains(name) && (alreadyDefined = highlanderMap.putIfAbsent(name, c)) != null) {
            c = alreadyDefined;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public void addOverrideJarDir(String dir) {
        File f = new File(dir);
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File j = fileArray[n2];
            if (j.getName().toLowerCase().endsWith(".jar") && j.canRead() && j.isFile()) {
                this.override.add(j);
            }
            ++n2;
        }
    }

    public void addOverrideClasspathEntry(String entry) {
        this.override.add(new File(entry));
    }
}

