/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.iac.scan.bamboo.plugin.ui;

import com.atlassian.bamboo.build.PlanResultsAction;
import com.atlassian.bamboo.chains.ChainResultsSummaryImpl;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResultTabView
extends PlanResultsAction {
    private static final Logger log = Logger.getLogger(ResultTabView.class.getName());
    private Map<String, String> reportData = new HashMap<String, String>();

    public String execute() throws Exception {
        String result = super.execute();
        ResultsSummary summary = this.getResultsSummary();
        if (summary instanceof ChainResultsSummaryImpl) {
            ChainResultsSummaryImpl chainResults = (ChainResultsSummaryImpl)summary;
            log.log(Level.FINE, "Try to get report link for ChainResultsSummaryImpl");
            List resultList = chainResults.getStageResults();
            for (ChainStageResult chainResult : resultList) {
                Set resultSet = chainResult.getBuildResults();
                for (BuildResultsSummary sum : resultSet) {
                    Map customBuildData = sum.getCustomBuildData();
                    for (String key : customBuildData.keySet()) {
                        if (!key.startsWith("result")) continue;
                        log.log(Level.FINE, "Found report link for master =" + key);
                        this.reportData.put("result", (String)customBuildData.get(key));
                    }
                }
            }
        }
        return result;
    }

    public Map<String, String> getReportData() {
        return this.reportData;
    }

    public void setReportData(Map<String, String> reportData) {
        this.reportData = reportData;
    }
}

