/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.iac.scan.bamboo.plugin.service.impl;

import com.qualys.iac.scan.bamboo.plugin.model.Checks;
import com.qualys.iac.scan.bamboo.plugin.model.FailedStats;
import com.qualys.iac.scan.bamboo.plugin.model.ParsingError;
import com.qualys.iac.scan.bamboo.plugin.model.QualysBuildConfiguration;
import com.qualys.iac.scan.bamboo.plugin.model.QualysConstants;
import com.qualys.iac.scan.bamboo.plugin.model.Remediation;
import com.qualys.iac.scan.bamboo.plugin.model.ScanResult;
import com.qualys.iac.scan.bamboo.plugin.model.Summary;
import com.qualys.iac.scan.bamboo.plugin.model.Util;
import com.qualys.iac.scan.bamboo.plugin.service.IQualysService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QualysServiceImpl
implements IQualysService {
    private static final Util util = Util.getInstance();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUserAuthenticated(QualysBuildConfiguration qbc) {
        OkHttpClient okHttpClient = new OkHttpClient();
        try {
            Request request = util.addCommonConfigurationToHttpRequest(qbc).url(qbc.getAuthenticationURL()).get().build();
            try (Response response = okHttpClient.newCall(request).execute();){
                boolean bl = response.isSuccessful();
                return bl;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static boolean isValidPath(String folderPath) {
        File file = new File(folderPath);
        return file != null && (file.isDirectory() || file.isFile()) && file.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> postZip(String workspacePath, QualysBuildConfiguration qbc) {
        Response response = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<String> lstDirs = qbc.getFormattedDirectories();
        ArrayList<Path> lstPaths = new ArrayList<Path>();
        ArrayList<Object> lstExtractedFolders = new ArrayList<Object>();
        HashSet<String> lstEntries = new HashSet<String>();
        ArrayList<String> lstfiles = new ArrayList<String>();
        try {
            Object extractFolderPath;
            for (int i = 0; i < lstDirs.size(); ++i) {
                String folderPath = lstDirs.get(i);
                if (QualysServiceImpl.isValidPath(folderPath)) {
                    if (folderPath.endsWith(".zip")) {
                        extractFolderPath = util.getRandomZipPath();
                        new File((String)extractFolderPath).mkdirs();
                        lstExtractedFolders.add(extractFolderPath);
                        util.extractFolder(folderPath, (String)extractFolderPath);
                        lstPaths.add(Paths.get((String)extractFolderPath, new String[0]));
                        continue;
                    }
                    lstPaths.add(Paths.get(new File(folderPath).getCanonicalPath(), new String[0]));
                    continue;
                }
                if (!QualysServiceImpl.isValidPath(folderPath = util.concatPath(workspacePath, folderPath))) continue;
                lstPaths.add(Paths.get(new File(folderPath).getCanonicalPath(), new String[0]));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(baos);
            extractFolderPath = null;
            try {
                for (Path path : lstPaths) {
                    if (path.toFile().isDirectory()) {
                        util.addFolderToZip(path.toFile(), zipOutputStream, "", lstEntries, lstfiles);
                        continue;
                    }
                    util.addFileToZip(path.toFile(), zipOutputStream, "", lstEntries, lstfiles);
                }
                zipOutputStream.flush();
                zipOutputStream.close();
                baos.close();
                byte[] bytes = baos.toByteArray();
                if (bytes.length == 0 || lstfiles.isEmpty()) {
                    map.put("http_post_failed", true);
                    map.put(QualysConstants.HTTP_POST_FAILED_REASON, QualysConstants.NO_IAC_FILES_MESSAGE);
                    HashMap<String, Object> hashMap = map;
                    return hashMap;
                }
                float f = (float)bytes.length / 1048576.0f;
                if (f > QualysConstants.ZIP_FILE_MAX_SIZE) {
                    map.put("http_post_failed", true);
                    map.put(QualysConstants.HTTP_POST_FAILED_REASON, QualysConstants.ZIP_FILE_MAX_SIZE_MESSAGE);
                    HashMap<String, Object> hashMap = map;
                    return hashMap;
                }
            }
            catch (Throwable bytes) {
                extractFolderPath = bytes;
                throw bytes;
            }
            finally {
                if (zipOutputStream != null) {
                    if (extractFolderPath != null) {
                        try {
                            zipOutputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)extractFolderPath).addSuppressed(throwable);
                        }
                    } else {
                        zipOutputStream.close();
                    }
                }
            }
            String fileName = util.appendTimestampToFile("QUALYS", ".zip");
            File directoryPath = new File(System.getProperty("java.io.tmpdir"));
            String prefix = fileName.substring(0, fileName.lastIndexOf("."));
            String string = FilenameUtils.getExtension((String)fileName);
            File tempFile = File.createTempFile(prefix, string, directoryPath);
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])baos.toByteArray());
            MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("name", qbc.getScanName()).addFormDataPart("showOnlyFailedControls", qbc.isFailedResultsOnly() + "").addFormDataPart("file", util.appendTimestampToFile("QUALYS", ".zip"), RequestBody.create(MediaType.parse("application/zip"), tempFile)).build();
            OkHttpClient okHttpClient = util.addCommonConfigurationToHttpClient(qbc);
            Request request = util.addCommonConfigurationToHttpRequest(qbc).url(qbc.getPostScanURL()).header("Content-type", "application/zip").post(requestBody).build();
            response = okHttpClient.newCall(request).execute();
            map.put("http_post_failed", false);
            tempFile.delete();
        }
        catch (IOException ex) {
            map.put("http_post_failed", true);
            map.put(QualysConstants.HTTP_POST_FAILED_REASON, ex.toString());
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (Boolean.getBoolean(map.get("http_post_failed").toString())) return map;
        try {
            map.put("scanUuid", new JSONObject(response.body().string()).get("scanUuid").toString());
            return map;
        }
        catch (IOException | JSONException ex) {
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return map;
    }

    @Override
    public ScanResult mapScanResult(String json, FailedStats failedStatsFromBuildConfiguration) {
        Summary summaryObj = null;
        try {
            int i;
            JSONObject jsonObject = new JSONObject(json.trim());
            JSONArray results = jsonObject.getJSONArray("result");
            ArrayList<Checks> lstChecks = new ArrayList<Checks>();
            ArrayList<Remediation> lstRemediation = new ArrayList<Remediation>();
            ArrayList<ParsingError> lstParsingErrors = new ArrayList<ParsingError>();
            ArrayList<JSONArray> lstCheckList = new ArrayList<JSONArray>();
            int totalBuildFailureControlCount = 0;
            int tmpPassed = 0;
            int tmpFailed = 0;
            int tmpHigh = 0;
            int tmpMedium = 0;
            int tmpLow = 0;
            int tmpSkipped = 0;
            int tmpParsingError = 0;
            boolean isLowViolatesCriteria = false;
            boolean isMediumViolatesCriteria = false;
            boolean isHighViolatesCriteria = false;
            for (i = 0; i < results.length(); ++i) {
                JSONObject summary;
                JSONObject failedStats;
                JSONObject tmp = results.getJSONObject(i);
                JSONObject result = tmp.getJSONObject("results");
                JSONArray passedChecks = result.optJSONArray("passedChecks");
                JSONArray failedChecks = result.optJSONArray("failedChecks");
                JSONArray parsingErrors = result.optJSONArray("parsingErrors");
                String checkType = tmp.getString("checkType");
                if (passedChecks != null) {
                    lstCheckList.add(passedChecks);
                }
                if (failedChecks != null) {
                    lstCheckList.add(failedChecks);
                }
                if (parsingErrors != null) {
                    StringBuilder parsingErrorBuilder = new StringBuilder();
                    for (int k = 0; k < parsingErrors.length(); ++k) {
                        parsingErrorBuilder.append(parsingErrors.get(k));
                        ParsingError parsingError = new ParsingError(checkType, parsingErrorBuilder.toString());
                        lstParsingErrors.add(parsingError);
                    }
                }
                if ((failedStats = (summary = tmp.getJSONObject("summary")).getJSONObject("failedStats")) != null) {
                    tmpMedium += failedStats.getInt("medium");
                    tmpLow += failedStats.getInt("low");
                    if ((tmpHigh += failedStats.getInt("high")) > failedStatsFromBuildConfiguration.getHigh()) {
                        isHighViolatesCriteria = true;
                        totalBuildFailureControlCount += tmpHigh;
                    }
                    if (tmpMedium > failedStatsFromBuildConfiguration.getMedium()) {
                        isMediumViolatesCriteria = true;
                        totalBuildFailureControlCount += tmpMedium;
                    }
                    if (tmpLow > failedStatsFromBuildConfiguration.getLow()) {
                        isLowViolatesCriteria = true;
                        totalBuildFailureControlCount += tmpLow;
                    }
                }
                tmpPassed += summary.getInt("passed");
                tmpFailed += summary.getInt("failed");
                tmpSkipped += summary.getInt("skipped");
                tmpParsingError += summary.getInt("parsingErrors");
            }
            for (i = 0; i < lstCheckList.size(); ++i) {
                for (int j = 0; j < ((JSONArray)lstCheckList.get(i)).length(); ++j) {
                    JSONObject item = ((JSONArray)lstCheckList.get(i)).getJSONObject(j);
                    JSONObject checkResult = item.getJSONObject("checkResult");
                    String controlId = item.getString("checkId");
                    String controlName = item.getString("checkName");
                    String criticality = item.getString("criticality");
                    String passOrFailResult = checkResult.getString("result");
                    String filePath = item.getString("filePath");
                    String resource = item.getString("resource");
                    if (passOrFailResult.equalsIgnoreCase("FAILED")) {
                        Remediation remediation = new Remediation(controlId, item.getString("remediation"));
                        lstRemediation.add(remediation);
                    }
                    lstChecks.add(new Checks(controlId, controlName, criticality, passOrFailResult, filePath, resource));
                }
            }
            lstChecks.sort(Comparator.comparing(Checks::getResource).thenComparing(Checks::getControlId));
            summaryObj = new Summary(tmpPassed, tmpFailed, new FailedStats(tmpHigh, tmpMedium, tmpLow), tmpSkipped, tmpParsingError, isHighViolatesCriteria, isMediumViolatesCriteria, isLowViolatesCriteria, totalBuildFailureControlCount);
            return new ScanResult(summaryObj, lstChecks, lstRemediation, lstParsingErrors);
        }
        catch (JSONException jSONException) {
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, jSONException);
            return null;
        }
    }

    @Override
    public String getScanStatus(String scanUuid, QualysBuildConfiguration qbc) {
        try {
            Request request = util.addCommonConfigurationToHttpRequest(qbc).url(qbc.getScanStatusURL(scanUuid)).get().build();
            OkHttpClient okHttpClient = util.addCommonConfigurationToHttpClient(qbc);
            Response response = okHttpClient.newCall(request).execute();
            String responseBody = response.body().string();
            return StringUtils.isEmpty((CharSequence)responseBody) ? null : this.getScanStatus(responseBody);
        }
        catch (IOException ex) {
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private String getScanStatus(String body) {
        try {
            JSONArray jSONArray = (JSONArray)new JSONObject(body).get("content");
            if (jSONArray.length() > 0) {
                return new JSONObject(jSONArray.get(0).toString()).getString("status");
            }
        }
        catch (JSONException jSONException) {
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, jSONException);
        }
        return null;
    }

    @Override
    public String getScanResult(String scanUuid, QualysBuildConfiguration qbc) {
        try {
            Request request = util.addCommonConfigurationToHttpRequest(qbc).url(qbc.getScanResultURL(scanUuid)).get().build();
            OkHttpClient okHttpClient = util.addCommonConfigurationToHttpClient(qbc);
            Response response = okHttpClient.newCall(request).execute();
            String responseBody = response.body().string();
            return StringUtils.isEmpty((CharSequence)responseBody) ? null : responseBody;
        }
        catch (IOException ex) {
            Logger.getLogger(QualysServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public boolean checkBuildFailed(FailedStats failedStatsFromScanResult, FailedStats failedStatsFromBuildConfiguration) {
        if (failedStatsFromScanResult.getHigh() > failedStatsFromBuildConfiguration.getHigh()) {
            return true;
        }
        if (failedStatsFromScanResult.getMedium() > failedStatsFromBuildConfiguration.getMedium()) {
            return true;
        }
        return failedStatsFromScanResult.getLow() > failedStatsFromBuildConfiguration.getLow();
    }
}

