/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.iac.scan.bamboo.plugin.restresource;

import com.qualys.iac.scan.bamboo.plugin.model.QualysBuildConfiguration;
import com.qualys.iac.scan.bamboo.plugin.service.impl.QualysServiceImpl;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.map.HashedMap;

@Path(value="/")
public class QualysRestResource {
    private static final Logger logger = Logger.getLogger(QualysRestResource.class.getName());
    private static final String xml10pattern = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
    private Map<String, String> platformObj;

    @POST
    @Path(value="test/iac_connection")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response testConnection(Map<Object, Object> credentials) {
        HashedMap resp = new HashedMap();
        try {
            QualysBuildConfiguration qbc = new QualysBuildConfiguration((String)credentials.get("iac_platFormURL"), (String)credentials.get("iac_userName"), (String)credentials.get("iac_password"));
            QualysServiceImpl iQualysService = new QualysServiceImpl();
            if (iQualysService.isUserAuthenticated(qbc)) {
                resp.put("response", "Test Connection Successful!");
            } else {
                resp.put("response", "Unable to authenticate user with api server!");
            }
            return Response.status((int)200).entity((Object)resp).build();
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            logger.log(Level.INFO, e.getMessage(), e.getCause());
            resp.put("response", "Error testing connection to Qualys server. " + e.getMessage());
            return Response.status((int)500).entity((Object)resp).build();
        }
    }
}

