/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.iac.scan.bamboo.plugin.model;

import com.qualys.iac.scan.bamboo.plugin.model.QualysBuildConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public final class Util {
    private static Util util = null;
    public static final String EMPTY_BASE_PATH = "";

    private Util() {
    }

    public static Util getInstance() {
        if (util == null) {
            util = new Util();
        }
        return util;
    }

    public Request.Builder addCommonConfigurationToHttpRequest(QualysBuildConfiguration qbc) {
        return new Request.Builder().addHeader("Authorization", qbc.getBasicAuthToken()).addHeader("Accept", "application/json");
    }

    public OkHttpClient addCommonConfigurationToHttpClient(QualysBuildConfiguration qbc) {
        return new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.MINUTES).build();
    }

    public String concatPath(String firstPath, String secondPath) {
        return firstPath.concat(File.separator).concat(secondPath);
    }

    public String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getRandomZipPath() {
        String uuid = UUID.randomUUID().toString();
        return util.concatPath(this.getTempDirectory(), uuid);
    }

    public String appendTimestampToFile(String fileName, String extension) {
        return fileName.concat("_").concat(Instant.now().getEpochSecond() + EMPTY_BASE_PATH).concat(extension);
    }

    public void extractFolder(String zipFile, String extractFolder) {
        try {
            int BUFFER = 2048;
            File file = new File(zipFile);
            ZipFile zip2 = new ZipFile(file);
            String newPath = extractFolder;
            new File(newPath).mkdir();
            Enumeration<? extends ZipEntry> zipFileEntries = zip2.entries();
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(newPath, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zip2.getInputStream(entry));
                Throwable throwable = null;
                try {
                    int currentByte;
                    byte[] data = new byte[BUFFER];
                    FileOutputStream fos = new FileOutputStream(destFile);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
                    while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                        dest.write(data, 0, currentByte);
                    }
                    dest.flush();
                    dest.close();
                    fos.close();
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            zip2.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getRenamedPath(String path, String basePath, File file, Set<String> lstEntries) {
        if (lstEntries.contains(path)) {
            return util.concatPath(basePath.concat(this.appendTimestampToFile(file.getName(), FilenameUtils.getExtension((String)file.getName()))), EMPTY_BASE_PATH);
        }
        return path;
    }

    public void addFileToZip(File file, ZipOutputStream zip2, String basePath, Set<String> lstEntries, List<String> lstfiles) {
        try {
            if (Util.isIaCScanFile(file.getName()) && file.length() > 0L) {
                String path = basePath + file.getName();
                path = this.getRenamedPath(path, basePath, file, lstEntries);
                lstEntries.add(path);
                ZipEntry zipEntry = new ZipEntry(path);
                zip2.putNextEntry(zipEntry);
                IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)zip2);
                zip2.closeEntry();
                lstfiles.add(file.getName());
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addFolderToZip(File folder, ZipOutputStream zout, String basePath, Set<String> lstEntries, List<String> lstfiles) throws IOException {
        File[] files;
        for (File file : files = folder.listFiles()) {
            if (file.isDirectory()) {
                String path = util.concatPath(basePath.concat(file.getName()), EMPTY_BASE_PATH);
                path = this.getRenamedPath(path, basePath, file, lstEntries);
                lstEntries.add(path);
                zout.putNextEntry(new ZipEntry(path));
                this.addFolderToZip(file, zout, path, lstEntries, lstfiles);
                zout.closeEntry();
                continue;
            }
            this.addFileToZip(file, zout, basePath, lstEntries, lstfiles);
        }
    }

    public static boolean isIaCScanFile(String str) {
        String regex = "([^\\s]+(\\.(?i)(tf|yml|yaml|json|template|TF|YML|YAML|JSON|TEMPLATE))$)";
        Pattern p = Pattern.compile(regex);
        if (str == null) {
            return false;
        }
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public String correctPath(String path) {
        return path.replaceAll("\\.{2,}", EMPTY_BASE_PATH).replaceAll("[\\/]+", "/").replaceAll("[\\\\]+", "\\\\");
    }
}

