/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.iac.scan.bamboo.plugin.model;

import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QualysBuildConfiguration {
    private String platformURL;
    private String userName;
    private String password;
    private boolean isFailedResultsOnly;
    private String scanName;
    private String scanDirectories;
    public static final String COMMA_SEPARATOR = ",";
    private static final String QUALYS_SCAN_SUB_URL = "/cloudview-api/rest/v1/iac/scan";
    private static final String QUALYS_RESULT_SUB_URL = "/cloudview-api/rest/v1/iac/scanResult?scanUuid=";
    private static final String QUALYS_SCAN_LIST_WITH_SCAN_UID_SUB_URL = "/cloudview-api/rest/v1/iac/getScanList?filter=scanUuid:";
    private static final String QUALYS_SCAN_LIST_SUB_URL = "/cloudview-api/rest/v1/iac/getScanList";

    public QualysBuildConfiguration() {
    }

    public QualysBuildConfiguration(String platformURL, String userName, String password) {
        this.platformURL = platformURL;
        this.userName = userName;
        this.password = password;
    }

    public QualysBuildConfiguration(String platformURL, String userName, String password, boolean isFailedResultsOnly, String scanName, String scanDirectories) {
        this.platformURL = platformURL;
        this.userName = userName;
        this.password = password;
        this.isFailedResultsOnly = isFailedResultsOnly;
        this.scanName = scanName;
        this.scanDirectories = scanDirectories;
    }

    public String getPlatformURL() {
        return this.platformURL.replaceAll("/$", "");
    }

    public List<String> getFormattedDirectories() {
        return Arrays.asList(this.getScanDirectories().split(COMMA_SEPARATOR));
    }

    public String getBasicAuthToken() {
        return "Basic " + Base64.getEncoder().encodeToString((this.userName + ":" + this.password).getBytes());
    }

    public String getPostScanURL() {
        return this.getPlatformURL() + QUALYS_SCAN_SUB_URL;
    }

    public String getScanResultURL(String scanUuid) {
        return this.getPlatformURL() + QUALYS_RESULT_SUB_URL + scanUuid;
    }

    public String getScanStatusURL(String scanUuid) {
        return this.getPlatformURL() + QUALYS_SCAN_LIST_WITH_SCAN_UID_SUB_URL + scanUuid;
    }

    public String getAuthenticationURL() {
        return this.getPlatformURL() + QUALYS_SCAN_LIST_SUB_URL;
    }

    public String correctURL(String url) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url.replaceAll("(?<!(http:|https:))/+", "/");
    }

    public boolean isCredentialsBlank() {
        return StringUtils.isEmpty((CharSequence)this.getPlatformURL()) || StringUtils.isEmpty((CharSequence)this.getUserName()) || StringUtils.isEmpty((CharSequence)this.getPassword());
    }

    public void setPlatformURL(String platformURL) {
        this.platformURL = platformURL;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setFailedResultsOnly(boolean isFailedResultsOnly) {
        this.isFailedResultsOnly = isFailedResultsOnly;
    }

    public boolean isFailedResultsOnly() {
        return this.isFailedResultsOnly;
    }

    public void setScanName(String scanName) {
        this.scanName = scanName;
    }

    public String getScanName() {
        return this.scanName;
    }

    public void setScanDirectories(String scanDirectories) {
        this.scanDirectories = scanDirectories;
    }

    public String getScanDirectories() {
        return this.scanDirectories;
    }
}

