/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.iac.scan.bamboo.plugin.impl;

import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.qualys.iac.scan.bamboo.plugin.impl.LogHelper;
import com.qualys.iac.scan.bamboo.plugin.model.FailedStats;
import com.qualys.iac.scan.bamboo.plugin.model.QualysBuildConfiguration;
import com.qualys.iac.scan.bamboo.plugin.model.QualysConstants;
import com.qualys.iac.scan.bamboo.plugin.model.ScanResult;
import com.qualys.iac.scan.bamboo.plugin.model.Util;
import com.qualys.iac.scan.bamboo.plugin.service.impl.QualysServiceImpl;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ScannerTask
implements TaskType {
    private static final String SA_DIR = ".sa";
    private LogHelper logger;
    private ArtifactManager artifactManager;
    private CapabilityContext capabilityContext;
    private ProcessService processService;
    private static final String FINAL_STATUS = "FINISHED";
    private static final String ERROR_STATUS = "ERROR";

    public ScannerTask(@ComponentImport I18nBeanFactory i18nBeanFactory, @ComponentImport ProcessService processService, @ComponentImport ArtifactManager artifactManager, @ComponentImport CapabilityContext capabilityContext) {
        this.logger = new LogHelper(i18nBeanFactory.getI18nBean());
        this.artifactManager = artifactManager;
        this.capabilityContext = capabilityContext;
        this.processService = processService;
    }

    public TaskResult execute(TaskContext taskContext) throws TaskException {
        this.logger.setLogger(taskContext.getBuildLogger());
        ConfigurationMap configMap = taskContext.getConfigurationMap();
        String scanName = this.getFormattedScanName((String)configMap.get((Object)"scanName"), (String)configMap.get((Object)"iac_userName"));
        TaskResultBuilder result = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        taskContext.getBuildLogger().addBuildLogEntry("Qualys IaC Scan Started");
        taskContext.getBuildLogger().addBuildLogEntry("Qualys Platform URL : " + (String)configMap.get((Object)"iac_platFormURL"));
        taskContext.getBuildLogger().addBuildLogEntry("Qualys Username : " + (String)configMap.get((Object)"iac_userName"));
        taskContext.getBuildLogger().addBuildLogEntry("Scan Name : " + scanName);
        taskContext.getBuildLogger().addBuildLogEntry("Directory Path : " + (String)configMap.get((Object)"scanDirectory"));
        taskContext.getBuildLogger().addBuildLogEntry("Failed Results only : " + (configMap.getAsBoolean("showOnlyFailedControls") ? "Yes" : "No"));
        if (configMap.getAsBoolean("isEnbledBuildFailureSetting")) {
            taskContext.getBuildLogger().addBuildLogEntry(MessageFormat.format("Build Failure Conditions High={0}, Medium={1}, Low={2}", configMap.get((Object)"buildFailureSettingHigh"), configMap.get((Object)"buildFailureSettingMedium"), configMap.get((Object)"buildFailureSettingLow")));
        }
        taskContext.getBuildLogger().addBuildLogEntry(MessageFormat.format("Timeout settings scanResultInterval={0}, jobCompletionTotalTime={1}", configMap.get((Object)"timoutSettingScanInterval"), configMap.get((Object)"timoutSettingTotalJobCompletion")));
        QualysServiceImpl iQualysService = new QualysServiceImpl();
        QualysBuildConfiguration qbc = new QualysBuildConfiguration((String)configMap.get((Object)"iac_platFormURL"), (String)configMap.get((Object)"iac_userName"), (String)configMap.get((Object)"iac_password"), Boolean.parseBoolean((String)configMap.get((Object)"showOnlyFailedControls")), scanName, (String)configMap.get((Object)"scanDirectory"));
        Util util = Util.getInstance();
        String DEFAULT_WORKSPACE_DIR = taskContext.getWorkingDirectory().getAbsolutePath();
        taskContext.getBuildLogger().addBuildLogEntry(MessageFormat.format("Workspace directory : {0}", DEFAULT_WORKSPACE_DIR));
        if (qbc.isCredentialsBlank()) {
            taskContext.getBuildLogger().addBuildLogEntry("Unable to launch Qualys IaC Scan due to platform  url, username or password is blank.");
            return this.failbuild(taskContext);
        }
        if (!iQualysService.isUserAuthenticated(qbc)) {
            taskContext.getBuildLogger().addBuildLogEntry("Unable to launch Qualys IaC Scan due to invalid platform  url, username or password.");
            return this.failbuild(taskContext);
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)configMap.get((Object)"scanDirectory")))) {
            taskContext.getBuildLogger().addBuildLogEntry("Unable to launch Qualys IaC Scan due to scan directories are blank.");
            return this.failbuild(taskContext);
        }
        Map<String, Object> map = iQualysService.postZip(DEFAULT_WORKSPACE_DIR, qbc);
        if (map.get("http_post_failed") != null && !Boolean.parseBoolean(map.get("http_post_failed").toString())) {
            String scanUuid = map.get("scanUuid").toString();
            taskContext.getBuildLogger().addBuildLogEntry("Qualys IaC Scan ID : " + scanUuid);
            if (!StringUtils.isEmpty((CharSequence)scanUuid)) {
                boolean isBuildFailed;
                block18: {
                    Instant end;
                    long durationInMinutes;
                    isBuildFailed = false;
                    Instant start = Instant.now();
                    do {
                        try {
                            String scanStatus = iQualysService.getScanStatus(scanUuid, qbc);
                            if (StringUtils.isNotEmpty((CharSequence)scanStatus)) {
                                taskContext.getBuildLogger().addBuildLogEntry(MessageFormat.format("Qualys scan status : {0}", scanStatus));
                                if (scanStatus.equalsIgnoreCase(FINAL_STATUS)) {
                                    try {
                                        int high = Integer.parseInt((String)configMap.get((Object)"buildFailureSettingHigh"));
                                        int medium = Integer.parseInt((String)configMap.get((Object)"buildFailureSettingMedium"));
                                        int low = Integer.parseInt((String)configMap.get((Object)"buildFailureSettingLow"));
                                        FailedStats failedStatsFromBuildConfiguration = new FailedStats(high, medium, low);
                                        String scanResult = iQualysService.getScanResult(scanUuid, qbc);
                                        String buildNumber = String.valueOf(taskContext.getBuildContext().getBuildNumber());
                                        String fileName = "Qualys_IaC_Scan_Reponse_" + buildNumber + ".json";
                                        String filePath = DEFAULT_WORKSPACE_DIR + File.separator + "ScanResult" + File.separator + buildNumber + File.separator + fileName;
                                        FileUtils.writeStringToFile((File)new File(filePath), (String)scanResult, (String)"UTF-8");
                                        taskContext.getBuildLogger().addBuildLogEntry("Qualys IaC Scan Json Response saved  at location : " + filePath);
                                        ScanResult scanResultObj = iQualysService.mapScanResult(scanResult, failedStatsFromBuildConfiguration);
                                        if (scanResultObj.getSummary() != null) {
                                            scanResultObj.setScanId(scanUuid);
                                            scanResultObj.setScanName(qbc.getScanName());
                                            scanResultObj.setFailedResultsOnly(qbc.isFailedResultsOnly());
                                            scanResultObj.setAppliedBuildSetting(Boolean.parseBoolean((String)configMap.get((Object)"isEnbledBuildFailureSetting")));
                                            scanResultObj.setQualysJsonResponse(scanResult);
                                            scanResultObj.setScanStatus(scanStatus);
                                            ObjectWriter ow = new ObjectMapper().writer();
                                            String json = ow.writeValueAsString((Object)scanResultObj);
                                            String encodeJson = ow.writeValueAsString((Object)json);
                                            taskContext.getBuildContext().getBuildResult().getCustomBuildData().put("result", encodeJson);
                                            boolean isBuildFailureSettingsApplied = Boolean.parseBoolean((String)configMap.get((Object)"isEnbledBuildFailureSetting"));
                                            if (isBuildFailureSettingsApplied) {
                                                FailedStats scanResultFailedStats = scanResultObj.getSummary().getFailedStats();
                                                isBuildFailed = iQualysService.checkBuildFailed(scanResultFailedStats, failedStatsFromBuildConfiguration);
                                                taskContext.getBuildLogger().addBuildLogEntry(MessageFormat.format("Scan result failed stats High={0}, Medium={1}, Low={2}", scanResultFailedStats.getHigh(), scanResultFailedStats.getMedium(), scanResultFailedStats.getLow()));
                                            }
                                            taskContext.getBuildLogger().addBuildLogEntry("Qualys IaC scan result mapping ended and IaC scan report generated.");
                                            break block18;
                                        }
                                        taskContext.getBuildLogger().addBuildLogEntry("The scan is FINISHED, but the scan result is empty. Check the scan configuration files.");
                                    }
                                    catch (IOException ex) {
                                        Logger.getLogger(ScannerTask.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                    break block18;
                                }
                                if (scanStatus.equalsIgnoreCase(ERROR_STATUS)) {
                                    taskContext.getBuildLogger().addBuildLogEntry("Getting error after IaC scan");
                                    return this.failbuild(taskContext);
                                }
                            }
                            Thread.sleep(1000 * Integer.parseInt((String)configMap.get((Object)"timoutSettingScanInterval")));
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(ScannerTask.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } while ((durationInMinutes = Duration.between(start, end = Instant.now()).toMinutes()) <= (long)Integer.parseInt((String)configMap.get((Object)"timoutSettingTotalJobCompletion")));
                    taskContext.getBuildLogger().addBuildLogEntry("Qualys IaC scan taking more than " + (String)configMap.get((Object)"timoutSettingTotalJobCompletion") + " minutes, so ignoring IaC Scan report.");
                    return this.failbuild(taskContext);
                }
                if (isBuildFailed) {
                    taskContext.getBuildLogger().addBuildLogEntry("After comparing build failure settings IaC scan result causing build failure.");
                    return this.failbuild(taskContext);
                }
            }
        } else {
            taskContext.getBuildLogger().addBuildLogEntry(map.get(QualysConstants.HTTP_POST_FAILED_REASON).toString());
            taskContext.getBuildLogger().addBuildLogEntry("Unable to post files for IaC Scan.");
            return this.failbuild(taskContext);
        }
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    private TaskResult failbuild(TaskContext taskContext) {
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().stopJobExecutionAfterTask().build();
    }

    public String getFormattedScanName(String scanName, String userName) {
        if (StringUtils.isEmpty((CharSequence)scanName.trim())) {
            return "bamboo_" + userName + "_" + Instant.now().getEpochSecond();
        }
        return scanName;
    }
}

