/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.iac.scan.bamboo.plugin.impl;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskRequirementSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.qualys.iac.scan.bamboo.plugin.model.FieldValidation;
import com.qualys.iac.scan.bamboo.plugin.model.Util;
import com.qualys.iac.scan.bamboo.plugin.validation.UIBambooValidation;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScanTaskConfigurator
extends AbstractTaskConfigurator
implements TaskRequirementSupport {
    private UIConfigSupport uiConfigSupport;
    private I18nBean i18nBean;
    private Util util = Util.getInstance();

    public ScanTaskConfigurator(@ComponentImport I18nBeanFactory i18nBeanFactory) {
        this.uiConfigSupport = (UIConfigSupport)ComponentLocator.getComponent(UIConfigSupport.class);
        this.i18nBean = i18nBeanFactory.getI18nBean();
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("iac_platFormURL", "");
        context.put("iac_userName", "");
        context.put("iac_password", "");
        context.put("scanName", "");
        context.put("scanDirectory", "");
        context.put("showOnlyFailedControls", "false");
        context.put("isEnbledBuildFailureSetting", "false");
        context.put("buildFailureSettingHigh", "0");
        context.put("buildFailureSettingMedium", "0");
        context.put("buildFailureSettingLow", "0");
        context.put("isEnabledTimoutSetting", "false");
        context.put("timoutSettingScanInterval", "30");
        context.put("timoutSettingTotalJobCompletion", "10");
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map config = taskDefinition.getConfiguration();
        context.put("iac_platFormURL", config.get("iac_platFormURL"));
        context.put("iac_userName", config.get("iac_userName"));
        context.put("iac_password", config.get("iac_password"));
        context.put("scanName", config.get("scanName"));
        context.put("scanDirectory", config.get("scanDirectory"));
        context.put("showOnlyFailedControls", config.get("showOnlyFailedControls"));
        context.put("isEnbledBuildFailureSetting", config.get("isEnbledBuildFailureSetting"));
        context.put("buildFailureSettingHigh", config.get("buildFailureSettingHigh"));
        context.put("buildFailureSettingMedium", config.get("buildFailureSettingMedium"));
        context.put("buildFailureSettingLow", config.get("buildFailureSettingLow"));
        context.put("isEnabledTimoutSetting", config.get("isEnabledTimoutSetting"));
        context.put("timoutSettingScanInterval", config.get("timoutSettingScanInterval"));
        context.put("timoutSettingTotalJobCompletion", config.get("timoutSettingTotalJobCompletion"));
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        UIBambooValidation uIValidation = new UIBambooValidation();
        String field = "iac_platFormURL";
        String fieldValue = params.getString("iac_platFormURL");
        FieldValidation fieldValidation = null;
        try {
            fieldValidation = uIValidation.validatePlatformURL(fieldValue);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ScanTaskConfigurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ScanTaskConfigurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.addError(field, fieldValidation, errorCollection);
        field = "iac_userName";
        fieldValue = params.getString("iac_userName");
        fieldValidation = uIValidation.validateUserName(fieldValue);
        this.addError(field, fieldValidation, errorCollection);
        field = "iac_password";
        fieldValue = params.getString("iac_password");
        fieldValidation = uIValidation.validatePassword(fieldValue);
        this.addError(field, fieldValidation, errorCollection);
        field = "scanDirectory";
        fieldValue = params.getString("scanDirectory");
        fieldValidation = uIValidation.isBlankDirectoryPaths(fieldValue);
        this.addError(field, fieldValidation, errorCollection);
        field = "buildFailureSettingHigh";
        fieldValue = params.getString("buildFailureSettingHigh");
        fieldValidation = uIValidation.validateNumber(fieldValue, 0, Integer.MAX_VALUE);
        this.addError(field, fieldValidation, errorCollection);
        field = "buildFailureSettingMedium";
        fieldValue = params.getString("buildFailureSettingMedium");
        fieldValidation = uIValidation.validateNumber(fieldValue, 0, Integer.MAX_VALUE);
        this.addError(field, fieldValidation, errorCollection);
        field = "buildFailureSettingLow";
        fieldValue = params.getString("buildFailureSettingLow");
        fieldValidation = uIValidation.validateNumber(fieldValue, 0, Integer.MAX_VALUE);
        this.addError(field, fieldValidation, errorCollection);
        field = "timoutSettingScanInterval";
        fieldValue = params.getString("timoutSettingScanInterval");
        fieldValidation = uIValidation.validateNumber(fieldValue, Integer.parseInt("10"), Integer.MAX_VALUE);
        this.addError(field, fieldValidation, errorCollection);
        field = "timoutSettingTotalJobCompletion";
        fieldValue = params.getString("timoutSettingTotalJobCompletion");
        fieldValidation = uIValidation.validateNumber(fieldValue, Integer.parseInt("10"), Integer.MAX_VALUE);
        this.addError(field, fieldValidation, errorCollection);
    }

    public void addError(String field, FieldValidation fieldValidation, ErrorCollection errorCollection) {
        if (!fieldValidation.isValid()) {
            errorCollection.addError(field, fieldValidation.getErrorMessage().getMessage());
        }
    }

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("iac_platFormURL", params.getString("iac_platFormURL"));
        config.put("iac_userName", params.getString("iac_userName"));
        config.put("iac_password", params.getString("iac_password"));
        config.put("scanName", params.getString("scanName"));
        config.put("scanDirectory", this.util.correctPath(params.getString("scanDirectory")));
        config.put("showOnlyFailedControls", params.getString("showOnlyFailedControls"));
        config.put("isEnbledBuildFailureSetting", params.getString("isEnbledBuildFailureSetting"));
        config.put("buildFailureSettingHigh", params.getString("buildFailureSettingHigh"));
        config.put("buildFailureSettingMedium", params.getString("buildFailureSettingMedium"));
        config.put("buildFailureSettingLow", params.getString("buildFailureSettingLow"));
        config.put("isEnabledTimoutSetting", params.getString("isEnabledTimoutSetting"));
        config.put("timoutSettingScanInterval", params.getString("timoutSettingScanInterval"));
        config.put("timoutSettingTotalJobCompletion", params.getString("timoutSettingTotalJobCompletion"));
        return config;
    }

    public Set<Requirement> calculateRequirements(TaskDefinition taskDefinition) {
        return new HashSet<Requirement>();
    }
}

