/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.was;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qualys.bamboo.plugin.was.qualysclient.QualysAuth;
import com.qualys.bamboo.plugin.was.qualysclient.QualysWASClient;
import com.qualys.bamboo.plugin.was.qualysclient.QualysWASResponse;
import com.qualys.bamboo.plugin.was.util.Helper;
import com.qualys.plugins.wasPlugin.QualysCriteria.QualysCriteria;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class WASScanLauncher {
    private File workingDirectory;
    private int buildNumber;
    private BuildLogger buildLogger;
    private String webAppId;
    private String scanName;
    private String scanType;
    private String authRecord;
    private String optionProfile;
    private String cancelOptions;
    private String authRecordId;
    private String optionProfileId;
    private String cancelHours;
    private String planKey;
    private int pollingIntervalForVulns;
    private int vulnsTimeout;
    private boolean isFailConditionsConfigured;
    private JsonObject criteriaObject;
    private String encypted_credentials;
    private String portalUrl;
    JsonObject credentials = new JsonObject();
    private QualysWASClient apiClient;
    private boolean failOnScanError;
    private static final Logger logger = Helper.getLogger(WASScanLauncher.class.getName());
    private static final int DEFAULT_POLLING_INTERVAL_FOR_VULNS = 5;
    private static final int DEFAULT_TIMEOUT_FOR_VULNS = 1440;

    public WASScanLauncher(BuildLogger buildLogger, int buildNumber, File workingDirectory, String webAppId, String scanName, String scanType, String authRecord, String optionProfile, String cancelOptions, String authRecordId, String optionProfileId, String cancelHours, boolean isFailConditionsConfigured, String pollingIntervalStr, String vulnsTimeoutStr, JsonObject criteriaObject, String apiServer, String apiUser, String apiPass, boolean useProxy, String proxyServer, int proxyPort, String proxyUsername, String proxyPassword, String portalUrl, boolean failOnScanError, String planKey) {
        this.buildLogger = buildLogger;
        this.webAppId = webAppId;
        this.scanName = scanName;
        this.scanType = scanType;
        this.authRecord = authRecord;
        this.optionProfile = optionProfile;
        this.cancelOptions = cancelOptions;
        this.authRecordId = authRecordId;
        this.optionProfileId = optionProfileId;
        this.cancelHours = cancelHours;
        this.buildNumber = buildNumber;
        this.workingDirectory = workingDirectory;
        this.portalUrl = portalUrl;
        this.planKey = planKey;
        if (scanName != null && !scanName.isEmpty() && !scanName.equals("")) {
            this.scanName = this.scanName + "_[timestamp]";
        }
        this.criteriaObject = criteriaObject;
        this.isFailConditionsConfigured = isFailConditionsConfigured;
        QualysAuth auth = new QualysAuth();
        auth.setQualysCredentials(apiServer, apiUser, apiPass);
        if (useProxy) {
            auth.setProxyCredentials(proxyServer, proxyPort, proxyUsername, proxyPassword);
        }
        this.apiClient = new QualysWASClient(auth, System.out);
        this.pollingIntervalForVulns = this.setTimeoutInMinutes("pollingInterval", 5, pollingIntervalStr, buildLogger);
        this.vulnsTimeout = this.setTimeoutInMinutes("vulnsTimeout", 1440, vulnsTimeoutStr, buildLogger);
        this.failOnScanError = failOnScanError;
        this.credentials.addProperty("apiServer", apiServer);
        this.credentials.addProperty("apiUser", apiUser);
        this.credentials.addProperty("apiPass", apiPass);
        this.credentials.addProperty("proxyServer", proxyServer);
        this.credentials.addProperty("proxyPort", (Number)proxyPort);
        this.credentials.addProperty("proxyUsername", proxyUsername);
        this.credentials.addProperty("proxyPassword", proxyPassword);
        this.credentials.addProperty("useProxy", Boolean.valueOf(useProxy));
    }

    private int setTimeoutInMinutes(String timeoutType, int defaultTimeoutInMins, String timeout, BuildLogger buildLogger) {
        if (timeout != null && !timeout.isEmpty()) {
            try {
                String[] numbers = timeout.split("\\*");
                int timeoutInMins = 1;
                for (int i = 0; i < numbers.length; ++i) {
                    timeoutInMins = (int)((long)timeoutInMins * Long.parseLong(numbers[i]));
                }
                return timeoutInMins;
            }
            catch (Exception e) {
                buildLogger.addBuildLogEntry("Invalid " + timeoutType + " time value. Cannot parse -" + e.getMessage());
                buildLogger.addBuildLogEntry("Using default period of " + (Serializable)(timeoutType.equals("vulnsTimeout") ? "60*24" : Integer.valueOf(defaultTimeoutInMins)) + " minutes for " + timeoutType + ".");
            }
        }
        return defaultTimeoutInMins;
    }

    public void getAndProcessLaunchScanResult() throws Exception {
        block7: {
            try {
                String scanId = this.launchScan();
                if (scanId != null && !scanId.equals("")) {
                    this.buildLogger.addBuildLogEntry(new Timestamp(System.currentTimeMillis()) + " New Scan launched successfully. Scan ID: " + scanId);
                    logger.info("New Scan launched successfully.");
                    JsonObject evaluationResult = null;
                    Gson gson = new Gson();
                    Boolean buildPassed = true;
                    logger.info("isFailConditionsConfigured: " + this.isFailConditionsConfigured);
                    this.credentials.addProperty("scanId", scanId);
                    this.credentials.addProperty("scanName", this.scanName);
                    this.credentials.addProperty("portalUrl", this.portalUrl);
                    this.encypted_credentials = Helper.encrypt(gson.toJson((JsonElement)this.credentials), Integer.toString(this.buildNumber) + this.planKey + "!!@u&y$_w!a^s**");
                    JsonObject encrypted_result = new JsonObject();
                    if (this.isFailConditionsConfigured) {
                        JsonObject result = this.fetchScanResult(scanId);
                        if (result != null) {
                            encrypted_result.addProperty("apiConfig", this.encypted_credentials);
                            Helper.copyJsonToFile(this.workingDirectory.getAbsolutePath().toString(), "qualys_WASScan", this.buildLogger, encrypted_result);
                            evaluationResult = this.evaluateFailurePolicy(result);
                            JsonObject final_result = evaluationResult.getAsJsonObject("result");
                            Helper.copyEvaluationResultToFile(this.workingDirectory.getAbsolutePath().toString(), "qualys_WASScan", this.buildLogger, final_result);
                            buildPassed = evaluationResult.get("passed").getAsBoolean();
                        }
                    } else {
                        encrypted_result.addProperty("apiConfig", this.encypted_credentials);
                        Helper.createNewFile(this.workingDirectory.getAbsolutePath().toString(), "qualys_WASScan", gson.toJson((JsonElement)encrypted_result), this.buildLogger);
                    }
                    if (this.isFailConditionsConfigured && !buildPassed.booleanValue() && evaluationResult != null) {
                        String failureMessage = evaluationResult.get("failureMessage").getAsString();
                        throw new Exception(failureMessage);
                    }
                    break block7;
                }
                throw new Exception("API Error. Could not launch new scan");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.buildLogger.addBuildLogEntry(new Timestamp(System.currentTimeMillis()) + " Error getting scan status: " + e.getMessage());
                throw new Exception(e.getMessage());
            }
        }
    }

    private String getBuildFailureMessages(JsonObject result) throws Exception {
        JsonObject qidsObj;
        boolean qidsPass;
        ArrayList<CallSite> failureMessages = new ArrayList<CallSite>();
        if (result.has("qids") && result.get("qids") != null && !result.get("qids").isJsonNull() && !(qidsPass = (qidsObj = result.get("qids").getAsJsonObject()).get("result").getAsBoolean())) {
            String found = qidsObj.get("found").getAsString();
            failureMessages.add((CallSite)((Object)("QIDs configured in Failure Conditions were found in the scan result : " + found)));
        }
        Object sevConfigured = "\nConfigured : ";
        Object sevFound = "\nFound : ";
        boolean severityFailed = false;
        for (int i = 1; i <= 5; ++i) {
            if (!result.has("severities") || result.get("severities") == null || result.get("severities").isJsonNull()) continue;
            JsonObject sevObj = result.get("severities").getAsJsonObject();
            JsonObject severity = sevObj.get("" + i).getAsJsonObject();
            if (severity.has("members")) {
                severity = severity.get("members").getAsJsonObject();
            }
            if (!severity.has("configured") || severity.get("configured").isJsonNull() || severity.get("configured").getAsInt() == -1) continue;
            sevFound = (String)sevFound + "Severity " + i + ": " + (Serializable)(severity.get("found").isJsonNull() ? Integer.valueOf(0) : severity.get("found").getAsString()) + ";";
            sevConfigured = (String)sevConfigured + "Severity " + i + ">" + severity.get("configured").getAsString() + ";";
            boolean sevPass = severity.get("result").getAsBoolean();
            if (sevPass) continue;
            severityFailed = true;
        }
        if (severityFailed) {
            failureMessages.add((CallSite)((Object)("The vulnerabilities count by severity exceeded one of the configured threshold value :" + (String)sevConfigured + (String)sevFound)));
        }
        return StringUtils.join(failureMessages, "\n");
    }

    public JsonObject evaluateFailurePolicy(JsonObject result) throws Exception {
        Gson gson = new Gson();
        this.buildLogger.addBuildLogEntry("QualysCriteria " + gson.toJson((JsonElement)this.criteriaObject));
        QualysCriteria criteria = new QualysCriteria(gson.toJson((JsonElement)this.criteriaObject), this.buildLogger);
        Boolean passed = criteria.evaluate(result);
        JsonObject obj = new JsonObject();
        obj.add("passed", gson.toJsonTree((Object)passed));
        obj.add("result", (JsonElement)criteria.returnObject);
        if (!passed.booleanValue()) {
            String failureMessage = this.getBuildFailureMessages(criteria.getResult());
            obj.addProperty("failureMessage", failureMessage);
        }
        return obj;
    }

    /*
     * Exception decompiling
     */
    public JsonObject fetchScanResult(String scanId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JsonObject getScanResult(String scanId) {
        JsonObject scanResult = null;
        QualysWASResponse statusResponse = this.apiClient.getScanResult(scanId);
        scanResult = statusResponse.response;
        return scanResult;
    }

    public String getScanFinishedStatus(String scanId) {
        String status = null;
        try {
            QualysWASResponse statusResponse = this.apiClient.getScanStatus(scanId);
            JsonObject result = statusResponse.response;
            JsonElement respEl = result.get("ServiceResponse");
            JsonObject respObj = respEl.getAsJsonObject();
            JsonElement respCodeObj = respObj.get("responseCode");
            if (respCodeObj != null && !respCodeObj.getAsString().equals("SUCCESS")) {
                JsonObject respErr = respObj.getAsJsonObject("responseErrorDetails");
                logger.info("Server Response: " + respErr.toString());
                String reason = respErr.get("errorMessage").getAsString();
                throw new Exception(reason);
            }
            JsonArray dataArr = respObj.getAsJsonArray("data");
            JsonObject obj = dataArr.get(0).getAsJsonObject();
            JsonObject scanObj = obj.getAsJsonObject("WasScan");
            String scanStatus = scanObj.get("status").getAsString();
            String error = "Unknown.";
            try {
                JsonObject summaryObj = scanObj.getAsJsonObject("summary");
                error = summaryObj.get("resultsStatus").getAsString();
            }
            catch (Exception e) {
                logger.info("Could not read error reason from response.");
            }
            if (scanStatus.equalsIgnoreCase("error") || scanStatus.equalsIgnoreCase("canceled") || scanStatus.equalsIgnoreCase("finished") && !error.equalsIgnoreCase("finished")) {
                this.buildLogger.addBuildLogEntry(new Timestamp(System.currentTimeMillis()) + " Scan Status: " + scanStatus + ". Reason: " + error);
                return error;
            }
            this.buildLogger.addBuildLogEntry(new Timestamp(System.currentTimeMillis()) + " Scan Status: " + scanStatus);
            return scanStatus.equalsIgnoreCase("error") || scanStatus.equalsIgnoreCase("canceled") || scanStatus.equalsIgnoreCase("finished") ? scanStatus : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.buildLogger.addBuildLogEntry(new Timestamp(System.currentTimeMillis()) + " Error getting scan status: " + e.getMessage());
            return status;
        }
    }

    public String launchScan() throws Exception {
        JsonObject authRec;
        JsonObject result = new JsonObject();
        JsonObject requestData = new JsonObject();
        Object printLine = "Launching Qualys WAS scan with - ";
        if (this.webAppId == null || this.webAppId.isEmpty() || this.webAppId.equals("")) {
            throw new Exception("Web App ID - Required parameter to launch scan is missing.");
        }
        JsonObject requestObj = new JsonObject();
        JsonObject data = new JsonObject();
        JsonObject wasScan = new JsonObject();
        wasScan.addProperty("type", this.scanType);
        String build_no = Integer.toString(this.buildNumber);
        String timestamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm").format(new Date());
        this.scanName = this.scanName.replaceAll("(?i)\\[build_no\\]", build_no).replaceAll("(?i)\\[timestamp\\]", timestamp);
        wasScan.addProperty("name", this.scanName);
        JsonObject webappDetails = new JsonObject();
        JsonObject webapp = new JsonObject();
        webappDetails.addProperty("id", this.webAppId);
        webapp.add("webApp", (JsonElement)webappDetails);
        if (this.authRecord != null && this.authRecord.equals("Use Default")) {
            authRec = new JsonObject();
            authRec.addProperty("isDefault", "true");
            webapp.add("webAppAuthRecord", (JsonElement)authRec);
        } else if (this.authRecord != null && this.authRecordId != null && this.authRecord.equals("Other") && !this.authRecordId.isEmpty() && !this.authRecordId.equals("")) {
            authRec = new JsonObject();
            authRec.addProperty("id", this.authRecordId);
            webapp.add("webAppAuthRecord", (JsonElement)authRec);
        }
        if (this.cancelHours != null && this.cancelOptions != null && this.cancelOptions.equals("Cancel_After_X_Hours") && !this.cancelHours.isEmpty() && !this.cancelHours.equals("")) {
            wasScan.addProperty("cancelAfterNHours", this.cancelHours);
        }
        if (this.optionProfile != null && this.optionProfileId != null && this.optionProfile.equals("Other") && !this.optionProfileId.isEmpty() && !this.optionProfileId.equals("")) {
            JsonObject profRec = new JsonObject();
            profRec.addProperty("id", this.optionProfileId);
            wasScan.add("profile", (JsonElement)profRec);
        } else if (this.optionProfile != null && this.optionProfile.equals("Use Default")) {
            printLine = (String)printLine + "OptionProfile:Default";
        }
        wasScan.add("target", (JsonElement)webapp);
        data.add("WasScan", (JsonElement)wasScan);
        requestObj.add("data", (JsonElement)data);
        requestData.add("ServiceRequest", (JsonElement)requestObj);
        Map<String, String> webAppDetialsMap = this.getWebappDetails(this.webAppId);
        if (webAppDetialsMap != null && webappDetails.has("warning")) {
            this.buildLogger.addBuildLogEntry("WARNING: " + webAppDetialsMap.get("warning"));
        }
        String webAppName = webAppDetialsMap.get("webAppName");
        this.buildLogger.addBuildLogEntry("Using Web Application: " + webAppName);
        ArrayList<String> scan_ids = new ArrayList<String>();
        this.buildLogger.addBuildLogEntry(new Timestamp(System.currentTimeMillis()) + " Calling Launch Scan API with Payload: " + requestData);
        if (this.isFailConditionsConfigured) {
            this.buildLogger.addBuildLogEntry("Using Build Failure Conditions configuration: " + this.criteriaObject);
        }
        QualysWASResponse response = this.apiClient.launchWASScan(requestData);
        logger.info("API Response: " + response);
        result = response.response;
        JsonElement respEl = result.get("ServiceResponse");
        JsonObject respObj = respEl.getAsJsonObject();
        JsonElement respCodeObj = respObj.get("responseCode");
        if (respCodeObj != null && !respCodeObj.getAsString().equals("SUCCESS")) {
            JsonObject respErr = respObj.getAsJsonObject("responseErrorDetails");
            logger.info("Server Response: " + respErr.toString());
            throw new Exception("Error while launching new scan. Server returned: " + respErr);
        }
        JsonArray dataArr = respObj.get("data").getAsJsonArray();
        if (dataArr.size() == 0) {
            return "";
        }
        for (int i = 0; i < dataArr.size(); ++i) {
            JsonObject obj = dataArr.get(i).getAsJsonObject();
            JsonObject wasObj = obj.get("WasScan").getAsJsonObject();
            String scan_id = wasObj.get("id").getAsString();
            scan_ids.add(scan_id);
        }
        return String.join((CharSequence)", ", scan_ids);
    }

    public Map<String, String> getWebappDetails(String id) throws Exception {
        logger.info("Fetching web app details from server.");
        JsonObject result = new JsonObject();
        HashMap<String, String> webAppDetails = new HashMap<String, String>();
        try {
            QualysWASResponse webAppDetialsResp = this.apiClient.getWebAppDetails(this.webAppId);
            result = webAppDetialsResp.response;
            JsonElement respEl = result.get("ServiceResponse");
            JsonObject respObj = respEl.getAsJsonObject();
            JsonElement respCodeObj = respObj.get("responseCode");
            if (respCodeObj != null && !respCodeObj.getAsString().equals("SUCCESS")) {
                JsonObject respErr = respObj.getAsJsonObject("responseErrorDetails");
                logger.info("Server Response: " + respErr.toString());
                String reason = respErr.get("errorMessage").getAsString();
                throw new Exception(reason);
            }
            JsonArray dataArr = respObj.getAsJsonArray("data");
            for (int i = 0; i < dataArr.size(); ++i) {
                JsonObject scannerObj;
                String scannerAppliance;
                JsonObject obj = dataArr.get(i).getAsJsonObject();
                JsonObject webAppObj = obj.getAsJsonObject("WebApp");
                String webAppName = webAppObj.get("name").getAsString();
                String webAppURL = webAppObj.get("url").getAsString();
                JsonElement scannerEl = webAppObj.get("defaultScanner");
                if (scannerEl != null && !scannerEl.isJsonNull() && (scannerAppliance = (scannerObj = scannerEl.getAsJsonObject()).get("type").getAsString()).toLowerCase().equals("external")) {
                    webAppDetails.put("warning", "Default Scanner Appliance for this webapp is EXTERNAL scanner which will not work and an INTERNAL scanner appliance should be configured as default for the web app.");
                }
                webAppDetails.put("webAppName", webAppName);
                webAppDetails.put("webAppURL", webAppURL);
            }
        }
        catch (Exception e) {
            logger.info("Exception fetching web app details. Reason: " + e.getMessage());
            throw e;
        }
        return webAppDetails;
    }
}

