/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.was;

import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.qualys.bamboo.plugin.was.WASScanLauncher;
import com.qualys.bamboo.plugin.was.qualysclient.QualysAuth;
import com.qualys.bamboo.plugin.was.qualysclient.QualysWASClient;
import com.qualys.bamboo.plugin.was.util.BambooFileStorageHelper;
import com.qualys.bamboo.plugin.was.util.Helper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class QualysWASScanTask
implements TaskType {
    private static final String SCAN_NAME = "[plan_name]_bamboo_build_[build_no]";
    private static final int PROXY_PORT = 80;
    private int buildNumber;
    private String apiServerURL;
    private String portalUrl;
    private String apiUser;
    private String apiPass;
    private String apiServer;
    private String proxyUsername;
    private String proxyPassword;
    private String webAppId;
    private String scanName = "[plan_name]_bamboo_build_[build_no]";
    private String scanType;
    private String authRecord;
    private String optionProfile;
    private String cancelOptions;
    private String authRecordId;
    private String optionProfileId;
    private String cancelHours;
    private String proxyServer;
    private int proxyPort = 80;
    private boolean useProxy = false;
    private String pollingInterval;
    private String vulnsTimeout;
    private boolean isFailOnSevereVulns = false;
    private int severity1Limit;
    private int severity2Limit;
    private int severity3Limit;
    private int severity4Limit;
    private int severity5Limit;
    private boolean isSev1Vulns = false;
    private boolean isSev2Vulns = false;
    private boolean isSev3Vulns = false;
    private boolean isSev4Vulns = false;
    private boolean isSev5Vulns = false;
    private String planKey;
    private BuildContext buildContext;
    private TaskContext taskContext;
    private boolean isFailOnQidFound;
    private String qidList;
    private boolean failOnScanError;
    File artifactDirPath;
    private ArtifactManager artifactManager;
    private static final Logger logger = Logger.getLogger(QualysWASScanTask.class.getName());

    @Autowired
    public QualysWASScanTask(@ComponentImport I18nBeanFactory i18nBeanFactory, @ComponentImport ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute(TaskContext taskContext) throws TaskException {
        this.taskContext = taskContext;
        BuildLogger buildLogger = taskContext.getBuildLogger();
        this.buildContext = taskContext.getBuildContext();
        this.buildNumber = this.buildContext.getBuildNumber();
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = new File("pom.xml").exists() ? reader.read((Reader)new FileReader("pom.xml")) : reader.read((Reader)new InputStreamReader(QualysWASScanTask.class.getResourceAsStream("/META-INF/maven/com.qualys.bamboo.plugin.was/QualysWASBambooPlugin/pom.xml")));
            buildLogger.addBuildLogEntry("###### Qualys Web App Scanning Connector version : " + model.getVersion());
            logger.info(" ########## Qualys Web App Scanning Connector version = " + model.getVersion());
            buildLogger.addBuildLogEntry("When upgrading the connector from v1.0.3 or lower to v1.1.0 or higher, the jobs need to be reconfigured.");
            logger.info("When upgrading the connector from v1.0.3 or lower to v1.1.0 or higher, the jobs need to be reconfigured.");
        }
        catch (Exception e) {
            logger.info("Exception while reading plugin version; Reason :" + e.getMessage());
        }
        ConfigurationMap params = taskContext.getConfigurationMap();
        TaskResult validate_parameters_result = this.validate_parameters(params, buildLogger);
        if (validate_parameters_result != null) {
            return validate_parameters_result;
        }
        this.apiServerURL = (String)params.get((Object)"was_apiServerURL");
        this.apiUser = (String)params.get((Object)"was_username");
        this.apiPass = Helper.decrypt((String)params.get((Object)"was_password"), (String)params.get((Object)"was_username") + "!!@u&y$_w!a^s**");
        this.webAppId = (String)params.get((Object)"webApp");
        this.scanType = (String)params.get((Object)"scanType");
        this.authRecord = (String)params.get((Object)"authRecord");
        this.optionProfile = (String)params.get((Object)"optionProfile");
        this.cancelOptions = (String)params.get((Object)"cancelOption");
        this.authRecordId = (String)params.get((Object)"otherAuthRecord");
        this.optionProfileId = (String)params.get((Object)"otherOptionProfile");
        this.cancelHours = (String)params.get((Object)"cancelHours");
        this.proxyServer = (String)params.get((Object)"was_proxyServer");
        if (params.get((Object)"was_proxyPort") != "") {
            this.proxyPort = Integer.parseInt((String)params.get((Object)"was_proxyPort"));
        }
        this.proxyUsername = (String)params.get((Object)"was_proxyUsername");
        this.proxyPassword = Helper.decrypt((String)params.get((Object)"was_proxyPassword"), (String)params.get((Object)"was_proxyUsername") + "!!@u&y$_w!a^s**");
        this.pollingInterval = (String)params.get((Object)"frequency");
        this.useProxy = Boolean.parseBoolean((String)params.get((Object)"was_useProxy"));
        this.vulnsTimeout = (String)params.get((Object)"timeout");
        this.scanName = (String)params.get((Object)"scanName");
        this.isFailOnSevereVulns = Boolean.parseBoolean((String)params.get((Object)"failOnSeverity"));
        String sev1 = (String)params.get((Object)"severity1");
        String sev2 = (String)params.get((Object)"severity2");
        String sev3 = (String)params.get((Object)"severity3");
        String sev4 = (String)params.get((Object)"severity4");
        String sev5 = (String)params.get((Object)"severity5");
        this.severity1Limit = sev1 != null && !sev1.isEmpty() ? Integer.parseInt(sev1) : -1;
        this.severity2Limit = sev2 != null && !sev2.isEmpty() ? Integer.parseInt(sev2) : -1;
        this.severity3Limit = sev3 != null && !sev3.isEmpty() ? Integer.parseInt(sev3) : -1;
        this.severity4Limit = sev4 != null && !sev4.isEmpty() ? Integer.parseInt(sev4) : -1;
        this.severity5Limit = sev5 != null && !sev5.isEmpty() ? Integer.parseInt(sev5) : -1;
        this.isSev1Vulns = Boolean.parseBoolean((String)params.get((Object)"isSev1Vulns"));
        this.isSev2Vulns = Boolean.parseBoolean((String)params.get((Object)"isSev2Vulns"));
        this.isSev3Vulns = Boolean.parseBoolean((String)params.get((Object)"isSev3Vulns"));
        this.isSev4Vulns = Boolean.parseBoolean((String)params.get((Object)"isSev4Vulns"));
        this.isSev5Vulns = Boolean.parseBoolean((String)params.get((Object)"isSev5Vulns"));
        this.isFailOnQidFound = Boolean.parseBoolean((String)params.get((Object)"failOnQID"));
        this.qidList = (String)params.get((Object)"qidList");
        this.failOnScanError = Boolean.parseBoolean((String)params.get((Object)"notScanWebAppFailBuild"));
        this.scanName = this.scanName.replaceAll("(?i)\\[plan_name\\]", this.buildContext.getPlanName());
        this.planKey = this.buildContext.getPlanKey();
        PlanResultKey resultKey = PlanKeys.getPlanResultKey((String)this.planKey, (int)this.buildNumber);
        BambooFileStorageHelper storageHelper = new BambooFileStorageHelper();
        ArtifactDefinitionContext artifact = storageHelper.getRiskReportArtifactDefinitionContext(null);
        storageHelper.setResultKey(resultKey);
        storageHelper.setArtifactDefinition(artifact);
        storageHelper.setResultKey(resultKey);
        try {
            this.artifactDirPath = new File(taskContext.getWorkingDirectory(), "Qualys_WAS_Plugin_Artifacts");
        }
        catch (Exception e1) {
            buildLogger.addErrorLogEntry("Error finding build dir path : " + this.artifactDirPath + " ; " + e1.getMessage() + "Cause " + e1.getCause());
            for (StackTraceElement traceElement : e1.getStackTrace()) {
                buildLogger.addErrorLogEntry("\tat " + traceElement);
            }
            logger.log(Level.INFO, e1.getMessage(), e1.getCause());
        }
        if (this.webAppId != null && !this.webAppId.isEmpty()) {
            try {
                this.launchWebAppScan(buildLogger, this.scanName, this.buildNumber, this.artifactDirPath);
            }
            catch (Exception e) {
                buildLogger.addErrorLogEntry("Error: " + e.getMessage());
                e.printStackTrace();
                ArrayList<String> errors = new ArrayList<String>();
                errors.add(e.getMessage());
                this.buildContext.getBuildResult().addBuildErrors(errors);
                TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
                return taskResult;
            }
            finally {
                this.generateArtifacts();
            }
        } else {
            buildLogger.addBuildLogEntry("No WebApp ID Configured.");
            ArrayList<String> errors = new ArrayList<String>();
            errors.add("WebApp ID can't be set to null or empty.");
            this.buildContext.getBuildResult().addBuildErrors(errors);
            return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
        }
        this.buildContext.getBuildResult().getCustomBuildData().put("buildDirPath", this.artifactDirPath.getAbsolutePath().toString());
        this.buildContext.getBuildResult().getCustomBuildData().put("images", this.webAppId);
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }

    public TaskResult validate_parameters(ConfigurationMap params, BuildLogger buildLogger) {
        Pattern patt;
        Matcher matcher;
        String stageTimeout;
        Pattern patt2;
        Matcher matcher2;
        String apiServer;
        String URL_REGEX = "^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        String TIMEOUT_PERIOD_REGEX = "^(\\d+[*]?)*(?<!\\*)$";
        String PROXY_REGEX = "(([(a-z)].[(a-z)].[(a-z)].[(a-z)]){3,})|(^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$)";
        ArrayList<String> errors = new ArrayList<String>();
        String sayValue = (String)params.get((Object)"was_username");
        if (StringUtils.isEmpty(sayValue)) {
            buildLogger.addBuildLogEntry("username: You must specify a Qualys Username");
            errors.add("username: You must specify a Qualys Username");
        }
        String password = (String)params.get((Object)"was_password");
        if (StringUtils.isEmpty(sayValue)) {
            buildLogger.addBuildLogEntry("password: You must specify a Qualys Password");
            errors.add("password: You must specify a Qualys Password");
        }
        if (StringUtils.isEmpty(apiServer = (String)params.get((Object)"was_apiServerURL"))) {
            buildLogger.addBuildLogEntry("apiServerURL: You must specify a Qualys API server to connect to");
            errors.add("apiServerURL: You must specify a Qualys API server to connect to");
        } else {
            Pattern patt3 = Pattern.compile(URL_REGEX);
            Matcher matcher3 = patt3.matcher(apiServer);
            if (!matcher3.matches()) {
                buildLogger.addBuildLogEntry("apiServerURL: API Server URL is not valid!");
                errors.add("apiServerURL: API Server URL is not valid!");
            }
        }
        String pollingInterval = (String)params.get((Object)"frequency");
        if (!StringUtils.isEmpty(pollingInterval) && !(matcher2 = (patt2 = Pattern.compile(TIMEOUT_PERIOD_REGEX)).matcher(pollingInterval)).matches()) {
            buildLogger.addBuildLogEntry("frequency: Polling interval is not valid!");
            errors.add("frequency: Polling interval is not valid!");
        }
        if (!StringUtils.isEmpty(stageTimeout = (String)params.get((Object)"timeout")) && !(matcher = (patt = Pattern.compile(TIMEOUT_PERIOD_REGEX)).matcher(stageTimeout)).matches()) {
            buildLogger.addBuildLogEntry("timeout: Timeout period is not valid!");
            errors.add("timeout: Timeout period is not valid!");
        }
        boolean failOnQID = Boolean.parseBoolean((String)params.get((Object)"failOnQID"));
        String QIDs = (String)params.get((Object)"qidList");
        if (failOnQID) {
            if (QIDs == null || StringUtils.isEmpty(QIDs)) {
                buildLogger.addBuildLogEntry("qidList: Enter valid QID range/numbers");
                errors.add("qidList: Enter valid QID range/numbers");
            } else {
                try {
                    String[] qidsString;
                    for (String qid : qidsString = QIDs.split(",")) {
                        if (qid.contains("-")) {
                            int lastInRange;
                            String[] range = qid.split("-");
                            int firstInRange = Integer.parseInt(range[0].trim());
                            if (firstInRange <= (lastInRange = Integer.parseInt(range[1].trim()))) continue;
                            buildLogger.addBuildLogEntry("qidList: Enter valid QID range");
                            errors.add("qidList: Enter valid QID range");
                            continue;
                        }
                        int range = Integer.parseInt(qid.trim());
                    }
                }
                catch (Exception e) {
                    buildLogger.addBuildLogEntry("qidList: Enter valid QID range/numbers");
                    errors.add("qidList: Enter valid QID range/numbers");
                }
            }
        }
        boolean useProxy = Boolean.parseBoolean((String)params.get((Object)"was_useProxy"));
        String proxyServer = (String)params.get((Object)"was_proxyServer");
        if (useProxy) {
            if (StringUtils.isEmpty(proxyServer)) {
                buildLogger.addBuildLogEntry("proxyServer: You must specify a Proxy server to connect to");
                errors.add("proxyServer: You must specify a Proxy server to connect to");
            } else {
                Pattern patt4 = Pattern.compile(PROXY_REGEX);
                Matcher matcher4 = patt4.matcher(proxyServer);
                if (!matcher4.matches()) {
                    buildLogger.addBuildLogEntry("proxyServer: Enter valid Proxy server!");
                    errors.add("proxyServer: Enter valid Proxy server!");
                }
            }
        }
        String port = (String)params.get((Object)"was_proxyPort");
        this.validateNumberField("proxyPort", port, useProxy, errors, buildLogger);
        boolean isSev1 = Boolean.parseBoolean((String)params.get((Object)"isSev1Vulns"));
        String sev1 = (String)params.get((Object)"severity1");
        this.validateNumberField("severity1", sev1, isSev1, errors, buildLogger);
        boolean isSev2 = Boolean.parseBoolean((String)params.get((Object)"isSev2Vulns"));
        String sev2 = (String)params.get((Object)"severity2");
        this.validateNumberField("severity2", sev2, isSev2, errors, buildLogger);
        boolean isSev3 = Boolean.parseBoolean((String)params.get((Object)"isSev3Vulns"));
        String sev3 = (String)params.get((Object)"severity3");
        this.validateNumberField("severity3", sev3, isSev3, errors, buildLogger);
        boolean isSev4 = Boolean.parseBoolean((String)params.get((Object)"isSev4Vulns"));
        String sev4 = (String)params.get((Object)"severity4");
        this.validateNumberField("severity4", sev4, isSev4, errors, buildLogger);
        boolean isSev5 = Boolean.parseBoolean((String)params.get((Object)"isSev5Vulns"));
        String sev5 = (String)params.get((Object)"severity5");
        this.validateNumberField("severity5", sev5, isSev5, errors, buildLogger);
        boolean failOnSeverity = Boolean.parseBoolean((String)params.get((Object)"failOnSeverity"));
        if (!(!failOnSeverity || isSev1 || isSev2 || isSev3 || isSev4 || isSev5)) {
            buildLogger.addBuildLogEntry("failOnSeverity: None of the severity level settings selected");
            errors.add("failOnSeverity: None of the severity level settings selected");
        }
        if (errors.size() != 0) {
            this.buildContext.getBuildResult().addBuildErrors(errors);
            return TaskResultBuilder.newBuilder((CommonTaskContext)this.taskContext).failed().build();
        }
        return null;
    }

    public void validateNumberField(String field, String value, boolean isEnabled, List<String> errors, BuildLogger buildLogger) {
        if (isEnabled) {
            if (value == null || StringUtils.isEmpty(value)) {
                buildLogger.addBuildLogEntry(field + ": Enter valid number!");
                errors.add(field + " Enter valid number!");
            } else {
                try {
                    int severity = Integer.parseInt(value);
                    if (severity < 0) {
                        buildLogger.addBuildLogEntry(field + ": Enter valid number!");
                        errors.add(field + " Please enter a valid number.");
                    }
                }
                catch (Exception e) {
                    buildLogger.addBuildLogEntry(field + ": Enter a valid number!");
                    errors.add(field + " Enter a valid number!");
                }
            }
        }
    }

    public JsonObject getCriteriaAsJsonObject() {
        JsonObject obj = new JsonObject();
        JsonObject failConditionsObj = new JsonObject();
        Gson gson = new Gson();
        if (this.isFailOnQidFound) {
            if (this.qidList == null || this.qidList.isEmpty()) {
                JsonArray empty = new JsonArray();
                failConditionsObj.add("qids", (JsonElement)empty);
            } else {
                List<String> qids = Arrays.asList(this.qidList.split(","));
                qids.replaceAll(String::trim);
                JsonElement element = gson.toJsonTree(qids, new TypeToken<List<String>>(){}.getType());
                failConditionsObj.add("qids", element);
            }
        }
        if (this.isFailOnSevereVulns) {
            JsonObject severities = new JsonObject();
            if (this.isSev5Vulns) {
                severities.addProperty("5", (Number)this.severity5Limit);
            }
            if (this.isSev4Vulns) {
                severities.addProperty("4", (Number)this.severity4Limit);
            }
            if (this.isSev3Vulns) {
                severities.addProperty("3", (Number)this.severity3Limit);
            }
            if (this.isSev2Vulns) {
                severities.addProperty("2", (Number)this.severity2Limit);
            }
            if (this.isSev1Vulns) {
                severities.addProperty("1", (Number)this.severity1Limit);
            }
            failConditionsObj.add("severities", (JsonElement)severities);
        }
        if (this.failOnScanError) {
            failConditionsObj.addProperty("failOnScanError", Boolean.valueOf(true));
        }
        obj.add("failConditions", (JsonElement)failConditionsObj);
        logger.info("Criteria Object to common library: " + obj);
        return obj;
    }

    public void launchWebAppScan(BuildLogger buildLogger, String buildSummary, int buildNumber, File artifactDirPath) throws Exception {
        if (StringUtils.isEmpty(this.apiServerURL)) {
            buildLogger.addBuildLogEntry("apiServerURL value is empty or null.");
            return;
        }
        this.apiServer = this.apiServerURL;
        this.portalUrl = this.getPortalUrl(this.apiServerURL);
        buildLogger.addBuildLogEntry("Using Qualys API server: " + this.portalUrl);
        QualysAuth auth = new QualysAuth();
        auth.setQualysCredentials(this.apiServer, this.apiUser, this.apiPass);
        if (this.useProxy) {
            auth.setProxyCredentials(this.proxyServer, this.proxyPort, this.proxyUsername, this.proxyPassword);
        }
        QualysWASClient client = new QualysWASClient(auth, System.out);
        try {
            buildLogger.addBuildLogEntry("Testing connection with Qualys API Server...");
            client.testConnection();
            buildLogger.addBuildLogEntry("Test connection successful.");
        }
        catch (Exception e) {
            buildLogger.addBuildLogEntry("Test connection failed. Reason: " + e.getMessage());
            throw new Exception(e.getMessage());
        }
        if (this.webAppId == null || this.webAppId.isEmpty()) {
            buildLogger.addBuildLogEntry("No webApp ID configured.");
            return;
        }
        boolean isFailConditionsConfigured = false;
        if (this.isFailOnQidFound || this.isFailOnSevereVulns || this.failOnScanError) {
            isFailConditionsConfigured = true;
        }
        WASScanLauncher launcher = new WASScanLauncher(buildLogger, buildNumber, artifactDirPath, this.webAppId, this.scanName, this.scanType, this.authRecord, this.optionProfile, this.cancelOptions, this.authRecordId, this.optionProfileId, this.cancelHours, isFailConditionsConfigured, this.pollingInterval, this.vulnsTimeout, this.getCriteriaAsJsonObject(), this.apiServer, this.apiUser, this.apiPass, this.useProxy, this.proxyServer, this.proxyPort, this.proxyUsername, this.proxyPassword, this.portalUrl, this.failOnScanError, this.planKey);
        logger.info("Qualys task - Started Launching web app scanning with WAS.");
        launcher.getAndProcessLaunchScanResult();
        buildLogger.addBuildLogEntry("Qualys task - Finished.");
        logger.info("Qualys task - Finished.");
    }

    public void generateArtifacts() {
        PlanResultKey planResultKey = this.buildContext.getPlanResultKey();
        BuildLogger buildLogger = this.taskContext.getBuildLogger();
        BambooFileStorageHelper storageHelper = new BambooFileStorageHelper();
        File baseDirectory = this.artifactDirPath;
        Map runtimeMap = this.taskContext.getRuntimeTaskContext();
        SecureToken token = SecureToken.createFromString((String)((String)runtimeMap.get("qualys_task_secure_token")));
        ArtifactDefinitionContext artifact = storageHelper.getRiskReportArtifactDefinitionContext(token);
        HashMap config = new HashMap();
        logger.info("##############  Custom build data key 'published' =" + (String)this.buildContext.getBuildResult().getCustomBuildData().get("published"));
        ArtifactPublishingResult publishResult = this.artifactManager.publish(buildLogger, planResultKey, baseDirectory, artifact, config, 1);
        this.taskContext.getBuildContext().getArtifactContext().addPublishingResult(publishResult);
        try {
            if (!publishResult.shouldContinueBuild()) {
                logger.info("ERROR: Could not publish the artifact for the Qualys scan Report");
                FileUtils.deleteDirectory((File)this.artifactDirPath);
            } else {
                FileUtils.deleteDirectory((File)this.artifactDirPath);
                logger.info("Deleting the artifacts from working directory after publish to server");
            }
        }
        catch (IOException e) {
            logger.info("Failed deleting the artifacts from working directory : " + e.getMessage());
        }
    }

    public String getPortalUrl(String apiServerURL) {
        String SCP_URL_PREFIX = "https://qualysguard.";
        String PCP_URL_PREFIX = "https://qualysgateway.";
        String[] arr = apiServerURL.split("\\.");
        String rest_url = String.join((CharSequence)".", Arrays.copyOfRange(arr, 1, arr.length));
        Object portalUrl = "";
        portalUrl = rest_url.contains("qualys.") || rest_url.contains("apps.qualys") ? SCP_URL_PREFIX + rest_url : PCP_URL_PREFIX + rest_url;
        logger.info("Converting serverUrl: " + apiServerURL + " to portalUrl:" + (String)portalUrl);
        return portalUrl;
    }
}

