/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.was;

import com.atlassian.bamboo.build.PlanResultsAction;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.qualys.bamboo.plugin.was.qualysclient.QualysAuth;
import com.qualys.bamboo.plugin.was.qualysclient.QualysWASClient;
import com.qualys.bamboo.plugin.was.qualysclient.QualysWASResponse;
import com.qualys.bamboo.plugin.was.util.BambooFileStorageHelper;
import com.qualys.bamboo.plugin.was.util.Helper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;

@Scanned
public class ViewBuildQualysWASReport
extends PlanResultsAction {
    private File workingDirectory;
    private JsonObject failReason;
    private JsonObject totalVulnsTrend;
    private JsonObject typeDetected;
    private Map<String, String> reportResult;
    private String scanId;
    private String status;
    private String scanReference;
    private String targetUrl;
    private String webAppId;
    private String scanName;
    private JsonObject evaluationResult;
    private String portalUrl;
    private String reportUrl;
    private String apiServer;
    private String apiUser;
    private String apiPass;
    private boolean useProxy;
    private String proxyServer;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private JSONObject scanResult;
    private static final Logger logger = Logger.getLogger(ViewBuildQualysWASReport.class.getName());
    private String filename;

    public String execute() throws Exception {
        this.reportResult = new HashMap<String, String>();
        this.reportResult.put("status", "1");
        this.totalVulnsTrend = new JsonObject();
        this.failReason = new JsonObject();
        this.typeDetected = new JsonObject();
        String planKey = this.getPlanKey();
        PlanResultKey resultKey = PlanKeys.getPlanResultKey((String)planKey, (int)this.buildNumber);
        BambooFileStorageHelper storageHelper = new BambooFileStorageHelper();
        ArtifactDefinitionContext artifact = storageHelper.getRiskReportArtifactDefinitionContext(null);
        storageHelper.setResultKey(resultKey);
        storageHelper.setArtifactDefinition(artifact);
        storageHelper.setResultKey(resultKey);
        try {
            this.workingDirectory = storageHelper.buildArtifactRootDirectory();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.reportResult.put("status", "0");
            this.reportResult.put("message", "Artifact working directory not found: " + e1.getMessage());
            logger.info("Artifact working directory not found: " + e1.getMessage());
            return "error";
        }
        this.filename = this.workingDirectory.getAbsolutePath() + File.separator + "qualys_WASScan.json";
        try {
            File f = new File(this.filename);
            new Gson();
            if (f.exists()) {
                String resultStr = FileUtils.readFileToString((File)f);
                JsonObject respObj = new JsonParser().parse(resultStr).getAsJsonObject();
                if (respObj.has("apiConfig") && !respObj.get("apiConfig").isJsonNull()) {
                    String str_credentials = respObj.get("apiConfig").getAsString();
                    if ((str_credentials = Helper.decrypt(str_credentials, this.buildNumber + planKey + "!!@u&y$_w!a^s**")) != null) {
                        JsonObject credentials = new JsonParser().parse(str_credentials).getAsJsonObject();
                        this.apiServer = credentials.get("apiServer").getAsString();
                        this.apiUser = credentials.get("apiUser").getAsString();
                        this.apiPass = credentials.get("apiPass").getAsString();
                        this.useProxy = credentials.get("useProxy").getAsBoolean();
                        this.proxyServer = credentials.get("proxyServer").getAsString();
                        this.proxyPort = credentials.get("proxyPort").getAsInt();
                        this.proxyUsername = credentials.get("proxyUsername").getAsString();
                        this.proxyPassword = credentials.get("proxyPassword").getAsString();
                        this.scanId = credentials.get("scanId").getAsString();
                        this.scanName = credentials.get("scanName").getAsString();
                        this.portalUrl = credentials.get("portalUrl").getAsString();
                    } else {
                        logger.info("failed to decrypt apiConfig.");
                    }
                } else {
                    logger.info("apiConfig not found in artifact");
                }
                this.reportUrl = (this.portalUrl.endsWith("/") ? this.portalUrl : this.portalUrl + "/") + "was/#/reports/online-reports/email-report/scan/" + this.scanId;
            } else {
                this.reportResult.put("status", "0");
                this.reportResult.put("message", "No report available for this scan");
            }
        }
        catch (Exception e) {
            logger.info("Error parsing credentials: " + e.getMessage());
            e.printStackTrace();
            return "error";
        }
        return "success";
    }

    public String getScanId() {
        return this.scanId;
    }

    public String getWebAppId() {
        return this.webAppId;
    }

    public String getScanName() {
        return this.scanName;
    }

    public String getReportUrl() {
        return this.reportUrl;
    }

    public Map<String, String> getReportResult() {
        return this.reportResult;
    }

    public JSONObject getScanResult() {
        this.scanResult = new JSONObject();
        JsonObject respObj = null;
        try {
            Object obj;
            File f = new File(this.filename);
            Gson gson = new Gson();
            if (!f.exists()) {
                logger.info("Artifact not found");
                throw new Exception("Artifact not found");
            }
            String resultStr = FileUtils.readFileToString((File)f);
            respObj = new JsonParser().parse(resultStr).getAsJsonObject();
            if (!respObj.has("ServiceResponse")) {
                QualysAuth auth = new QualysAuth();
                auth.setQualysCredentials(this.apiServer, this.apiUser, this.apiPass);
                if (this.useProxy) {
                    auth.setProxyCredentials(this.proxyServer, this.proxyPort, this.proxyUsername, this.proxyPassword);
                }
                QualysWASClient qualysClient = new QualysWASClient(auth, System.out);
                QualysWASResponse response = qualysClient.getScanResult(this.scanId);
                respObj = response.response;
            }
            if (respObj.has("evaluationResult") && !respObj.get("evaluationResult").isJsonNull()) {
                this.scanResult.put("isEvaluationResult", (Object)1);
                JsonElement respEl = respObj.get("evaluationResult");
                JsonObject evalresult = respEl.getAsJsonObject();
                GsonBuilder builder = new GsonBuilder();
                Gson gsonObject = builder.serializeNulls().create();
                String sevVulnsJson = gsonObject.toJson(evalresult);
                JsonElement sevVulnsElement = gsonObject.fromJson(sevVulnsJson, JsonElement.class);
                this.scanResult.put("evaluationResult", JSONObject.fromObject(gsonObject.toJson(sevVulnsElement)));
            } else {
                this.scanResult.put("isEvaluationResult", (Object)0);
                this.scanResult.put("evaluationResult", JSONObject.fromObject("{}"));
            }
            JsonObject serviceResp = respObj.get("ServiceResponse").getAsJsonObject();
            JsonElement respCodeObj = serviceResp.get("responseCode");
            if (respCodeObj != null && !respCodeObj.getAsString().equalsIgnoreCase("SUCCESS")) {
                JsonObject respErr = serviceResp.getAsJsonObject("responseErrorDetails");
                logger.info("Server Response: " + respErr.toString());
                String reason = respErr.get("errorMessage").getAsString();
                throw new Exception(reason);
            }
            String[] summaryAttrs = new String[]{"linksCrawled", "nbRequests", "resultsStatus", "authStatus"};
            JsonArray dataArr = serviceResp.get("data").getAsJsonArray();
            JsonObject scanObj = dataArr.get(0).getAsJsonObject().get("WasScan").getAsJsonObject();
            JsonObject summary = scanObj.get("summary").getAsJsonObject();
            for (int i = 0; i < summaryAttrs.length; ++i) {
                try {
                    this.scanResult.put(summaryAttrs[i], summary.get(summaryAttrs[i]).getAsString());
                    continue;
                }
                catch (NullPointerException exc) {
                    logger.info("Couldn't fetch " + summaryAttrs[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(summaryAttrs[i], " - ");
                    continue;
                }
                catch (Exception exc) {
                    logger.info("Couldn't fetch " + summaryAttrs[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(summaryAttrs[i], "Exception: " + exc.getMessage());
                }
            }
            try {
                String scanDuration = scanObj.get("scanDuration").getAsString();
                long secondsL = Long.parseLong(scanDuration, 10);
                String readableTime = Helper.secondsToReadableTime(secondsL);
                this.scanResult.put("scanDuration", readableTime);
            }
            catch (NullPointerException exc) {
                logger.info("Couldn't fetch scanDuration info. Reason: " + exc.getMessage());
                this.scanResult.put("scanDuration", "Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch scanDuration info. Reason: " + exc.getMessage());
                this.scanResult.put("scanDuration", "Exception: " + exc.getMessage());
            }
            try {
                String scanRef = scanObj.get("reference").getAsString();
                this.scanResult.put("reference", scanRef);
                this.scanReference = scanRef;
            }
            catch (NullPointerException exc) {
                logger.info("Couldn't fetch reference info. Reason: " + exc.getMessage());
                this.scanResult.put("reference", "Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch reference info. Reason: " + exc.getMessage());
                this.scanResult.put("reference", "Exception: " + exc.getMessage());
            }
            try {
                JsonObject target = scanObj.get("target").getAsJsonObject();
                JsonObject webapp = target.get("webApp").getAsJsonObject();
                String url = webapp.get("url").getAsString();
                this.scanResult.put("targetUrl", url);
                this.targetUrl = url;
            }
            catch (NullPointerException exc) {
                logger.info("Couldn't fetch targetUrl info. Reason: " + exc.getMessage());
                this.scanResult.put("targetUrl", "Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch targetUrl info. Reason: " + exc.getMessage());
                this.scanResult.put("targetUrl", "Exception: " + exc.getMessage());
            }
            this.scanResult.put("vulnsBySeverity", JSONObject.fromObject("{\"1\": 0,\"2\": 0,\"3\": 0,\"4\": 0,\"5\": 0}"));
            try {
                JsonObject stats = scanObj.get("stats").getAsJsonObject();
                JsonObject global = stats.get("global").getAsJsonObject();
                obj = new JSONObject();
                for (int i = 1; i <= 5; ++i) {
                    ((JSONObject)obj).put("" + i, global.get("nbVulnsLevel" + i).getAsString());
                }
                this.scanResult.put("vulnsBySeverity", obj);
            }
            catch (NullPointerException exc) {
                exc.printStackTrace();
                logger.info("Couldn't fetch Vulnerabilities by Severity info. Reason: " + exc.getMessage());
                this.scanResult.put("vulnsBySeverity", "Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch Vulnerabilities by Severity info. Reason: " + exc.getMessage());
                this.scanResult.put("vulnsBySeverity", "Exception: " + exc.getMessage());
            }
            this.scanResult.put("vulnsTable", JSONObject.fromObject("{list:[]}"));
            String[] vulnsSummary = new String[]{"vulns", "sensitiveContents", "igs"};
            for (int i = 0; i < vulnsSummary.length; ++i) {
                try {
                    obj = scanObj.get(vulnsSummary[i]).getAsJsonObject();
                    String count = ((JsonObject)obj).get("count").getAsString();
                    this.scanResult.put(vulnsSummary[i], count);
                    if (!vulnsSummary[i].equals("vulns") || Integer.parseInt(count) <= 0) continue;
                    this.scanResult.put("vulnsTable", JSONObject.fromObject(gson.toJson((JsonElement)obj)));
                    continue;
                }
                catch (NullPointerException exc) {
                    logger.info("Couldn't fetch " + vulnsSummary[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(vulnsSummary[i], "Couldn't find the value in API Response.");
                    continue;
                }
                catch (Exception exc) {
                    logger.info("Couldn't fetch " + vulnsSummary[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(vulnsSummary[i], "Exception: " + exc.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.info("Error parsing scan Result: " + e.getMessage());
            this.scanResult.put("error", e.getMessage());
            e.printStackTrace();
        }
        return this.scanResult;
    }

    public JSONObject getStatus() {
        JSONObject statusDetails = new JSONObject();
        try {
            if (this.status != null && this.status.equals("FINISHED")) {
                statusDetails.put("value", "FINISHED");
                statusDetails.put("cssClass", "success");
                statusDetails.put("targetUrl", this.targetUrl);
                statusDetails.put("reference", this.scanReference);
            } else if (this.status != null && this.status.equals("CANCELED")) {
                statusDetails.put("cssClass", "CANCELED");
                statusDetails.put("cssClass", "fail");
                statusDetails.put("targetUrl", this.targetUrl);
                statusDetails.put("reference", this.scanReference);
                this.status = "CANCELED";
            } else {
                statusDetails = this.parseScanStatus(this.scanId);
                if (statusDetails.get("value") == "FINISHED") {
                    this.status = "FINISHED";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            statusDetails.put("value", e.getMessage());
            statusDetails.put("cssClass", "error");
        }
        return statusDetails;
    }

    public JSONObject parseScanStatus(String scanId) throws Exception {
        JSONObject statusObj = new JSONObject();
        JsonObject result = new JsonObject();
        QualysAuth auth = new QualysAuth();
        auth.setQualysCredentials(this.apiServer, this.apiUser, this.apiPass);
        if (this.useProxy) {
            auth.setProxyCredentials(this.proxyServer, this.proxyPort, this.proxyUsername, this.proxyPassword);
        }
        QualysWASClient qualysClient = new QualysWASClient(auth, System.out);
        QualysWASResponse resp = qualysClient.getScanDetails(scanId);
        result = resp.response;
        JsonElement respEl = result.get("ServiceResponse");
        JsonObject respObj = respEl.getAsJsonObject();
        JsonElement respCodeObj = respObj.get("responseCode");
        if (respCodeObj != null && !respCodeObj.getAsString().equals("SUCCESS")) {
            JsonObject respErr = respObj.getAsJsonObject("responseErrorDetails");
            logger.info("Server Response: " + respErr.toString());
            String reason = respErr.get("errorMessage").getAsString();
            throw new Exception(reason);
        }
        JsonArray dataArr = respObj.getAsJsonArray("data");
        for (int i = 0; i < dataArr.size(); ++i) {
            JsonElement resultsStatusObj;
            String status;
            JsonObject wasObj;
            block9: {
                JsonObject obj = dataArr.get(i).getAsJsonObject();
                wasObj = obj.getAsJsonObject("WasScan");
                status = wasObj.get("status").getAsString();
                try {
                    String reference = wasObj.get("reference").getAsString();
                    JsonObject targetObj = wasObj.getAsJsonObject("target");
                    JsonObject webObj = targetObj.getAsJsonObject("webApp");
                    String targetUrl = webObj.get("url").getAsString();
                    statusObj.put("reference", reference);
                    statusObj.put("targetUrl", targetUrl);
                }
                catch (Exception e) {
                    if (statusObj.get("reference") != null) {
                        statusObj.put("reference", "");
                    }
                    if (statusObj.get("targetUrl") == null) break block9;
                    statusObj.put("targetUrl", "");
                }
            }
            if (status.equals("FINISHED") || status.equals("COMPLETED")) {
                statusObj.put("value", "FINISHED");
                statusObj.put("cssClass", "success");
                continue;
            }
            statusObj.put("value", status);
            statusObj.put("cssClass", "info");
            JsonObject summaryObj = wasObj.getAsJsonObject("summary");
            if (summaryObj == null || summaryObj.isJsonNull() || (resultsStatusObj = summaryObj.get("resultsStatus")) == null || resultsStatusObj.isJsonNull()) continue;
            statusObj.put("resultsStatus", resultsStatusObj.getAsString());
        }
        return statusObj;
    }
}

