/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.was;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.xwork.TextProvider;
import com.qualys.bamboo.plugin.was.restresource.QualysRestResource;
import com.qualys.bamboo.plugin.was.util.Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualysWASScanTaskConfigurator
extends AbstractTaskConfigurator {
    private static final Logger logger = Logger.getLogger(QualysRestResource.class.getName());
    private TextProvider textProvider;
    public Map<String, String> webAppList = new HashMap<String, String>();
    public Map<String, String> WebAppAuthRecord = new HashMap<String, String>();
    public Map<String, String> OptionProfile = new HashMap<String, String>();
    private LinkedHashMap<String, String> scanTypeList;
    ArrayList<String> paramsList = new ArrayList();

    public QualysWASScanTaskConfigurator() {
        this.paramsList.add("pod");
        this.paramsList.add("was_username");
        this.paramsList.add("webApp");
        this.paramsList.add("scanName");
        this.paramsList.add("scanType");
        this.paramsList.add("was_apiServerURL");
        this.paramsList.add("authRecord");
        this.paramsList.add("otherAuthRecord");
        this.paramsList.add("optionProfile");
        this.paramsList.add("otherOptionProfile");
        this.paramsList.add("cancelOption");
        this.paramsList.add("cancelHours");
        this.paramsList.add("was_useProxy");
        this.paramsList.add("was_proxyServer");
        this.paramsList.add("was_proxyPort");
        this.paramsList.add("was_proxyUsername");
        this.paramsList.add("isSev1Vulns");
        this.paramsList.add("isSev2Vulns");
        this.paramsList.add("isSev3Vulns");
        this.paramsList.add("isSev4Vulns");
        this.paramsList.add("isSev5Vulns");
        this.paramsList.add("severity1");
        this.paramsList.add("severity2");
        this.paramsList.add("severity3");
        this.paramsList.add("severity4");
        this.paramsList.add("severity5");
        this.paramsList.add("qidList");
        this.paramsList.add("failOnQID");
        this.paramsList.add("notScanWebAppFailBuild");
        this.paramsList.add("frequency");
        this.paramsList.add("timeout");
        this.paramsList.add("failOnSeverity");
        this.paramsList.add("rawWebAppList");
        this.paramsList.add("rawAuthRecordList");
        this.paramsList.add("rawOptionProfileList");
    }

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        for (String i : this.paramsList) {
            config.put(i, params.getString(i));
        }
        config.put("was_proxyPassword", Helper.encrypt(params.getString("was_proxyPassword"), (String)config.get("was_proxyUsername") + "!!@u&y$_w!a^s**"));
        config.put("was_password", Helper.encrypt(params.getString("was_password"), (String)config.get("was_username") + "!!@u&y$_w!a^s**"));
        return config;
    }

    public void validateNumberField(String field, String value, boolean isEnabled, ErrorCollection errorCollection) {
        if (isEnabled) {
            if (value == null || StringUtils.isEmpty(value)) {
                errorCollection.addError(field, "Enter valid number!");
            } else {
                try {
                    int severity = Integer.parseInt(value);
                    if (severity < 0) {
                        errorCollection.addError(field, "Please enter a valid number.");
                    }
                }
                catch (Exception e) {
                    errorCollection.addError(field, "Enter a valid number!");
                }
            }
        }
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.getScanType();
        context.put("scanTypeList", this.scanTypeList);
        context.put("scanName", "[plan_name]_bamboo_build_[build_no]");
        context.put("severity1", "0");
        context.put("severity2", "0");
        context.put("severity3", "0");
        context.put("severity4", "0");
        context.put("severity5", "0");
        context.put("frequency", "5");
        context.put("timeout", "60*24");
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        ObjectMapper mapper = new ObjectMapper();
        for (String i : this.paramsList) {
            context.put(i, taskDefinition.getConfiguration().get(i));
        }
        String was_proxy_pass = Helper.decrypt((String)taskDefinition.getConfiguration().get("was_proxyPassword"), (String)taskDefinition.getConfiguration().get("was_proxyUsername") + "!!@u&y$_w!a^s**");
        String was_pass = Helper.decrypt((String)taskDefinition.getConfiguration().get("was_password"), (String)taskDefinition.getConfiguration().get("was_username") + "!!@u&y$_w!a^s**");
        context.put("was_password", was_pass);
        context.put("was_proxyPassword", was_proxy_pass);
        this.getScanType();
        context.put("scanTypeList", this.scanTypeList);
        try {
            this.webAppList = (Map)mapper.readValue((String)taskDefinition.getConfiguration().get("rawWebAppList"), Map.class);
            this.WebAppAuthRecord = (Map)mapper.readValue((String)taskDefinition.getConfiguration().get("rawAuthRecordList"), Map.class);
            this.OptionProfile = (Map)mapper.readValue((String)taskDefinition.getConfiguration().get("rawOptionProfileList"), Map.class);
        }
        catch (JsonParseException e) {
            logger.info("JsonParseException :" + (Object)((Object)e));
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            logger.info("JsonMappingException :" + (Object)((Object)e));
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.info("IOException :" + e);
            e.printStackTrace();
        }
        context.put("webAppList", this.webAppList);
        context.put("otherAuthRecordList", this.WebAppAuthRecord);
        context.put("otherOptionProfileList", this.OptionProfile);
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    private final void getScanType() {
        this.scanTypeList = new LinkedHashMap();
        this.scanTypeList.put("VULNERABILITY", "VULNERABILITY");
        this.scanTypeList.put("DISCOVERY", "DISCOVERY");
    }
}

