(function ($) {
    $(document).on("click", "#was_test_connection", function (event) {
        $('#was_testConnectionMessage').html("");
    	$('#spinner').css({"display":"block"});
        restRequest("test_connection");
        //refresh_drop_down();
    });
    $(document).on("change", "#pod,#was_username,#was_password,#was_proxyServer,#was_proxyPort,#was_proxyUsername,#was_proxyPassword,#was_apiServerURL" , function (event) {
    	if (($('#was_apiServerURL').val().length > 1) && ($('#was_username').val().length > 1) && ($('#was_password').val().length > 1)) {
    		//console.log("call for drop down");
    		refresh_drop_down();
    	}
    });

    $(document).on("click", "#refresh-drop-down" , function (event) {
    	if (($('#was_apiServerURL').val().length > 1) && ($('#was_username').val().length > 1) && ($('#was_password').val().length > 1)) {
    		//console.log("call for refresh drop down values");
    		$('#refresh_spinner').css({"display":"block"});
    		refresh_drop_down();
    		}
    });

    function refresh_drop_down() {
        getWebAppList();
        getAuthRecordIdItems();
        getOptionProfile();
    }
    function restRequest(button) {
        if (!validateFields(button)) {
        	if (button == "test_connection") {
        		$('#spinner').css({"display":"none"});
        	}
        	else {
        		$('#refresh_spinner').css({"display":"none"});
        	}
        	
            return populateEmptyDropdownList();
        }
        var request = JSON.stringify(getInputData());
        var xhr = createRestRequest("POST", "/rest/was_qualys/1.0/test/was_connection");
        if (!xhr) {
            console.log("Request Failed");
            return;
        }
        xhr.onload = function () {
        	var parsed = JSON.parse(xhr.responseText);
            if (xhr.status == 200) {
            	if (button == "test_connection") {
	                $('#was_testConnectionMessage').css('color', 'green');
	                $('#was_testConnectionMessage').html(parsed.response);
            	}
            	else
            	{
            		$('#refreshDropDownValues').css('color', 'green');
	                $('#refreshDropDownValues').html(parsed.response);
            	}
            }
            else {
            	if (button == "test_connection") {
            		$('#was_testConnectionMessage').css('color', '#d22020');
                    $('#was_testConnectionMessage').html(parsed.response);
            	}
            	else
            	{
            		$('#refreshDropDownValues').css('color', '#d22020');
                    $('#refreshDropDownValues').html(parsed.response);
            	}
                
            }
            $('#spinner').css({"display":"none"});
            $('#refresh_spinner').css({"display":"none"});
            
        };
        xhr.onerror = function () {
            console.log('There was an error!');
        };
        xhr.setRequestHeader("Content-Type", "application/json");
        xhr.send(request);
    }

    function validateFields(button) {
    	if (button == "test_connection") {
    		var messageElement = $('#was_testConnectionMessage');
    	}
    	else {
    		var messageElement = $('#refreshDropDownValues');
    	}
        
        if ($('#was_apiServerURL').val().length < 1) {
            messageElement.text('URL must not be empty');
            messageElement.css('color', '#d22020');
            return false;
        } else if ($('#was_username').val().length < 1) {
            messageElement.text('Username must not be empty');
            messageElement.css('color', '#d22020');
            return false;
        } else if ($('#was_password').val().length < 1) {
            messageElement.text('Password must not be empty');
            messageElement.css('color', '#d22020');
            return false;
        }
        return true;
    }
    
    function createRestRequest(method, url) {
        var resolvedUrl = AJS.contextPath() + url;
        var xhr = new XMLHttpRequest();
        if ("withCredentials" in xhr) {
            xhr.open(method, resolvedUrl, true);
        } else if (typeof XDomainRequest != "undefined") {
            xhr = new XDomainRequest();
            xhr.open(method, resolvedUrl);
        } else {
            xhr = null;
        }
        return xhr;
    }

    function getInputData() {
        return {
            "apiServerURL": $("#was_apiServerURL").val(),
            "username": $('#was_username').val(),
            "pas": $('#was_password').val(),
            "useProxy": $("#was_useProxy").is(':checked'),
            "proxyServer": $("#was_proxyServer").val(),
            "proxyPort": $("#was_proxyPort").val(),
            "proxyUser": $("#was_proxyUsername").val(),
            "proxyPass": $("#was_proxyPassword").val(),
        };
    }
    
    function getWebAppList() {
        if (!validateFields()) {
        	 $('#refresh_spinner').css({"display":"none"});
            return populateEmptyDropdownList();
        }
        var request = JSON.stringify(getInputData());
        var xhr = createRestRequest("POST", "/rest/was_qualys/1.0/webapplist");
        if (!xhr) {
            console.log("Request Failed");
            return;
        }
        xhr.onload = function () {
        	var parsed = JSON.parse(xhr.responseText);
            if (xhr.status == 200) {
            	$('#webApp').empty();
            	var sortedResponse = "{";
            	var sortedValues = [];
            	for (var i in parsed.response) {
            		sortedValues.push(i);
            	}
            	sortedValues = sortedValues.sort();
            	for (var i in sortedValues) {
            		$('#webApp').append(AJS.$('<option></option>').val(parsed.response[sortedValues[i]]).html(sortedValues[i]));
            		sortedResponse = sortedResponse + "\"" + parsed.response[sortedValues[i]] + "\":\"" + sortedValues[i] + "\",";
            		
            	}
            	sortedResponse = sortedResponse.substring(0, sortedResponse.length - 1);
            	sortedResponse = sortedResponse + "}"
            	$('#rawWebAppList').empty();
            	$('#rawWebAppList').val(sortedResponse);
        		$('#refreshDropDownValues').css('color', 'green');
                $('#refreshDropDownValues').html(parsed.response);
            }
            else {
            	//$('#webApp').append(AJS.$('<option></option>').val("No Records").html("No Records"));            
        		$('#refreshDropDownValues').css('color', '#d22020');
                $('#refreshDropDownValues').html(parsed.response);
            }
            $('#refresh_spinner').css({"display":"none"});
        };
        xhr.onerror = function () {
            console.log('There was an error!');
        };
        xhr.setRequestHeader("Content-Type", "application/json");
        xhr.send(request);
    }
    
    function getAuthRecordIdItems() {
        if (!validateFields()) {
        	 $('#refresh_spinner').css({"display":"none"});
            return populateEmptyDropdownList();
        }
        var request = JSON.stringify(getInputData());
        var xhr = createRestRequest("POST", "/rest/was_qualys/1.0/authRecordIdItems");
        if (!xhr) {
            console.log("Request Failed");
            return;
        }
        xhr.onload = function () {
        	var parsed = JSON.parse(xhr.responseText);
            if (xhr.status == 200) {
            	$('#otherAuthRecord').empty();
            	var sortedResponse = "{";
            	var sortedValues = [];
            	for (var i in parsed.response) {
            		sortedValues.push(i);
            	}
            	sortedValues = sortedValues.sort();
            	for (var i in sortedValues) {
            		$('#otherAuthRecord').append(AJS.$('<option></option>').val(parsed.response[sortedValues[i]]).html(sortedValues[i]));
            		sortedResponse = sortedResponse + "\"" + parsed.response[sortedValues[i]] + "\":\"" + sortedValues[i] + "\",";
            	}
            	sortedResponse = sortedResponse.substring(0, sortedResponse.length - 1);
            	sortedResponse = sortedResponse + "}"
            	$('#rawAuthRecordList').empty();
            	$('#rawAuthRecordList').val(sortedResponse);
        		$('#refreshDropDownValues').css('color', 'green');
                $('#refreshDropDownValues').html(parsed.response);
            }
            else {
            	//$('#otherAuthRecord').append(AJS.$('<option></option>').val("No Records").html("No Records"));            
        		$('#refreshDropDownValues').css('color', '#d22020');
                $('#refreshDropDownValues').html(parsed.response);
            	}
            $('#refresh_spinner').css({"display":"none"});
        };
        xhr.onerror = function () {
            console.log('There was an error!');
        };
        xhr.setRequestHeader("Content-Type", "application/json");
        xhr.send(request);
    }
    
    function getOptionProfile() {
        if (!validateFields()) {
        	 $('#refresh_spinner').css({"display":"none"});
            return populateEmptyDropdownList();
        }
        var request = JSON.stringify(getInputData());
        var xhr = createRestRequest("POST", "/rest/was_qualys/1.0/optionProfile");
        if (!xhr) {
            console.log("Request Failed");
            return;
        }
        xhr.onload = function () {
        	var parsed = JSON.parse(xhr.responseText);
            if (xhr.status == 200) {
            	$('#otherOptionProfile').empty();
            	var sortedResponse = "{";
            	var sortedValues = [];
            	for (var i in parsed.response) {
            		sortedValues.push(i);
            	}
            	sortedValues = sortedValues.sort();
            	for (var i in sortedValues) {
            		$('#otherOptionProfile').append(AJS.$('<option></option>').val(parsed.response[sortedValues[i]]).html(sortedValues[i]));
            		sortedResponse = sortedResponse + "\"" + parsed.response[sortedValues[i]] + "\":\"" + sortedValues[i] + "\",";
            	}
            	sortedResponse = sortedResponse.substring(0, sortedResponse.length - 1);
            	sortedResponse = sortedResponse + "}"
            	$('#rawOptionProfileList').empty();
            	$('#rawOptionProfileList').val(sortedResponse);
        		$('#refreshDropDownValues').css('color', 'green');
                $('#refreshDropDownValues').html(parsed.response);
            }
            else {
            	//$('#otherOptionProfile').append(AJS.$('<option></option>').val("No Records").html("No Records"));            
        		$('#refreshDropDownValues').css('color', '#d22020');
                $('#refreshDropDownValues').html(parsed.response);
            	}
            $('#refresh_spinner').css({"display":"none"});
        };
        xhr.onerror = function () {
            console.log('There was an error!');
        };
        xhr.setRequestHeader("Content-Type", "application/json");
        xhr.send(request);
    }
})
(AJS.$);
