/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.was.util;

import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.storage.ArtifactDirectoryBuilder;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;

public class BambooFileStorageHelper {
    public static final String ILLEGAL_ARG_MESSAGE_RESULT_KEY = "ResultKey field cannot be null";
    public static final String ILLEGAL_ARG_MESSAGE_ARTIFACT_DEFINITION = "ArtifactDefinition field cannot be null";
    private static final Logger logger = Logger.getLogger(BambooFileStorageHelper.class.getName());
    private PlanResultKey resultKey;
    private ArtifactDefinitionContext artifactDefinition;

    public PlanResultKey getResultKey() {
        return this.resultKey;
    }

    public void setResultKey(PlanResultKey resultKey) {
        this.resultKey = resultKey;
    }

    public ArtifactDefinitionContext getArtifactDefinition() {
        return this.artifactDefinition;
    }

    public void setArtifactDefinition(ArtifactDefinitionContext artifactDefinition) {
        this.artifactDefinition = artifactDefinition;
    }

    public File buildArtifactRootDirectory() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        logger.info("In buildArtifactRootDirectory...  resultkey = " + this.getResultKey() + "  artifactdefinition = " + this.getArtifactDefinition());
        if (this.getResultKey() == null) {
            throw new IllegalArgumentException(ILLEGAL_ARG_MESSAGE_RESULT_KEY);
        }
        if (this.getArtifactDefinition() == null) {
            throw new IllegalArgumentException(ILLEGAL_ARG_MESSAGE_ARTIFACT_DEFINITION);
        }
        File artifactDir = null;
        StorageLocationService storageLocationService = (StorageLocationService)ContainerManager.getComponent((String)"storageLocationService");
        ArtifactDirectoryBuilder artifactDirBuilder = storageLocationService.getDefaultArtifactDirectoryBuilder();
        logger.info("ArtifactDirectoryBuilder  ==  " + artifactDirBuilder);
        artifactDir = artifactDirBuilder.getPlanOrientedArtifactDirectory(this.getResultKey(), (ImmutableArtifactDefinitionBase)this.getArtifactDefinition());
        logger.info("ArtifactDirectory Path ==  " + artifactDir.getAbsolutePath());
        return artifactDir;
    }

    public ArtifactDefinitionContext getRiskReportArtifactDefinitionContext(SecureToken token) {
        ArtifactDefinitionContextImpl artifact = new ArtifactDefinitionContextImpl("Qualys_WAS_Plugin_Artifacts", false, token);
        artifact.setLocation("");
        artifact.setCopyPattern("*");
        return artifact;
    }
}

