/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.bamboo.plugin.was.util;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Helper {
    private static SecretKeySpec secretKey;
    private static byte[] key;
    public static final Map<String, Map<String, String>> platformsList;
    private static final Logger logger;
    public static final String TASK_SECURE_TOKEN = "qualys_task_secure_token";
    public static final String ARTIFACT_DIR_NAME = "Qualys_WAS_Plugin_Artifacts";
    public static final String ENCRYPTION_KEY = "!!@u&y$_w!a^s**";

    public static String secondsToReadableTime(long duration) {
        long days = TimeUnit.SECONDS.toDays(duration);
        long hours = TimeUnit.SECONDS.toHours(duration -= TimeUnit.DAYS.toSeconds(days));
        long minutes = TimeUnit.SECONDS.toMinutes(duration -= TimeUnit.HOURS.toSeconds(hours));
        long seconds = TimeUnit.SECONDS.toSeconds(duration -= TimeUnit.MINUTES.toSeconds(minutes));
        StringBuilder msg = new StringBuilder();
        if (days != 0L) {
            msg.append(days + "day(s) ");
        }
        if (hours != 0L) {
            msg.append(hours + " hr ");
        }
        if (minutes != 0L) {
            msg.append(minutes + " min ");
        }
        if (seconds != 0L) {
            msg.append(seconds + " s ");
        }
        return msg.toString();
    }

    public static Object execXPath(String xml, String xPath, QName type) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            return Helper.execXPath(doc, xPath, type);
        }
        catch (Exception e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            logger.log(Level.INFO, e.getMessage(), e.getCause());
            return null;
        }
    }

    public static Object execXPath(Node node, String xPath, QName type) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Object object = null;
        try {
            object = xpath.evaluate(xPath, node, type);
        }
        catch (XPathExpressionException e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            logger.log(Level.INFO, e.getMessage(), e.getCause());
        }
        return object;
    }

    public static Logger getLogger(String loggerName) {
        Logger pluginLogger = Logger.getLogger(loggerName);
        try {
            pluginLogger.setUseParentHandlers(false);
            QualysLogFormatter formatter = new QualysLogFormatter();
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(formatter);
            pluginLogger.addHandler(handler);
        }
        catch (Exception e) {
            logger.info("Error while formatting logger, reason: " + e.getMessage());
        }
        return pluginLogger;
    }

    public static void createNewFile(String rootDir, String filename, String content, BuildLogger buildLogger) {
        File f = new File(rootDir + File.separator + filename + ".json");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\tat " + traceElement);
                }
                logger.log(Level.INFO, e.getMessage(), e.getCause());
                buildLogger.addBuildLogEntry("Failed creating file " + filename + ", reason =" + e.getMessage());
            }
        }
        try {
            File dir = new File(f.getParentFile(), f.getName());
            PrintWriter writer = new PrintWriter(dir);
            writer.print(content);
            writer.close();
        }
        catch (FileNotFoundException e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            logger.log(Level.INFO, e.getMessage(), e.getCause());
            buildLogger.addBuildLogEntry("Failed writing to file " + filename + ", reason =" + e.getMessage());
        }
    }

    public static void copyEvaluationResultToFile(String rootDir, String filename, BuildLogger buildLogger, JsonObject evalresult) throws IOException {
        Gson gson = new Gson();
        File f = new File(rootDir + File.separator + filename + ".json");
        if (f.exists()) {
            String contentStr = FileUtils.readFileToString((File)f);
            JsonObject respObj = new JsonParser().parse(contentStr).getAsJsonObject();
            GsonBuilder builder = new GsonBuilder();
            gson = builder.serializeNulls().create();
            String sevVulnsJson = gson.toJson(evalresult);
            JsonObject sevVulnsElement = new JsonParser().parse(sevVulnsJson).getAsJsonObject();
            respObj.add("evaluationResult", sevVulnsElement);
            String final_content = gson.toJson(respObj);
            try {
                File dir = new File(f.getParentFile(), f.getName());
                PrintWriter writer = new PrintWriter(dir);
                writer.print(final_content);
                writer.close();
            }
            catch (FileNotFoundException e) {
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\tat " + traceElement);
                }
                logger.log(Level.INFO, e.getMessage(), e.getCause());
                buildLogger.addBuildLogEntry("Failed writing to file " + filename + ", reason =" + e.getMessage());
            }
        }
    }

    public static void copyJsonToFile(String rootDir, String filename, BuildLogger buildLogger, JsonObject evalresult) throws IOException {
        Gson gson = new Gson();
        File f = new File(rootDir + File.separator + filename + ".json");
        if (f.exists()) {
            String contentStr = FileUtils.readFileToString((File)f);
            JsonObject respObj = new JsonParser().parse(contentStr).getAsJsonObject();
            GsonBuilder builder = new GsonBuilder();
            gson = builder.serializeNulls().create();
            Set<Map.Entry<String, JsonElement>> entrySet = evalresult.entrySet();
            for (Map.Entry<String, JsonElement> entry : entrySet) {
                respObj.add(entry.getKey(), evalresult.get(entry.getKey()));
            }
            String final_content = gson.toJson(respObj);
            try {
                File dir = new File(f.getParentFile(), f.getName());
                PrintWriter writer = new PrintWriter(dir);
                writer.print(final_content);
                writer.close();
            }
            catch (FileNotFoundException e) {
                for (StackTraceElement traceElement : e.getStackTrace()) {
                    logger.info("\tat " + traceElement);
                }
                logger.log(Level.INFO, e.getMessage(), e.getCause());
                buildLogger.addBuildLogEntry("Failed writing to file " + filename + ", reason =" + e.getMessage());
            }
        }
    }

    public static void setKey(String myKey) {
        MessageDigest sha = null;
        try {
            key = myKey.getBytes("UTF-8");
            sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            secretKey = new SecretKeySpec(key, "AES");
        }
        catch (NoSuchAlgorithmException e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            logger.log(Level.INFO, e.getMessage(), e.getCause());
        }
        catch (UnsupportedEncodingException e) {
            for (StackTraceElement traceElement : e.getStackTrace()) {
                logger.info("\tat " + traceElement);
            }
            logger.log(Level.INFO, e.getMessage(), e.getCause());
        }
    }

    public static String encrypt(String strToEncrypt, String secret) {
        try {
            Helper.setKey(secret);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes("UTF-8")));
        }
        catch (Exception e) {
            logger.info("Error while encryptting: " + e.toString());
            return null;
        }
    }

    public static String decrypt(String strToDecrypt, String secret) {
        try {
            Helper.setKey(secret);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(2, secretKey);
            return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)));
        }
        catch (Exception e) {
            logger.info("Error while decrypting: " + e.toString());
            return null;
        }
    }

    static {
        LinkedHashMap aList = new LinkedHashMap();
        HashMap<String, String> platform1 = new HashMap<String, String>();
        platform1.put("name", "US Platform 1");
        platform1.put("code", "US_PLATFORM_1");
        platform1.put("url", "https://qualysapi.qualys.com");
        platform1.put("portal", "https://qualysguard.qualys.com");
        aList.put("US_PLATFORM_1", platform1);
        HashMap<String, String> platform2 = new HashMap<String, String>();
        platform2.put("name", "US Platform 2");
        platform2.put("code", "US_PLATFORM_2");
        platform2.put("url", "https://qualysapi.qg2.apps.qualys.com");
        platform2.put("portal", "https://qualysguard.qg2.apps.qualys.com");
        aList.put("US_PLATFORM_2", platform2);
        HashMap<String, String> platform3 = new HashMap<String, String>();
        platform3.put("name", "US Platform 3");
        platform3.put("code", "US_PLATFORM_3");
        platform3.put("url", "https://qualysapi.qg3.apps.qualys.com");
        platform3.put("portal", "https://qualysguard.qg3.apps.qualys.com");
        aList.put("US_PLATFORM_3", platform3);
        HashMap<String, String> platform4 = new HashMap<String, String>();
        platform4.put("name", "US Platform 4");
        platform4.put("code", "US_PLATFORM_4");
        platform4.put("url", "https://qualysapi.qg4.apps.qualys.com");
        platform4.put("portal", "https://qualysguard.qg4.apps.qualys.com");
        aList.put("US_PLATFORM_4", platform4);
        HashMap<String, String> platform5 = new HashMap<String, String>();
        platform5.put("name", "EU Platform 1");
        platform5.put("code", "EU_PLATFORM_1");
        platform5.put("url", "https://qualysapi.qualys.eu");
        platform5.put("portal", "https://qualysguard.qualys.eu");
        aList.put("EU_PLATFORM_1", platform5);
        HashMap<String, String> platform6 = new HashMap<String, String>();
        platform6.put("name", "EU Platform 2");
        platform6.put("code", "EU_PLATFORM_2");
        platform6.put("url", "https://qualysapi.qg2.apps.qualys.eu");
        platform6.put("portal", "https://qualysguard.qg2.apps.qualys.eu");
        aList.put("EU_PLATFORM_2", platform6);
        HashMap<String, String> platform7 = new HashMap<String, String>();
        platform7.put("name", "INDIA Platform");
        platform7.put("code", "INDIA_PLATFORM");
        platform7.put("url", "https://qualysapi.qg1.apps.qualys.in");
        platform7.put("portal", "https://qualysguard.qg1.apps.qualys.in");
        aList.put("INDIA_PLATFORM", platform7);
        HashMap<String, String> platform8 = new HashMap<String, String>();
        platform8.put("name", "CANADA Platform");
        platform8.put("code", "CANADA_PLATFORM");
        platform8.put("url", "https://qualysapi.qg1.apps.qualys.ca");
        platform8.put("portal", "https://qualysguard.qg1.apps.qualys.ca");
        aList.put("CANADA_PLATFORM", platform8);
        HashMap<String, String> platform9 = new HashMap<String, String>();
        platform9.put("name", "Private Cloud Platform");
        platform9.put("code", "PCP");
        platform9.put("url", "");
        aList.put("PCP", platform9);
        platformsList = Collections.unmodifiableMap(aList);
        logger = Logger.getLogger(Helper.class.getName());
    }

    public static class QualysLogFormatter
    extends Formatter {
        private static final DateFormat df = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder(1000);
            builder.append(df.format(new Date(record.getMillis()))).append(" - ");
            builder.append("[").append(record.getSourceClassName()).append(".");
            builder.append(record.getSourceMethodName()).append("] - ");
            builder.append(record.getLevel()).append(": ");
            builder.append(this.formatMessage(record));
            builder.append("\n");
            return builder.toString();
        }

        @Override
        public String getHead(Handler h) {
            return super.getHead(h);
        }

        @Override
        public String getTail(Handler h) {
            return super.getTail(h);
        }
    }
}

